/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;

public class GeoserverOverridingWKTFactory
extends FactoryUsingWKT {
    public static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "user.projections.override.file";

    public GeoserverOverridingWKTFactory() {
        super(null, 100);
    }

    public GeoserverOverridingWKTFactory(Hints userHints) {
        super(userHints, 100);
    }

    protected URL getDefinitionsURL() {
        File proj_file;
        Resource custom_proj;
        GeoServerResourceLoader loader;
        String cust_proj_file = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        if (cust_proj_file == null && (loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)) != null && (custom_proj = loader.get("user_projections/epsg_overrides.properties")).getType() == Resource.Type.RESOURCE) {
            cust_proj_file = custom_proj.file().getAbsolutePath();
        }
        if (cust_proj_file != null && (proj_file = new File(cust_proj_file)).exists()) {
            URL url = DataUtilities.fileToURL((File)proj_file);
            if (url != null) {
                return url;
            }
            LOGGER.log(Level.SEVERE, "Had troubles converting " + cust_proj_file + " to URL");
        }
        cust_proj_file = "override_epsg.properties";
        return GeoserverOverridingWKTFactory.class.getResource(cust_proj_file);
    }
}

