/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import java.net.URL;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.data.DataUtilities;
import org.geotools.factory.AbstractFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.opengis.metadata.citation.Citation;

public class GeoserverGridShiftLocator
extends AbstractFactory
implements GridShiftLocator {
    public GeoserverGridShiftLocator() {
        super(60);
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public URL locateGrid(String grid) {
        if (grid == null) {
            return null;
        }
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        if (loader == null) {
            return null;
        }
        Resource gridfile = loader.get("user_projections/" + grid);
        if (gridfile.getType() == Resource.Type.RESOURCE) {
            return DataUtilities.fileToURL((File)gridfile.file());
        }
        return null;
    }
}

