/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.vfny.geoserver.util.Requests;

public abstract class Request {
    protected HttpServletRequest httpServletRequest;
    protected String service;
    protected String request = "";
    protected String version = "";
    protected ServiceInfo serviceConfig;
    protected String baseUrl;

    protected Request(String service, String request, ServiceInfo serviceConfig) {
        this.service = service;
        this.request = request;
        this.serviceConfig = serviceConfig;
    }

    public void setBaseUrl(String s) {
        this.baseUrl = s;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String requestType) {
        this.request = requestType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceInfo getServiceConfig() {
        return this.serviceConfig;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request req = (Request)o;
        boolean equals = true;
        boolean bl = (this.request == null ? req.getRequest() == null : this.request.equals(req.getRequest())) && equals ? true : (equals = false);
        boolean bl2 = (this.version == null ? req.getVersion() == null : this.version.equals(req.getVersion())) && equals ? true : (equals = false);
        equals = (this.service == null ? req.getService() == null : this.service.equals(req.getService())) && equals;
        return equals;
    }

    public int hashCode() {
        int result = 17;
        result = 23 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 23 * result + (this.request == null ? 0 : this.version.hashCode());
        result = 23 * result + (this.request == null ? 0 : this.service.hashCode());
        return result;
    }

    public HttpServletRequest getHttpServletRequest() throws ClassCastException {
        return this.httpServletRequest;
    }

    public String getRootDir() {
        throw new IllegalArgumentException("getRootDir -- functionality removed - please verify that its okay with geoserver_data_dir");
    }

    public boolean isLoggedIn() {
        return Requests.isLoggedIn(this.getHttpServletRequest());
    }

    public void setHttpServletRequest(HttpServletRequest servletRequest) {
        this.httpServletRequest = servletRequest;
    }
}

