/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NoExternalEntityResolver
implements EntityResolver {
    public static final String ERROR_MESSAGE_BASE = "Entity resolution disallowed for ";
    private static final Logger LOGGER = Logging.getLogger(NoExternalEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("resolveEntity request: publicId=" + publicId + ", systemId=" + systemId);
        }
        if (systemId != null && systemId.matches("(?i)(jar:file|http|vfs)[^?#;]*\\.xsd")) {
            return null;
        }
        throw new SAXException(ERROR_MESSAGE_BASE + systemId);
    }
}

