/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.config.FileBasedSecurityServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.Util;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.geoserver.security.xml.UserGroupXMLXpath;
import org.geoserver.security.xml.XMLGeoserverUser;
import org.geoserver.security.xml.XMLSecurityServiceConfig;
import org.geoserver.security.xml.XMLUserGroupStore;
import org.geoserver.security.xml.XMLValidator;
import org.geoserver.security.xml.XMLXpathFactory;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUserGroupService
extends AbstractUserGroupService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected DocumentBuilder builder;
    protected File userFile;
    private boolean validatingXMLSchema = true;

    public XMLUserGroupService() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        String alias;
        KeyStoreProvider prov;
        this.name = config.getName();
        this.validatingXMLSchema = false;
        this.passwordEncoderName = ((SecurityUserGroupServiceConfig)config).getPasswordEncoderName();
        this.passwordValidatorName = ((SecurityUserGroupServiceConfig)config).getPasswordPolicyName();
        GeoServerPasswordEncoder enc = this.getSecurityManager().loadPasswordEncoder(this.passwordEncoderName);
        if (enc.getEncodingType() == PasswordEncodingType.ENCRYPT && !(prov = this.getSecurityManager().getKeyStoreProvider()).containsAlias(alias = prov.aliasForGroupService(this.name))) {
            prov.setUserGroupKey(this.name, this.getSecurityManager().getRandomPassworddProvider().getRandomPasswordWithDefaultLength());
            prov.storeKeyStore();
        }
        enc.initializeFor(this);
        if (config instanceof XMLSecurityServiceConfig) {
            this.validatingXMLSchema = ((XMLSecurityServiceConfig)config).isValidating();
            File xsdFile = new File(this.getConfigRoot(), "users.xsd");
            if (!xsdFile.exists()) {
                FileUtils.copyURLToFile((URL)this.getClass().getResource("users.xsd"), (File)xsdFile);
            }
        }
        if (config instanceof FileBasedSecurityServiceConfig) {
            String fileName = ((FileBasedSecurityServiceConfig)config).getFileName();
            this.userFile = new File(fileName);
            if (!this.userFile.isAbsolute()) {
                this.userFile = new File(this.getConfigRoot(), fileName);
            }
            if (!this.userFile.exists()) {
                FileUtils.copyURLToFile((URL)this.getClass().getResource("usersTemplate.xml"), (File)this.userFile);
            }
        } else {
            throw new IOException("Cannot initialize from " + config.getClass().getName());
        }
        this.deserialize();
    }

    @Override
    public boolean canCreateStore() {
        return true;
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        XMLUserGroupStore store = new XMLUserGroupStore();
        store.initializeFromService(this);
        return store;
    }

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    protected void deserialize() throws IOException {
        try {
            Document doc = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.userFile);
                doc = this.builder.parse(is);
            }
            catch (SAXException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            if (this.isValidatingXMLSchema()) {
                XMLValidator.Singleton.validateUserGroupRegistry(doc);
            }
            XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionUR();
            String versionNummer = expr.evaluate(doc);
            UserGroupXMLXpath xmlXPath = XMLXpathFactory.Singleton.getUserGroupXMLXpath(versionNummer);
            this.clearMaps();
            NodeList userNodes = (NodeList)xmlXPath.getUserListExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                boolean userEnabled = Util.convertToBoolean(xmlXPath.getUserEnabledExpression().evaluate(userNode), true);
                String userPassword = null;
                if (userNode.getAttributes().getNamedItem("password") != null) {
                    userPassword = xmlXPath.getUserPasswordExpression().evaluate(userNode);
                }
                String userName = xmlXPath.getUserNameExpression().evaluate(userNode);
                NodeList propertyNodes = (NodeList)xmlXPath.getUserPropertiesExpression().evaluate(userNode, XPathConstants.NODESET);
                Properties userProps = new Properties();
                for (int j = 0; j < propertyNodes.getLength(); ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    String propertyName = xmlXPath.getPropertyNameExpression().evaluate(propertyNode);
                    String propertyValue = xmlXPath.getPropertyValueExpression().evaluate(propertyNode);
                    userProps.put(propertyName, propertyValue);
                }
                GeoServerUser user = this.createUserObject(userName, userPassword, userEnabled);
                this.helper.userMap.put(user.getUsername(), user);
                user.getProperties().clear();
                for (Object key : userProps.keySet()) {
                    user.getProperties().put(key, userProps.get(key));
                    SortedSet<GeoServerUser> propUsers = this.helper.propertyMap.get(key);
                    if (propUsers == null) {
                        propUsers = new TreeSet<GeoServerUser>();
                        this.helper.propertyMap.put((String)key, propUsers);
                    }
                    propUsers.add(user);
                }
            }
            NodeList groupNodes = (NodeList)xmlXPath.getGroupListExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                String groupName = xmlXPath.getGroupNameExpression().evaluate(groupNode);
                boolean groupEnabled = Util.convertToBoolean(xmlXPath.getGroupEnabledExpression().evaluate(groupNode), true);
                GeoServerUserGroup group = this.createGroupObject(groupName, groupEnabled);
                this.helper.groupMap.put(groupName, group);
                NodeList memberNodes = (NodeList)xmlXPath.getGroupMemberListExpression().evaluate(groupNode, XPathConstants.NODESET);
                for (int j = 0; j < memberNodes.getLength(); ++j) {
                    Node memberNode = memberNodes.item(j);
                    String memberName = xmlXPath.getGroupMemberNameExpression().evaluate(memberNode);
                    GeoServerUser member = this.helper.userMap.get(memberName);
                    SortedSet<GeoServerUser> members = this.helper.group_userMap.get(group);
                    if (members == null) {
                        members = new TreeSet<GeoServerUser>();
                        this.helper.group_userMap.put(group, members);
                    }
                    members.add(member);
                    SortedSet<GeoServerUserGroup> userGroups = this.helper.user_groupMap.get(member);
                    if (userGroups == null) {
                        userGroups = new TreeSet<GeoServerUserGroup>();
                        this.helper.user_groupMap.put(member, userGroups);
                    }
                    userGroups.add(group);
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        XMLGeoserverUser user = new XMLGeoserverUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }
}

