/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.file.LockFile;
import org.geoserver.security.impl.AbstractRoleStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.xml.XMLRoleService;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLRoleStore
extends AbstractRoleStore {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected File roleFile;
    protected LockFile lockFile = null;
    private boolean validatingXMLSchema = true;

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    public void initializeFromService(GeoServerRoleService service) throws IOException {
        this.roleFile = ((XMLRoleService)service).roleFile;
        this.validatingXMLSchema = ((XMLRoleService)service).isValidatingXMLSchema();
        super.initializeFromService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serialize() throws IOException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1);
        }
        Document doc = builder.newDocument();
        Element rolereg = doc.createElement("roleRegistry");
        doc.appendChild(rolereg);
        rolereg.setAttribute("xmlns", "http://www.geoserver.org/security/roles");
        rolereg.setAttribute("version", "1.0");
        Element rolelist = doc.createElement("roleList");
        rolereg.appendChild(rolelist);
        for (GeoServerRole roleObject : this.helper.roleMap.values()) {
            Element role = doc.createElement("role");
            rolelist.appendChild(role);
            role.setAttribute("id", roleObject.getAuthority());
            GeoServerRole parentObject = this.helper.role_parentMap.get(roleObject);
            if (parentObject != null) {
                role.setAttribute("parentID", parentObject.getAuthority());
            }
            for (Object key : roleObject.getProperties().keySet()) {
                Element property = doc.createElement("property");
                role.appendChild(property);
                property.setAttribute("name", key.toString());
                property.setTextContent(roleObject.getProperties().getProperty(key.toString()));
            }
        }
        Element userList = doc.createElement("userList");
        rolereg.appendChild(userList);
        for (String userName : this.helper.user_roleMap.keySet()) {
            Element userroles = doc.createElement("userRoles");
            userList.appendChild(userroles);
            userroles.setAttribute("username", userName);
            SortedSet<GeoServerRole> roleObjects = this.helper.user_roleMap.get(userName);
            for (GeoServerRole roleObject : roleObjects) {
                Element ref = doc.createElement("roleRef");
                userroles.appendChild(ref);
                ref.setAttribute("roleID", roleObject.getAuthority());
            }
        }
        Element groupList = doc.createElement("groupList");
        rolereg.appendChild(groupList);
        for (String groupName : this.helper.group_roleMap.keySet()) {
            Element grouproles = doc.createElement("groupRoles");
            groupList.appendChild(grouproles);
            grouproles.setAttribute("groupname", groupName);
            SortedSet<GeoServerRole> roleObjects = this.helper.group_roleMap.get(groupName);
            for (GeoServerRole roleObject : roleObjects) {
                Element ref = doc.createElement("roleRef");
                grouproles.appendChild(ref);
                ref.setAttribute("roleID", roleObject.getAuthority());
            }
        }
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("method", "XML");
            tx.setOutputProperty("encoding", "UTF-8");
            tx.setOutputProperty("indent", "yes");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.roleFile));
            try {
                tx.transform(new DOMSource(doc), new StreamResult(out));
                ((OutputStream)out).flush();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void deserialize() throws IOException {
        super.deserialize();
        this.releaseLock();
    }

    public String toString() {
        return this.getName();
    }

    protected void ensureLock() throws IOException {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = new LockFile(this.roleFile);
        try {
            this.lockFile.writeLock();
        }
        catch (IOException ex) {
            this.lockFile = null;
            throw ex;
        }
    }

    protected void releaseLock() {
        if (this.lockFile == null) {
            return;
        }
        this.lockFile.writeUnLock();
        this.lockFile = null;
    }

    @Override
    public void addRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        super.addRole(role);
    }

    @Override
    public void updateRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        super.updateRole(role);
    }

    @Override
    public boolean removeRole(GeoServerRole role) throws IOException {
        this.ensureLock();
        return super.removeRole(role);
    }

    @Override
    public void store() throws IOException {
        this.ensureLock();
        super.store();
        this.releaseLock();
    }

    @Override
    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        this.ensureLock();
        super.disAssociateRoleFromGroup(role, groupname);
    }

    @Override
    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        this.ensureLock();
        super.associateRoleToGroup(role, groupname);
    }

    @Override
    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        this.ensureLock();
        super.associateRoleToUser(role, username);
    }

    @Override
    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        this.ensureLock();
        super.disAssociateRoleFromUser(role, username);
    }

    @Override
    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        this.ensureLock();
        super.setParentRole(role, parentRole);
    }

    @Override
    public void clear() throws IOException {
        this.ensureLock();
        super.clear();
    }
}

