/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.FileBasedSecurityServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.xml.RoleXMLXpath;
import org.geoserver.security.xml.XMLRoleStore;
import org.geoserver.security.xml.XMLSecurityServiceConfig;
import org.geoserver.security.xml.XMLValidator;
import org.geoserver.security.xml.XMLXpathFactory;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLRoleService
extends AbstractRoleService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected DocumentBuilder builder;
    protected File roleFile;
    private boolean validatingXMLSchema = true;

    public XMLRoleService() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.validatingXMLSchema = false;
        if (config instanceof XMLSecurityServiceConfig) {
            this.validatingXMLSchema = ((XMLSecurityServiceConfig)config).isValidating();
            File xsdFile = new File(this.getConfigRoot(), "roles.xsd");
            if (!xsdFile.exists()) {
                FileUtils.copyURLToFile((URL)this.getClass().getResource("roles.xsd"), (File)xsdFile);
            }
        }
        if (config instanceof FileBasedSecurityServiceConfig) {
            String fileName = ((FileBasedSecurityServiceConfig)config).getFileName();
            this.roleFile = new File(fileName);
            if (!this.roleFile.isAbsolute()) {
                this.roleFile = new File(this.getConfigRoot(), fileName);
            }
            if (!this.roleFile.exists()) {
                FileUtils.copyURLToFile((URL)this.getClass().getResource("rolesTemplate.xml"), (File)this.roleFile);
            }
        } else {
            throw new IOException("Cannot initialize from " + config.getClass().getName());
        }
        this.deserialize();
    }

    @Override
    public boolean canCreateStore() {
        return true;
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        XMLRoleStore store = new XMLRoleStore();
        store.initializeFromService(this);
        return store;
    }

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    protected void deserialize() throws IOException {
        try {
            String roleName;
            Node roleNode;
            int i;
            Document doc = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.roleFile);
                doc = this.builder.parse(is);
            }
            catch (SAXException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            if (this.isValidatingXMLSchema()) {
                XMLValidator.Singleton.validateRoleRegistry(doc);
            }
            XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionRR();
            String versioNummer = expr.evaluate(doc);
            RoleXMLXpath xmlXPath = XMLXpathFactory.Singleton.getRoleXMLXpath(versioNummer);
            this.clearMaps();
            NodeList roleNodes = (NodeList)xmlXPath.getRoleListExpression().evaluate(doc, XPathConstants.NODESET);
            for (i = 0; i < roleNodes.getLength(); ++i) {
                roleNode = roleNodes.item(i);
                roleName = xmlXPath.getRoleNameExpression().evaluate(roleNode);
                NodeList propertyNodes = (NodeList)xmlXPath.getRolePropertiesExpression().evaluate(roleNode, XPathConstants.NODESET);
                Properties roleProps = new Properties();
                for (int j = 0; j < propertyNodes.getLength(); ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    String propertyName = xmlXPath.getPropertyNameExpression().evaluate(propertyNode);
                    String propertyValue = xmlXPath.getPropertyValueExpression().evaluate(propertyNode);
                    roleProps.put(propertyName, propertyValue);
                }
                GeoServerRole role = this.createRoleObject(roleName);
                role.getProperties().clear();
                for (Object key : roleProps.keySet()) {
                    role.getProperties().put(key, roleProps.get(key));
                }
                this.helper.roleMap.put(roleName, role);
            }
            for (i = 0; i < roleNodes.getLength(); ++i) {
                roleNode = roleNodes.item(i);
                roleName = xmlXPath.getRoleNameExpression().evaluate(roleNode);
                String parentName = xmlXPath.getParentExpression().evaluate(roleNode);
                if (parentName == null || parentName.length() <= 0) continue;
                this.helper.role_parentMap.put(this.helper.roleMap.get(roleName), this.helper.roleMap.get(parentName));
            }
            NodeList userRolesNodes = (NodeList)xmlXPath.getUserRolesExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i2 = 0; i2 < userRolesNodes.getLength(); ++i2) {
                Node userRolesNode = userRolesNodes.item(i2);
                String userName = xmlXPath.getUserNameExpression().evaluate(userRolesNode);
                TreeSet<GeoServerRole> roleSet = new TreeSet<GeoServerRole>();
                this.helper.user_roleMap.put(userName, roleSet);
                NodeList userRolesRefNodes = (NodeList)xmlXPath.getUserRolRefsExpression().evaluate(userRolesNode, XPathConstants.NODESET);
                for (int j = 0; j < userRolesRefNodes.getLength(); ++j) {
                    Node userRolesRefNode = userRolesRefNodes.item(j);
                    String roleRef = xmlXPath.getUserRolRefNameExpression().evaluate(userRolesRefNode);
                    roleSet.add(this.helper.roleMap.get(roleRef));
                }
            }
            NodeList groupRolesNodes = (NodeList)xmlXPath.getGroupRolesExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i3 = 0; i3 < groupRolesNodes.getLength(); ++i3) {
                Node groupRolesNode = groupRolesNodes.item(i3);
                String groupName = xmlXPath.getGroupNameExpression().evaluate(groupRolesNode);
                TreeSet<GeoServerRole> roleSet = new TreeSet<GeoServerRole>();
                this.helper.group_roleMap.put(groupName, roleSet);
                NodeList groupRolesRefNodes = (NodeList)xmlXPath.getGroupRolRefsExpression().evaluate(groupRolesNode, XPathConstants.NODESET);
                for (int j = 0; j < groupRolesRefNodes.getLength(); ++j) {
                    Node groupRolesRefNode = groupRolesRefNodes.item(j);
                    String roleRef = xmlXPath.getGroupRolRefNameExpression().evaluate(groupRolesRefNode);
                    roleSet.add(this.helper.roleMap.get(roleRef));
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new IOException(ex);
        }
    }
}

