/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geotools.util.logging.Logging;

public class Util {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    public static boolean convertToBoolean(String booleanString, boolean defaultValue) {
        if (booleanString == null || booleanString.trim().length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(booleanString.trim());
    }

    public static void copyFrom(GeoServerUserGroupService service, GeoServerUserGroupStore store) throws IOException, PasswordPolicyException {
        GeoServerUserGroup newGroup;
        GeoServerPasswordEncoder encoder = store.getSecurityManager().loadPasswordEncoder(store.getPasswordEncoderName());
        encoder.initializeFor(store);
        GeoServerMultiplexingPasswordEncoder mEncoder = new GeoServerMultiplexingPasswordEncoder(store.getSecurityManager(), service);
        store.clear();
        HashMap<String, GeoServerUser> newUserDict = new HashMap<String, GeoServerUser>();
        HashMap<String, GeoServerUserGroup> newGroupDict = new HashMap<String, GeoServerUserGroup>();
        for (GeoServerUser user : service.getUsers()) {
            String rawPassword = null;
            String encPassword = null;
            try {
                rawPassword = mEncoder.decode(user.getPassword());
                encPassword = encoder.encodePassword(rawPassword, null);
            }
            catch (UnsupportedOperationException ex) {
                LOGGER.warning("Cannot recode user: " + user.getUsername() + " password: " + user.getPassword());
                encPassword = user.getPassword();
            }
            GeoServerUser newUser = store.createUserObject(user.getUsername(), encPassword, user.isEnabled());
            for (Object key : user.getProperties().keySet()) {
                newUser.getProperties().put(key, user.getProperties().get(key));
            }
            store.addUser(newUser);
            newUserDict.put(newUser.getUsername(), newUser);
        }
        for (GeoServerUserGroup group : service.getUserGroups()) {
            newGroup = store.createGroupObject(group.getGroupname(), group.isEnabled());
            store.addGroup(newGroup);
            newGroupDict.put(newGroup.getGroupname(), newGroup);
        }
        for (GeoServerUserGroup group : service.getUserGroups()) {
            newGroup = (GeoServerUserGroup)newGroupDict.get(group.getGroupname());
            for (GeoServerUser member : service.getUsersForGroup(group)) {
                GeoServerUser newUser = (GeoServerUser)newUserDict.get(member.getUsername());
                store.associateUserToGroup(newUser, newGroup);
            }
        }
    }

    public static void copyFrom(GeoServerRoleService service, GeoServerRoleStore store) throws IOException {
        GeoServerRole newRole;
        store.clear();
        HashMap<String, GeoServerRole> newRoleDict = new HashMap<String, GeoServerRole>();
        for (GeoServerRole role : service.getRoles()) {
            newRole = store.createRoleObject(role.getAuthority());
            for (Object key : role.getProperties().keySet()) {
                newRole.getProperties().put(key, role.getProperties().get(key));
            }
            store.addRole(newRole);
            newRoleDict.put(newRole.getAuthority(), newRole);
        }
        for (GeoServerRole role : service.getRoles()) {
            GeoServerRole parentRole = service.getParentRole(role);
            GeoServerRole newRole2 = (GeoServerRole)newRoleDict.get(role.getAuthority());
            GeoServerRole newParentRole = parentRole == null ? null : (GeoServerRole)newRoleDict.get(parentRole.getAuthority());
            store.setParentRole(newRole2, newParentRole);
        }
        for (GeoServerRole role : service.getRoles()) {
            newRole = (GeoServerRole)newRoleDict.get(role.getAuthority());
            SortedSet<String> usernames = service.getUserNamesForRole(role);
            for (String username : usernames) {
                store.associateRoleToUser(newRole, username);
            }
            SortedSet<String> groupnames = service.getGroupNamesForRole(role);
            for (String groupname : groupnames) {
                store.associateRoleToGroup(newRole, groupname);
            }
        }
    }

    public static String convertPropsToString(Properties props, String heading) {
        StringBuffer buff = new StringBuffer();
        if (heading != null) {
            buff.append(heading).append("\n\n");
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            buff.append(entry.getKey().toString()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return buff.toString();
    }

    public static Properties loadUniversal(InputStream in) throws IOException {
        String xmlDeclarationStart = "<?xml";
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(4096);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bin));
        String line = reader.readLine();
        boolean isXML = line.startsWith("<?xml");
        bin.reset();
        Properties props = new Properties();
        if (isXML) {
            props.loadFromXML(bin);
        } else {
            props.load(bin);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertyFile(File f) throws IOException {
        try (FileInputStream fin = new FileInputStream(f);){
            Properties properties = Util.loadUniversal(fin);
            return properties;
        }
    }

    public static void recodePasswords(GeoServerUserGroupStore store) throws IOException {
        GeoServerPasswordEncoder encoder = store.getSecurityManager().loadPasswordEncoder(store.getPasswordEncoderName());
        encoder.initializeFor(store);
        GeoServerMultiplexingPasswordEncoder mEncoder = new GeoServerMultiplexingPasswordEncoder(store.getSecurityManager(), store);
        for (GeoServerUser user : store.getUsers()) {
            if (encoder.isResponsibleForEncoding(user.getPassword())) continue;
            try {
                String rawpass = mEncoder.decode(user.getPassword());
                String encPass = encoder.encodePassword(rawpass, null);
                user.setPassword(encPass);
                try {
                    store.updateUser(user);
                }
                catch (PasswordPolicyException e) {
                    store.load();
                    throw new RuntimeException("Never should reach this point", (Throwable)((Object)e));
                }
            }
            catch (UnsupportedOperationException ex) {
                LOGGER.warning("Cannot recode user: " + user.getUsername() + " with password: " + user.getPassword());
            }
        }
        store.store();
    }
}

