/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;

public class GeoServerUserDao
implements UserDetailsService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    TreeMap<String, User> userMap;
    PropertyFileWatcher userDefinitionsFile;

    public static GeoServerUserDao get() {
        return (GeoServerUserDao)GeoServerExtensions.bean(GeoServerUserDao.class);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.checkUserMap();
        UserDetails user = (UserDetails)this.userMap.get(username);
        if (user == null) {
            throw new UsernameNotFoundException("Could not find user: " + username);
        }
        return user;
    }

    void checkUserMap() throws DataAccessResourceFailureException {
        try {
            if (this.userMap == null || this.userDefinitionsFile == null || this.userDefinitionsFile.isStale()) {
                if (this.userDefinitionsFile == null) {
                    Resource propFile = this.findUserProperties();
                    this.userDefinitionsFile = new PropertyFileWatcher(propFile);
                }
                this.userMap = this.loadUsersFromProperties(this.userDefinitionsFile.getProperties());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "An error occurred loading user definitions", e);
        }
    }

    private Resource findUserProperties() throws IOException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource propFile = loader.get("security/users.properties");
        InputStream is = null;
        OutputStream os = null;
        try {
            if (propFile.getType() == Resource.Type.RESOURCE) {
                Properties p = new Properties();
                GeoServerInfo global = ((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal();
                if (global != null && global.getAdminUsername() != null && !global.getAdminUsername().trim().equals("")) {
                    p.put(global.getAdminUsername(), global.getAdminPassword() + ",ROLE_ADMINISTRATOR");
                } else {
                    p.put("admin", "geoserver,ROLE_ADMINISTRATOR");
                }
                os = propFile.out();
                p.store(os, "Format: name=password,ROLE1,...,ROLEN");
                os.close();
                Resource serviceFile = loader.get("security/service.properties");
                os = serviceFile.out();
                is = GeoServerUserDao.class.getResourceAsStream("serviceTemplate.properties");
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((count = is.read(buffer)) > 0) {
                    os.write(buffer, 0, count);
                }
                Resource resource = propFile;
                return resource;
            }
            throw new FileNotFoundException("Unable to find security/users.properties");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ei) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException eo) {}
            }
        }
    }

    public List<String> getRoles() {
        this.checkUserMap();
        TreeSet<String> roles = new TreeSet<String>();
        roles.add("ROLE_ADMINISTRATOR");
        for (User user : this.getUsers()) {
            for (GrantedAuthority ga : user.getAuthorities()) {
                roles.add(ga.getAuthority());
            }
        }
        return new ArrayList<String>(roles);
    }

    public List<User> getUsers() {
        this.checkUserMap();
        return new ArrayList<User>(this.userMap.values());
    }

    public void putUser(User user) {
        this.checkUserMap();
        if (this.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " already exists");
        }
        this.userMap.put(user.getUsername(), user);
    }

    public void setUser(User user) {
        this.checkUserMap();
        if (!this.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " already exists");
        }
        this.userMap.put(user.getUsername(), user);
    }

    public boolean removeUser(String username) {
        this.checkUserMap();
        return this.userMap.remove(username) != null;
    }

    public void storeUsers() throws IOException {
        try (OutputStream os = null;){
            Properties p = this.storeUsersToProperties(this.userMap);
            Resource propFile = this.userDefinitionsFile.getResource();
            os = propFile.out();
            p.store(os, null);
        }
    }

    public void reload() {
        this.userDefinitionsFile = null;
    }

    TreeMap<String, User> loadUsersFromProperties(Properties props) {
        TreeMap<String, User> users = new TreeMap<String, User>();
        UserAttributeEditor configAttribEd = new UserAttributeEditor();
        for (String string : props.keySet()) {
            configAttribEd.setAsText(props.getProperty(string));
            UserAttribute attr = (UserAttribute)configAttribEd.getValue();
            if (attr == null) continue;
            User user = this.createUserObject(string, attr.getPassword(), attr.isEnabled(), attr.getAuthorities());
            users.put(string, user);
        }
        return users;
    }

    protected User createUserObject(String username, String password, boolean isEnabled, List<GrantedAuthority> authorities) {
        return new User(username, password, isEnabled, true, true, true, authorities);
    }

    Properties storeUsersToProperties(Map<String, User> userMap) {
        Properties p = new Properties();
        for (User user : userMap.values()) {
            p.setProperty(user.getUsername(), this.serializeUser(user));
        }
        return p;
    }

    String serializeUser(User user) {
        StringBuffer sb = new StringBuffer();
        sb.append(user.getPassword());
        sb.append(",");
        for (GrantedAuthority ga : user.getAuthorities()) {
            sb.append(ga.getAuthority());
            sb.append(",");
        }
        sb.append(user.isEnabled() ? "enabled" : "disabled");
        return sb.toString();
    }
}

