/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.InMemorySecurityFilter;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.SecureTreeNode;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public class DefaultResourceAccessManager
implements ResourceAccessManager,
DataAccessManager {
    static final Logger LOGGER = Logging.getLogger(DefaultResourceAccessManager.class);
    SecureTreeNode root;
    DataAccessRuleDAO dao;
    long lastLoaded = Long.MIN_VALUE;

    public DefaultResourceAccessManager(DataAccessRuleDAO dao) {
        this.dao = dao;
        this.root = this.buildAuthorizationTree(dao);
    }

    @Override
    public CatalogMode getMode() {
        return this.dao.getMode();
    }

    @Override
    public boolean canAccess(Authentication user, WorkspaceInfo workspace, AccessMode mode) {
        this.checkPropertyFile();
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace.getName()});
        return node.canAccess(user, mode);
    }

    @Override
    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode) {
        this.checkPropertyFile();
        if (layer.getResource() == null) {
            LOGGER.log(Level.FINE, "Layer " + layer + " has no attached resource, " + "assuming it's possible to access it");
            return true;
        }
        return this.canAccess(user, layer.getResource(), mode);
    }

    @Override
    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode) {
        String workspace;
        this.checkPropertyFile();
        try {
            workspace = resource.getStore().getWorkspace().getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Errors occurred trying to gather workspace of resource " + resource.getName());
            return true;
        }
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace, resource.getName()});
        return node.canAccess(user, mode);
    }

    void checkPropertyFile() {
        long daoLastModified = this.dao.getLastModified();
        if (this.lastLoaded < daoLastModified) {
            this.root = this.buildAuthorizationTree(this.dao);
            this.lastLoaded = daoLastModified;
        }
    }

    SecureTreeNode buildAuthorizationTree(DataAccessRuleDAO dao) {
        SecureTreeNode root = new SecureTreeNode();
        for (DataAccessRule rule : dao.getRules()) {
            SecureTreeNode node;
            String workspace = rule.getWorkspace();
            String layer = rule.getLayer();
            AccessMode accessMode = rule.getAccessMode();
            if ("*".equals(workspace)) {
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(workspace);
                if (ws == null) {
                    ws = root.addChild(workspace);
                }
                if ("*".equals(layer)) {
                    node = ws;
                } else {
                    SecureTreeNode layerNode = ws.getChild(layer);
                    if (layerNode == null) {
                        layerNode = ws.addChild(layer);
                    }
                    node = layerNode;
                }
            }
            if (node.getAuthorizedRoles(accessMode) != null && node.getAuthorizedRoles(accessMode).size() > 0 && node != root) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(accessMode, rule.getRoles());
        }
        return root;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        boolean read = this.canAccess(user, layer, AccessMode.READ);
        boolean write = this.canAccess(user, layer, AccessMode.WRITE);
        Filter readFilter = (Filter)(read ? Filter.INCLUDE : Filter.EXCLUDE);
        Filter writeFilter = (Filter)(write ? Filter.INCLUDE : Filter.EXCLUDE);
        return this.buildLimits(layer.getResource().getClass(), readFilter, writeFilter);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        boolean read = this.canAccess(user, resource, AccessMode.READ);
        boolean write = this.canAccess(user, resource, AccessMode.WRITE);
        Filter readFilter = (Filter)(read ? Filter.INCLUDE : Filter.EXCLUDE);
        Filter writeFilter = (Filter)(write ? Filter.INCLUDE : Filter.EXCLUDE);
        return this.buildLimits(resource.getClass(), readFilter, writeFilter);
    }

    DataAccessLimits buildLimits(Class<? extends ResourceInfo> resourceClass, Filter readFilter, Filter writeFilter) {
        CatalogMode mode = this.getMode();
        if ((readFilter == null || readFilter == Filter.INCLUDE) && (writeFilter == null || writeFilter == Filter.INCLUDE || WMSLayerInfo.class.isAssignableFrom(resourceClass) || CoverageInfo.class.isAssignableFrom(resourceClass))) {
            return null;
        }
        if (FeatureTypeInfo.class.isAssignableFrom(resourceClass)) {
            return new VectorAccessLimits(mode, null, readFilter, null, writeFilter);
        }
        if (CoverageInfo.class.isAssignableFrom(resourceClass)) {
            return new CoverageAccessLimits(mode, readFilter, null, null);
        }
        if (WMSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMSAccessLimits(mode, readFilter, null, true);
        }
        LOGGER.log(Level.INFO, "Warning, adapting to generic access limits for unrecognized resource type " + resourceClass);
        return new DataAccessLimits(mode, readFilter);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        boolean readable = this.canAccess(user, workspace, AccessMode.READ);
        boolean writable = this.canAccess(user, workspace, AccessMode.WRITE);
        boolean adminable = this.canAccess(user, workspace, AccessMode.ADMIN);
        CatalogMode mode = this.getMode();
        if (readable && writable && AdminRequest.get() == null) {
            return null;
        }
        return new WorkspaceAccessLimits(mode, readable, writable, adminable);
    }

    @Override
    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        return null;
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        return null;
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("name", wsName));
            }
            if (exceptions.size() == 0) {
                return (Filter)(rootAccess ? Filter.INCLUDE : Filter.EXCLUDE);
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        if (PublishedInfo.class.isAssignableFrom(clazz) || ResourceInfo.class.isAssignableFrom(clazz) || CoverageInfo.class.isAssignableFrom(clazz)) {
            Filter filter;
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            String wsNameProperty = PublishedInfo.class.isAssignableFrom(clazz) ? "resource.store.workspace.name" : "store.workspace.name";
            for (Map.Entry<String, SecureTreeNode> wsEntry : this.root.getChildren().entrySet()) {
                String wsName = wsEntry.getKey();
                SecureTreeNode wsNode = wsEntry.getValue();
                boolean wsAccess = this.canAccess(user, wsNode);
                ArrayList<Filter> layerExceptions = new ArrayList<Filter>();
                for (Map.Entry<String, SecureTreeNode> layerEntry : wsNode.getChildren().entrySet()) {
                    String layerName = layerEntry.getKey();
                    SecureTreeNode layerNode = layerEntry.getValue();
                    boolean layerAccess = this.canAccess(user, layerNode);
                    if (layerAccess == wsAccess) continue;
                    if (wsAccess) {
                        layerExceptions.add(Predicates.notEqual("prefixedName", wsName + ":" + layerName));
                        continue;
                    }
                    layerExceptions.add(Predicates.equal("prefixedName", wsName + ":" + layerName));
                }
                Filter wsFilter = null;
                if (rootAccess && !wsAccess) {
                    wsFilter = Predicates.notEqual(wsNameProperty, wsName);
                } else if (!rootAccess && wsAccess) {
                    wsFilter = Predicates.equal(wsNameProperty, wsName);
                }
                if (layerExceptions.isEmpty()) {
                    if (wsFilter == null) continue;
                    exceptions.add(wsFilter);
                    continue;
                }
                if (wsFilter != null) {
                    layerExceptions.add(wsFilter);
                }
                Filter combined = wsAccess ? Predicates.and(layerExceptions) : Predicates.or(layerExceptions);
                exceptions.add(combined);
            }
            if (exceptions.size() == 0) {
                return (Filter)(rootAccess ? Filter.INCLUDE : Filter.EXCLUDE);
            }
            Filter filter2 = filter = rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
            if (PublishedInfo.class.equals(clazz)) {
                Filter layerFilter = Predicates.and(Predicates.isInstanceOf(LayerInfo.class), filter);
                Filter layerGroupFilter = Predicates.isInstanceOf(LayerGroupInfo.class);
                return Predicates.or(layerFilter, layerGroupFilter);
            }
            return filter;
        }
        if (StyleInfo.class.isAssignableFrom(clazz) || LayerGroupInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("workspace.name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("workspace.name", wsName));
            }
            if (exceptions.size() == 0) {
                return (Filter)(rootAccess ? Filter.INCLUDE : Filter.EXCLUDE);
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        return InMemorySecurityFilter.buildUserAccessFilter(this, user);
    }

    private boolean canAccess(Authentication user, SecureTreeNode node) {
        boolean access = node.canAccess(user, AccessMode.READ);
        if (access && AdminRequest.get() != null) {
            return node.canAccess(user, AccessMode.ADMIN);
        }
        return access;
    }
}

