/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.geoserver.security.impl.DataAccessRule;
import org.geotools.util.logging.Logging;

public class DataAccessRuleDAO
extends AbstractAccessRuleDAO<DataAccessRule> {
    private static final Logger LOGGER = Logging.getLogger(DataAccessRuleDAO.class);
    static final String LAYERS = "layers.properties";
    Catalog rawCatalog;
    CatalogMode catalogMode = CatalogMode.HIDE;

    public static DataAccessRuleDAO get() {
        return (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class);
    }

    public DataAccessRuleDAO(GeoServerDataDirectory dd, Catalog rawCatalog) throws IOException {
        super(dd, LAYERS);
        this.rawCatalog = rawCatalog;
    }

    DataAccessRuleDAO(Catalog rawCatalog, File securityDir) {
        super(securityDir, LAYERS);
        this.rawCatalog = rawCatalog;
    }

    public CatalogMode getMode() {
        this.checkPropertyFile(false);
        return this.catalogMode;
    }

    @Override
    protected void loadRules(Properties props) {
        TreeSet<DataAccessRule> result = new TreeSet<DataAccessRule>();
        this.catalogMode = CatalogMode.HIDE;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String ruleKey = (String)entry.getKey();
            String ruleValue = (String)entry.getValue();
            if ("mode".equalsIgnoreCase(ruleKey)) {
                try {
                    this.catalogMode = CatalogMode.valueOf(ruleValue.toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.warning("Invalid security mode " + ruleValue + " acceptable values are " + Arrays.asList(CatalogMode.values()));
                }
                continue;
            }
            DataAccessRule rule = this.parseDataAccessRule(ruleKey, ruleValue);
            if (rule == null) continue;
            if (result.contains(rule)) {
                LOGGER.warning("Rule " + ruleKey + "." + ruleValue + " overwrites another rule on the same path");
            }
            result.add(rule);
        }
        if (result.size() == 0) {
            result.add(new DataAccessRule(DataAccessRule.READ_ALL));
            result.add(new DataAccessRule(DataAccessRule.WRITE_ALL));
        }
        this.rules = result;
    }

    DataAccessRule parseDataAccessRule(String ruleKey, String ruleValue) {
        AccessMode mode;
        String rule = ruleKey + "=" + ruleValue;
        String[] elements = DataAccessRuleDAO.parseElements(ruleKey);
        if (elements.length != 3) {
            LOGGER.warning("Invalid rule " + rule + ", the expected format is workspace.layer.mode=role1,role2,...");
            return null;
        }
        String workspace = elements[0];
        String layerName = elements[1];
        String modeAlias = elements[2];
        Set<String> roles = this.parseRoles(ruleValue);
        if (elements.length != 3) {
            LOGGER.warning("Invalid rule '" + rule + "', the standard form is [namespace].[layer].[mode]=[role]+ " + "Rule has been ignored");
            return null;
        }
        if (!"*".equals(workspace) && this.rawCatalog.getWorkspaceByName(workspace) == null) {
            LOGGER.warning("Namespace/Workspace " + workspace + " is unknown in rule " + rule);
        }
        if (!"*".equals(layerName) && this.rawCatalog.getLayerByName(layerName) == null) {
            LOGGER.warning("Layer " + workspace + " is unknown in rule + " + rule);
        }
        if ((mode = AccessMode.getByAlias(modeAlias)) == null) {
            LOGGER.warning("Unknown access mode " + modeAlias + " in " + ruleKey + ", skipping rule " + rule);
            return null;
        }
        if ("*".equals(workspace) && !"*".equals(layerName)) {
            LOGGER.warning("Invalid rule " + rule + ", when namespace " + "is * then also layer must be *. Skipping rule " + rule);
            return null;
        }
        if (mode == AccessMode.ADMIN && !"*".equals(layerName)) {
            LOGGER.warning("Invalid rule " + rule + ", admin (a) privileges may only be applied " + "globally to a workspace, layer must be *, skipping rule");
            return null;
        }
        return new DataAccessRule(workspace, layerName, mode, roles);
    }

    @Override
    protected Properties toProperties() {
        Properties props = new Properties();
        props.put("mode", this.catalogMode.toString());
        for (DataAccessRule rule : this.rules) {
            String key = rule.getWorkspace().replaceAll("\\.", "\\\\.") + "." + rule.getLayer().replaceAll("\\.", "\\\\.") + "." + rule.getAccessMode().getAlias();
            props.put(key, rule.getValue());
        }
        return props;
    }

    static String[] parseElements(String path) {
        String[] rawParse = path.trim().split("\\s*\\.\\s*");
        ArrayList<String> result = new ArrayList<String>();
        String prefix = null;
        for (String raw : rawParse) {
            if (prefix != null) {
                raw = prefix + "." + raw;
            }
            if (raw.endsWith("\\")) {
                prefix = raw.substring(0, raw.length() - 1);
                continue;
            }
            result.add(raw);
            prefix = null;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setCatalogMode(CatalogMode catalogMode) {
        this.catalogMode = catalogMode;
    }

    public static CatalogMode getByAlias(String alias) {
        for (CatalogMode mode : CatalogMode.values()) {
            if (!mode.name().equals(alias)) continue;
            return mode;
        }
        return null;
    }

    public SortedSet<DataAccessRule> getRulesAssociatedWithRole(String role) {
        TreeSet<DataAccessRule> result = new TreeSet<DataAccessRule>();
        for (DataAccessRule rule : this.getRules()) {
            if (!rule.getRoles().contains(role)) continue;
            result.add(rule);
        }
        return result;
    }
}

