/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;

public class GeoServerSecurityMetadataSource
extends DefaultFilterInvocationSecurityMetadataSource {
    static LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap();

    public GeoServerSecurityMetadataSource() {
        super(requestMap);
    }

    static {
        requestMap.put(new LoginPageRequestMatcher(), new ArrayList());
        requestMap.put((RequestMatcher)new AntPathRequestMatcher("/web/resources/**"), new ArrayList());
        AntPathRequestMatcher matcher = new AntPathRequestMatcher("/config/**");
        ArrayList<SecurityConfig> list2 = new ArrayList<SecurityConfig>();
        list2.add(new SecurityConfig(GeoServerRole.ADMIN_ROLE.getAuthority()));
        requestMap.put((RequestMatcher)matcher, list2);
        matcher = new AntPathRequestMatcher("/**");
        list2 = new ArrayList();
        list2.add(new SecurityConfig("IS_AUTHENTICATED_ANONYMOUSLY"));
        requestMap.put((RequestMatcher)matcher, list2);
    }

    static class LoginPageRequestMatcher
    implements RequestMatcher {
        RequestMatcher webChainMatcher1 = new AntPathRequestMatcher("/web");
        RequestMatcher webChainMatcher2 = new AntPathRequestMatcher("/web/");

        LoginPageRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            boolean isOnWebChain;
            boolean bl = isOnWebChain = this.webChainMatcher1.matches(request) || this.webChainMatcher2.matches(request);
            if (!isOnWebChain) {
                return false;
            }
            Map params = request.getParameterMap();
            if (params.size() != 2) {
                return false;
            }
            String[] pageClass = (String[])params.get("wicket:bookmarkablePage");
            if (pageClass == null || pageClass.length != 1) {
                return false;
            }
            if (!":org.geoserver.web.GeoServerLoginPage".equals(pageClass[0])) {
                return false;
            }
            String[] error = (String[])params.get("error");
            return error != null && error.length == 1;
        }
    }
}

