/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import org.geoserver.security.impl.Util;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class LockFile {
    protected long lockFileLastModified;
    protected File lockFileTarget;
    protected File lockFile;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");

    public LockFile(File file) throws IOException {
        this.lockFileTarget = file;
        if (!file.exists()) {
            throw new IOException("Cannot lock a not existing file: " + file.getCanonicalPath());
        }
        this.lockFile = new File(this.lockFileTarget.getCanonicalPath() + ".lock");
        this.lockFile.deleteOnExit();
    }

    public boolean hasWriteLock() throws IOException {
        return this.lockFile.exists() && this.lockFile.lastModified() == this.lockFileLastModified;
    }

    public boolean hasForeignWriteLock() throws IOException {
        return this.lockFile.exists() && this.lockFile.lastModified() != this.lockFileLastModified;
    }

    public void writeUnLock() {
        if (this.lockFile.exists()) {
            if (this.lockFile.lastModified() == this.lockFileLastModified) {
                this.lockFileLastModified = 0L;
                this.lockFile.delete();
            } else {
                LOGGER.warning("Tried to unlock foreign lock: " + this.lockFile.getAbsolutePath());
            }
        } else {
            LOGGER.warning("Tried to unlock not exisiting lock: " + this.lockFile.getAbsolutePath());
        }
    }

    public void writeLock() throws IOException {
        if (this.hasWriteLock()) {
            return;
        }
        if (this.lockFile.exists()) {
            LOGGER.warning("Cannot obtain  lock: " + this.lockFile.getCanonicalPath());
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(this.lockFile);){
                props.load(in);
            }
            throw new IOException(Util.convertPropsToString(props, "Already locked"));
        }
        this.writeLockFileContent(this.lockFile);
        this.lockFileLastModified = this.lockFile.lastModified();
        this.lockFile.deleteOnExit();
        LOGGER.info("Successful lock: " + this.lockFile.getCanonicalPath());
    }

    protected void writeLockFileContent(File lockFile) throws IOException {
        Properties props = new Properties();
        try (FileOutputStream out = new FileOutputStream(lockFile);){
            props.store(out, "Locking info");
            String hostname = "UNKNOWN";
            String ip = "UNKNOWN";
            try {
                InetAddress[] addrs;
                hostname = InetAddress.getLocalHost().getHostName();
                for (InetAddress addr : addrs = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || !addr.isSiteLocalAddress()) continue;
                    ip = addr.getHostAddress();
                }
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            props.put("hostname", hostname);
            props.put("ip", ip);
            props.put("location", lockFile.getCanonicalPath());
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            props.put("principal", auth == null ? "UNKNOWN" : auth.getName());
            props.store(out, "Locking info");
        }
    }
}

