/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geotools.util.logging.Logging;

public abstract class FileWatcher
implements ResourceListener {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected String path;
    Resource resource;
    long lastModified = 0L;
    boolean warnedAlready = false;
    boolean terminate = false;
    Object terminateLock = new Object();
    Object lastModifiedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.terminateLock;
        synchronized (object) {
            return this.terminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminate(boolean terminated) {
        this.resource.removeListener((ResourceListener)this);
        Object object = this.terminateLock;
        synchronized (object) {
            this.terminate = terminated;
        }
    }

    protected FileWatcher(File file) {
        this.resource = Files.asResource((File)file);
        this.path = this.resource.path();
    }

    protected FileWatcher(Resource resource) {
        this.resource = resource;
        this.path = resource.path();
    }

    public void start() {
        this.resource.addListener((ResourceListener)this);
    }

    public void setDelay(long delay) {
    }

    public void changed(ResourceNotification notify) {
        if (this.isTerminated()) {
            return;
        }
        this.doOnChange();
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.resource.getType() == Resource.Type.RESOURCE;
        }
        catch (SecurityException e) {
            LOGGER.warning("Was not allowed to read check file existance, file:[" + this.path + "].");
            this.setTerminate(true);
            return;
        }
        if (fileExists) {
            long l = this.resource.lastmodified();
            if (this.testAndSetLastModified(l)) {
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LOGGER.warning("[" + this.path + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public String getFileInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        StringBuffer buff = new StringBuffer(this.path);
        buff.append(" last modified: ");
        buff.append(sdf.format(this.resource.lastmodified()));
        return buff.toString();
    }

    public String toString() {
        return "FileWatcher: " + this.getFileInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testAndSetLastModified(long l) {
        Object object = this.lastModifiedLock;
        synchronized (object) {
            if (l > this.lastModified) {
                this.lastModified = l;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModified(long lastModified) {
        Object object = this.lastModifiedLock;
        synchronized (object) {
            this.lastModified = lastModified;
        }
    }
}

