/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.geoserver.catalog.Predicates;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.Format;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class SecuredGridCoverage2DReader
extends DecoratingGridCoverage2DReader {
    private static final CoverageProcessor processor = CoverageProcessor.getInstance((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    WrapperPolicy policy;

    public SecuredGridCoverage2DReader(GridCoverage2DReader delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public Format getFormat() {
        Format format = this.delegate.getFormat();
        if (format == null) {
            return null;
        }
        return (Format)SecuredObjects.secure(format, this.policy);
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        MultiPolygon rasterFilter = null;
        if (this.policy.getLimits() instanceof CoverageAccessLimits) {
            CoverageAccessLimits limits = (CoverageAccessLimits)this.policy.getLimits();
            rasterFilter = limits.getRasterFilter();
            Filter readFilter = limits.getReadFilter();
            GeneralParameterValue[] limitParams = limits.getParams();
            if (parameters == null) {
                parameters = limitParams;
            } else if (limitParams != null) {
                ArrayList<GeneralParameterValue> params = new ArrayList<GeneralParameterValue>(Arrays.asList(parameters));
                for (GeneralParameterValue lparam : limitParams) {
                    GeneralParameterDescriptor ldescriptor = lparam.getDescriptor();
                    Iterator it = params.iterator();
                    while (it.hasNext()) {
                        GeneralParameterValue param = (GeneralParameterValue)it.next();
                        if (!param.getDescriptor().equals(lparam.getDescriptor())) continue;
                        it.remove();
                        break;
                    }
                    params.add(lparam);
                }
                parameters = params.toArray(new GeneralParameterValue[params.size()]);
            }
            if (readFilter != null && !Filter.INCLUDE.equals(readFilter)) {
                Format format = this.delegate.getFormat();
                ParameterValueGroup readParameters = format.getReadParameters();
                List descriptors = readParameters.getDescriptor().descriptors();
                boolean replacedOriginalFilter = false;
                for (GeneralParameterValue pv : parameters) {
                    String pdCode = pv.getDescriptor().getName().getCode();
                    if (!"FILTER".equals(pdCode) && !"Filter".equals(pdCode)) continue;
                    replacedOriginalFilter = true;
                    ParameterValue pvalue = (ParameterValue)pv;
                    Filter originalFilter = (Filter)pvalue.getValue();
                    if (originalFilter == null || Filter.INCLUDE.equals(originalFilter)) {
                        pvalue.setValue((Object)readFilter);
                        continue;
                    }
                    Filter combined = Predicates.and(originalFilter, readFilter);
                    pvalue.setValue((Object)combined);
                }
                if (!replacedOriginalFilter) {
                    parameters = CoverageUtils.mergeParameter(descriptors, parameters, readFilter, "FILTER", "Filter");
                }
            }
        }
        GridCoverage2D grid = this.delegate.read(parameters);
        if (rasterFilter != null) {
            Polygon coverageBounds = JTS.toGeometry((Envelope)new ReferencedEnvelope((BoundingBox)grid.getEnvelope2D()));
            if (coverageBounds.intersects((Geometry)rasterFilter)) {
                ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
                param.parameter("source").setValue((Object)grid);
                param.parameter("ROI").setValue((Object)rasterFilter);
                grid = (GridCoverage2D)((Crop)processor.getOperation("CoverageCrop")).doOperation(param, null);
            } else {
                return null;
            }
        }
        return grid;
    }
}

