/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.security.AccessLevel;
import org.geoserver.security.Response;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureIterator;
import org.geoserver.security.decorators.SecuredFeatureLocking;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.decorators.SecuredGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredGridFormat;
import org.geoserver.security.decorators.SecuredObjectFactory;
import org.geoserver.security.decorators.SecuredSimpleFeatureCollection;
import org.geoserver.security.decorators.SecuredSimpleFeatureIterator;
import org.geoserver.security.decorators.SecuredSimpleFeatureLocking;
import org.geoserver.security.decorators.SecuredSimpleFeatureSource;
import org.geoserver.security.decorators.SecuredSimpleFeatureStore;
import org.geoserver.security.decorators.SecuredWebMapServer;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.wms.WebMapServer;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DefaultSecureDataFactory
implements SecuredObjectFactory {
    @Override
    public boolean canSecure(Class clazz) {
        return DataAccess.class.isAssignableFrom(clazz) || DataStore.class.isAssignableFrom(clazz) || FeatureSource.class.isAssignableFrom(clazz) || FeatureStore.class.isAssignableFrom(clazz) || FeatureLocking.class.isAssignableFrom(clazz) || FeatureCollection.class.isAssignableFrom(clazz) || FeatureIterator.class.isAssignableFrom(clazz) || GridCoverage2DReader.class.isAssignableFrom(clazz) || AbstractGridFormat.class.isAssignableFrom(clazz) || WebMapServer.class.isAssignableFrom(clazz);
    }

    @Override
    public Object secure(Object object, WrapperPolicy policy) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!this.canSecure(clazz)) {
            throw new IllegalArgumentException("Don't know how to wrap objects of class " + object.getClass());
        }
        if (DataStore.class.isAssignableFrom(clazz)) {
            return new ReadOnlyDataStore((DataStore)object, policy);
        }
        if (DataAccess.class.isAssignableFrom(clazz)) {
            return new ReadOnlyDataAccess((DataAccess)object, policy);
        }
        if (SimpleFeatureSource.class.isAssignableFrom(clazz)) {
            if ((policy.level == AccessLevel.READ_ONLY || policy.level == AccessLevel.METADATA || policy.level == AccessLevel.HIDDEN) && policy.response != Response.CHALLENGE) {
                return new SecuredSimpleFeatureSource((SimpleFeatureSource)object, policy);
            }
            if (SimpleFeatureLocking.class.isAssignableFrom(clazz)) {
                return new SecuredSimpleFeatureLocking((FeatureLocking)((SimpleFeatureLocking)object), policy);
            }
            if (SimpleFeatureStore.class.isAssignableFrom(clazz)) {
                return new SecuredSimpleFeatureStore((SimpleFeatureStore)object, policy);
            }
            if (SimpleFeatureSource.class.isAssignableFrom(clazz)) {
                return new SecuredSimpleFeatureSource((SimpleFeatureSource)object, policy);
            }
        } else if (FeatureSource.class.isAssignableFrom(clazz)) {
            if ((policy.level == AccessLevel.READ_ONLY || policy.level == AccessLevel.METADATA || policy.level == AccessLevel.HIDDEN) && policy.response != Response.CHALLENGE) {
                return new SecuredFeatureSource((FeatureSource)object, policy);
            }
            if (FeatureLocking.class.isAssignableFrom(clazz)) {
                return new SecuredFeatureLocking((FeatureLocking)object, policy);
            }
            if (FeatureStore.class.isAssignableFrom(clazz)) {
                return new SecuredFeatureStore((FeatureStore)object, policy);
            }
            if (FeatureSource.class.isAssignableFrom(clazz)) {
                return new SecuredFeatureSource((FeatureSource)object, policy);
            }
        }
        if (SimpleFeatureCollection.class.isAssignableFrom(clazz)) {
            return new SecuredSimpleFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)((SimpleFeatureCollection)object), policy);
        }
        if (FeatureCollection.class.isAssignableFrom(clazz)) {
            return new SecuredFeatureCollection((FeatureCollection)object, policy);
        }
        if (SimpleFeatureIterator.class.isAssignableFrom(clazz)) {
            return new SecuredSimpleFeatureIterator((SimpleFeatureIterator)object);
        }
        if (FeatureIterator.class.isAssignableFrom(clazz)) {
            return new SecuredFeatureIterator((FeatureIterator)object);
        }
        if (GridCoverage2DReader.class.isAssignableFrom(clazz)) {
            return new SecuredGridCoverage2DReader((GridCoverage2DReader)object, policy);
        }
        if (AbstractGridFormat.class.isAssignableFrom(clazz)) {
            return new SecuredGridFormat((AbstractGridFormat)object, policy);
        }
        if (WebMapServer.class.isAssignableFrom(clazz)) {
            try {
                return new SecuredWebMapServer((WebMapServer)object);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error wrapping the web map server", e);
            }
        }
        throw new IllegalArgumentException("Don't know how to wrap objects of class " + object.getClass());
    }

    public int getPriority() {
        return 100;
    }
}

