/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.concurrent;

import java.io.IOException;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.concurrent.LockingUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;

public class LockingUserGroupStore
extends LockingUserGroupService
implements GeoServerUserGroupStore {
    public LockingUserGroupStore(GeoServerUserGroupStore store) {
        super(store);
    }

    public GeoServerUserGroupStore getStore() {
        return (GeoServerUserGroupStore)super.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.writeLock();
        try {
            this.getStore().addUser(user);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.writeLock();
        try {
            this.getStore().updateUser(user);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        this.writeLock();
        try {
            boolean bl = this.getStore().removeUser(user);
            return bl;
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(GeoServerUserGroup group) throws IOException {
        this.writeLock();
        try {
            this.getStore().addGroup(group);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroup(GeoServerUserGroup group) throws IOException {
        this.writeLock();
        try {
            this.getStore().updateGroup(group);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        this.writeLock();
        try {
            boolean bl = this.getStore().removeGroup(group);
            return bl;
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws IOException {
        this.writeLock();
        try {
            this.getStore().store();
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.writeLock();
        try {
            this.getStore().associateUserToGroup(user, group);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.writeLock();
        try {
            this.getStore().disAssociateUserFromGroup(user, group);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        this.readLock();
        try {
            boolean bl = this.getStore().isModified();
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        this.writeLock();
        try {
            this.getStore().clear();
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.writeLock();
        try {
            this.getStore().initializeFromService(service);
        }
        finally {
            this.writeUnLock();
        }
    }
}

