/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.concurrent;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.concurrent.AbstractLockingService;
import org.geoserver.security.concurrent.LockingUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedEvent;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LockingUserGroupService
extends AbstractLockingService
implements GeoServerUserGroupService,
UserGroupLoadedListener {
    protected Set<UserGroupLoadedListener> listeners = Collections.synchronizedSet(new HashSet());

    public LockingUserGroupService(GeoServerUserGroupService service) {
        super(service);
        service.registerUserGroupLoadedListener(this);
    }

    @Override
    public GeoServerUserGroupService getService() {
        return (GeoServerUserGroupService)super.getService();
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        GeoServerUserGroupStore store = this.getService().createStore();
        return store != null ? new LockingUserGroupStore(store) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        this.readLock();
        try {
            GeoServerUserGroup geoServerUserGroup = this.getService().getGroupByGroupname(groupname);
            return geoServerUserGroup;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        this.readLock();
        try {
            GeoServerUser geoServerUser = this.getService().createUserObject(username, password, isEnabled);
            return geoServerUser;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        this.writeLock();
        try {
            this.getService().load();
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerUser getUserByUsername(String username) throws IOException {
        this.readLock();
        try {
            GeoServerUser geoServerUser = this.getService().getUserByUsername(username);
            return geoServerUser;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        this.readLock();
        try {
            GeoServerUserGroup geoServerUserGroup = this.getService().createGroupObject(groupname, isEnabled);
            return geoServerUserGroup;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUser> getUsers() throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUser> sortedSet = this.getService().getUsers();
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUserGroup> sortedSet = this.getService().getUserGroups();
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUser> sortedSet = this.getService().getUsersForGroup(group);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUserGroup> sortedSet = this.getService().getGroupsForUser(user);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    protected void fireUserGroupLoadedEvent() {
        UserGroupLoadedEvent event = new UserGroupLoadedEvent(this);
        for (UserGroupLoadedListener listener : this.listeners) {
            listener.usersAndGroupsChanged(event);
        }
    }

    @Override
    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void usersAndGroupsChanged(UserGroupLoadedEvent event) {
        this.fireUserGroupLoadedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.writeLock();
        try {
            this.getService().initializeFromConfig(config);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.readLock();
        try {
            UserDetails userDetails = this.getService().loadUserByUsername(username);
            return userDetails;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public String getPasswordEncoderName() {
        return this.getService().getPasswordEncoderName();
    }

    @Override
    public String getPasswordValidatorName() {
        return this.getService().getPasswordValidatorName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCount() throws IOException {
        this.readLock();
        try {
            int n = this.getService().getUserCount();
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGroupCount() throws IOException {
        this.readLock();
        try {
            int n = this.getService().getGroupCount();
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUser> sortedSet = this.getService().getUsersHavingProperty(propname);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCountHavingProperty(String propname) throws IOException {
        this.readLock();
        try {
            int n = this.getService().getUserCountHavingProperty(propname);
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUser> sortedSet = this.getService().getUsersNotHavingProperty(propname);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCountNotHavingProperty(String propname) throws IOException {
        this.readLock();
        try {
            int n = this.getService().getUserCountNotHavingProperty(propname);
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerUser> sortedSet = this.getService().getUsersHavingPropertyValue(propname, propvalue);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        this.readLock();
        try {
            int n = this.getService().getUserCountHavingPropertyValue(propname, propvalue);
            return n;
        }
        finally {
            this.readUnLock();
        }
    }
}

