/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityService;

public abstract class AbstractLockingService
implements GeoServerSecurityService {
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected GeoServerSecurityService service;

    protected AbstractLockingService(GeoServerSecurityService service) {
        this.service = service;
    }

    public GeoServerSecurityService getService() {
        return this.service;
    }

    @Override
    public String getName() {
        return this.getService().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        this.writeLock();
        try {
            this.getService().setName(name);
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.writeLock();
        try {
            this.getService().setSecurityManager(securityManager);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.getService().getSecurityManager();
    }

    @Override
    public boolean canCreateStore() {
        return this.getService().canCreateStore();
    }

    public String toString() {
        return "Locking " + this.getName();
    }

    protected void readLock() {
        this.readLock.lock();
    }

    protected void readUnLock() {
        this.readLock.unlock();
    }

    protected void writeLock() {
        this.writeLock.lock();
    }

    protected void writeUnLock() {
        this.writeLock.unlock();
    }
}

