/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.AuthenticationCacheEntry;
import org.geoserver.security.auth.AuthenticationCacheKey;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.security.core.Authentication;

public class GuavaAuthenticationCacheImpl
implements AuthenticationCache,
DisposableBean {
    public static final int DEFAULT_CLEANUP_TIME = 600;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 3;
    private int timeToIdleSeconds;
    private int timeToLiveSeconds;
    private final ScheduledExecutorService scheduler;
    private Cache<AuthenticationCacheKey, AuthenticationCacheEntry> cache;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private Runnable evictionTask = new Runnable(){

        @Override
        public void run() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AuthenticationCache Eviction task running");
                LOGGER.fine("Cache entries #: " + GuavaAuthenticationCacheImpl.this.cache.size());
            }
            GuavaAuthenticationCacheImpl.this.cache.cleanUp();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AuthenticationCache Eviction task completed");
                LOGGER.fine("Cache entries #: " + GuavaAuthenticationCacheImpl.this.cache.size());
            }
        }
    };
    private static AtomicInteger poolCounter = new AtomicInteger();

    public GuavaAuthenticationCacheImpl(int maxEntries) {
        this(maxEntries, 300, 600, 600, 3);
    }

    private ThreadFactory getThreadFactory() {
        CustomizableThreadFactory tFactory = new CustomizableThreadFactory(String.format("GuavaAuthCache-%d-", poolCounter.getAndIncrement()));
        tFactory.setDaemon(true);
        return tFactory;
    }

    public GuavaAuthenticationCacheImpl(int maxEntries, int timeToIdleSeconds, int timeToLiveSeconds, int cleanUpSeconds, int concurrencyLevel) {
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.scheduler = Executors.newScheduledThreadPool(1, this.getThreadFactory());
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxEntries).expireAfterAccess((long)timeToIdleSeconds, TimeUnit.SECONDS).expireAfterWrite((long)timeToLiveSeconds, TimeUnit.SECONDS).concurrencyLevel(concurrencyLevel).build();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("AuthenticationCache Initialized with " + maxEntries + " Max Entries, " + timeToIdleSeconds + " seconds idle time, " + timeToLiveSeconds + " seconds time to live and " + concurrencyLevel + " concurrency level");
        }
        this.scheduler.scheduleAtFixedRate(this.evictionTask, cleanUpSeconds, cleanUpSeconds, TimeUnit.SECONDS);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("AuthenticationCache Eviction Task created to run every " + cleanUpSeconds + " seconds");
        }
    }

    @Override
    public void removeAll() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removing all entries");
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
        this.cache.invalidateAll();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removed all entries");
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
    }

    @Override
    public void removeAll(String filterName) {
        if (filterName == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removing all entries for " + filterName);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
        HashSet<AuthenticationCacheKey> toBeRemoved = new HashSet<AuthenticationCacheKey>();
        for (AuthenticationCacheKey key : this.cache.asMap().keySet()) {
            if (!filterName.equals(key.getFilterName())) continue;
            toBeRemoved.add(key);
        }
        this.cache.invalidateAll(toBeRemoved);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removed " + toBeRemoved.size() + " entries for " + filterName);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
    }

    @Override
    public void remove(String filterName, String cacheKey) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removing " + filterName + ", " + cacheKey + " entry");
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
        this.cache.invalidate((Object)new AuthenticationCacheKey(filterName, cacheKey));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache removed " + filterName + ", " + cacheKey + " entry");
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
    }

    @Override
    public Authentication get(String filterName, String cacheKey) {
        AuthenticationCacheEntry entry = (AuthenticationCacheEntry)this.cache.getIfPresent((Object)new AuthenticationCacheKey(filterName, cacheKey));
        if (entry == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AuthenticationCache has no entry for " + filterName + ", " + cacheKey);
            }
            return null;
        }
        long currentTime = System.currentTimeMillis();
        if (entry.hasExpired(currentTime)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Entry has expired");
            }
            this.cache.invalidate((Object)entry);
            return null;
        }
        entry.setLastAccessed(System.currentTimeMillis());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache found an entry for " + filterName + ", " + cacheKey);
        }
        return entry.getAuthentication();
    }

    @Override
    public void put(String filterName, String cacheKey, Authentication auth, Integer timeToIdleSeconds, Integer timeToLiveSeconds) {
        timeToIdleSeconds = timeToIdleSeconds != null ? timeToIdleSeconds : this.timeToIdleSeconds;
        timeToLiveSeconds = timeToLiveSeconds != null ? timeToLiveSeconds : this.timeToLiveSeconds;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache adding new entry for " + filterName + ", " + cacheKey);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
        this.cache.put((Object)new AuthenticationCacheKey(filterName, cacheKey), (Object)new AuthenticationCacheEntry(auth, timeToIdleSeconds, timeToLiveSeconds));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache added new entry for " + filterName + ", " + cacheKey);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
    }

    @Override
    public void put(String filterName, String cacheKey, Authentication auth) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache adding new entry for " + filterName + ", " + cacheKey);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
        this.put(filterName, cacheKey, auth, this.timeToIdleSeconds, this.timeToLiveSeconds);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AuthenticationCache added new entry for " + filterName + ", " + cacheKey);
            LOGGER.fine("Cache entries #: " + this.cache.size());
        }
    }

    public boolean isEmpty() {
        return this.cache.size() == 0L;
    }

    public void destroy() {
        this.scheduler.shutdown();
    }
}

