/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.Response;

public class WrapperPolicy
implements Serializable,
Comparable<WrapperPolicy> {
    private static final long serialVersionUID = -7490634837165130290L;
    public final AccessLevel level;
    public final Response response;
    public final AccessLimits limits;

    public static final WrapperPolicy hide(AccessLimits limits) {
        return new WrapperPolicy(AccessLevel.HIDDEN, Response.HIDE, limits);
    }

    public static final WrapperPolicy metadata(AccessLimits limits) {
        return new WrapperPolicy(AccessLevel.METADATA, Response.CHALLENGE, limits);
    }

    public static final WrapperPolicy readOnlyChallenge(AccessLimits limits) {
        return new WrapperPolicy(AccessLevel.READ_ONLY, Response.CHALLENGE, limits);
    }

    public static final WrapperPolicy readOnlyHide(AccessLimits limits) {
        return new WrapperPolicy(AccessLevel.READ_ONLY, Response.HIDE, limits);
    }

    public static final WrapperPolicy readWrite(AccessLimits limits) {
        return new WrapperPolicy(AccessLevel.READ_WRITE, Response.HIDE, limits);
    }

    WrapperPolicy(AccessLevel level, Response response, AccessLimits limits) {
        this.level = level;
        this.response = response;
        this.limits = limits;
    }

    public Response getResponse() {
        return this.response;
    }

    public AccessLimits getLimits() {
        return this.limits;
    }

    public AccessLevel getAccessLevel() {
        return this.level;
    }

    public boolean isHide() {
        return this.level == AccessLevel.HIDDEN && this.response == Response.HIDE;
    }

    public boolean isMetadata() {
        return this.level == AccessLevel.METADATA && this.response == Response.CHALLENGE;
    }

    public boolean isReadOnlyChallenge() {
        return this.level == AccessLevel.READ_ONLY && this.response == Response.CHALLENGE;
    }

    public boolean isReadOnlyHide() {
        return this.level == AccessLevel.READ_ONLY && this.response == Response.HIDE;
    }

    public boolean isReadWrite() {
        return this.level == AccessLevel.READ_ONLY && this.response == Response.CHALLENGE;
    }

    @Override
    public int compareTo(WrapperPolicy w) {
        CatalogMode theirLimits;
        int levelComparison = this.getAccessLevel().compareTo(w.getAccessLevel());
        if (levelComparison != 0) {
            return levelComparison;
        }
        CatalogMode myLimits = this.getLimits() == null ? null : this.getLimits().getMode();
        CatalogMode catalogMode = theirLimits = w.getLimits() == null ? null : w.getLimits().getMode();
        return myLimits == null ? (theirLimits == null ? 0 : 1) : (theirLimits == null ? -1 : myLimits.compareTo(theirLimits));
    }
}

