/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.MasterPasswordProvider;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.SecurityConfigValidator;

public abstract class GeoServerSecurityProvider {
    public SingleValueConverter encrypter = new SingleValueConverter(){

        public boolean canConvert(Class type) {
            return type.equals(String.class);
        }

        public String toString(Object obj) {
            String source = obj == null ? "" : (String)obj;
            GeoServerSecurityManager manager = (GeoServerSecurityManager)((Object)GeoServerExtensions.bean(GeoServerSecurityManager.class));
            return manager.getConfigPasswordEncryptionHelper().encode(source);
        }

        public Object fromString(String str) {
            GeoServerSecurityManager manager = (GeoServerSecurityManager)((Object)GeoServerExtensions.bean(GeoServerSecurityManager.class));
            return manager.getConfigPasswordEncryptionHelper().decode(str);
        }
    };

    public static GeoServerSecurityProvider getProvider(Class<?> serviceClass, String className) {
        for (GeoServerSecurityProvider prov : GeoServerExtensions.extensions(GeoServerSecurityProvider.class)) {
            if (GeoServerAuthenticationProvider.class == serviceClass && prov.getAuthenticationProviderClass() != null && prov.getAuthenticationProviderClass().getName().equals(className)) {
                return prov;
            }
            if (GeoServerUserGroupService.class == serviceClass && prov.getUserGroupServiceClass() != null && prov.getUserGroupServiceClass().getName().equals(className)) {
                return prov;
            }
            if (GeoServerRoleService.class == serviceClass && prov.getRoleServiceClass() != null && prov.getRoleServiceClass().getName().equals(className)) {
                return prov;
            }
            if (PasswordValidator.class == serviceClass && prov.getPasswordValidatorClass() != null && prov.getPasswordValidatorClass().getName().equals(className)) {
                return prov;
            }
            if (GeoServerSecurityFilter.class == serviceClass && prov.getFilterClass() != null && prov.getFilterClass().getName().equals(className)) {
                return prov;
            }
            if (MasterPasswordProvider.class != serviceClass || prov.getMasterPasswordProviderClass() == null || !prov.getMasterPasswordProviderClass().getName().equals(className)) continue;
            return prov;
        }
        return null;
    }

    public boolean isAvailable() {
        return true;
    }

    public void configure(XStreamPersister xp) {
        for (Map.Entry<Class<?>, Set<String>> entry : this.getFieldsForEncryption().entrySet()) {
            for (String fieldName : entry.getValue()) {
                xp.getXStream().registerLocalConverter(entry.getKey(), fieldName, this.encrypter);
            }
        }
    }

    public Class<? extends GeoServerAuthenticationProvider> getAuthenticationProviderClass() {
        return null;
    }

    public GeoServerAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
        return null;
    }

    public Class<? extends GeoServerSecurityFilter> getFilterClass() {
        return null;
    }

    public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
        return null;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return null;
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return null;
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return null;
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return null;
    }

    public Class<? extends MasterPasswordProvider> getMasterPasswordProviderClass() {
        return null;
    }

    public MasterPasswordProvider createMasterPasswordProvider(MasterPasswordProviderConfig config) throws IOException {
        return null;
    }

    public Class<? extends PasswordValidator> getPasswordValidatorClass() {
        return null;
    }

    public PasswordValidator createPasswordValidator(PasswordPolicyConfig config, GeoServerSecurityManager securityManager) {
        return null;
    }

    public Map<Class<?>, Set<String>> getFieldsForEncryption() {
        return Collections.emptyMap();
    }

    public boolean roleServiceNeedsLockProtection() {
        return false;
    }

    public boolean userGroupServiceNeedsLockProtection() {
        return false;
    }

    public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
        return new SecurityConfigValidator(securityManager);
    }

    public void configureFilterChain(GeoServerSecurityFilterChain filterChain) {
    }

    public void init(GeoServerSecurityManager manager) {
    }

    public void destroy(GeoServerSecurityManager manager) {
    }
}

