/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.rmi.server.UID;
import java.security.InvalidKeyException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.util.IOUtils;
import org.geoserver.platform.ContextLoadedEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.ConstantFilterChain;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerSecurityService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.GroupAdminRoleService;
import org.geoserver.security.GroupAdminUserGroupService;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.HtmlLoginFilterChain;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.KeyStoreProviderImpl;
import org.geoserver.security.LogoutFilterChain;
import org.geoserver.security.MasterPasswordProvider;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.SecurityManagerListener;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.ServiceLoginFilterChain;
import org.geoserver.security.VariableFilterChain;
import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.GeoServerRootAuthenticationProvider;
import org.geoserver.security.auth.GuavaAuthenticationCacheImpl;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.concurrent.LockingKeyStoreProvider;
import org.geoserver.security.concurrent.LockingRoleService;
import org.geoserver.security.concurrent.LockingUserGroupService;
import org.geoserver.security.config.AnonymousAuthenticationFilterConfig;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.ExceptionTranslationFilterConfig;
import org.geoserver.security.config.FileBasedSecurityServiceConfig;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.LogoutFilterConfig;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RememberMeAuthenticationFilterConfig;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SSLFilterConfig;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityConfig;
import org.geoserver.security.config.SecurityContextPersistenceFilterConfig;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationFilterConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.file.FileWatcher;
import org.geoserver.security.file.RoleFileWatcher;
import org.geoserver.security.file.UserGroupFileWatcher;
import org.geoserver.security.filter.GeoServerAnonymousAuthenticationFilter;
import org.geoserver.security.filter.GeoServerBasicAuthenticationFilter;
import org.geoserver.security.filter.GeoServerExceptionTranslationFilter;
import org.geoserver.security.filter.GeoServerLogoutFilter;
import org.geoserver.security.filter.GeoServerRememberMeAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.filter.GeoServerSSLFilter;
import org.geoserver.security.filter.GeoServerSecurityContextPersistenceFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.filter.GeoServerSecurityInterceptorFilter;
import org.geoserver.security.filter.GeoServerUserNamePasswordAuthenticationFilter;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.GroupAdminProperty;
import org.geoserver.security.impl.RESTAccessRuleDAO;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.impl.Util;
import org.geoserver.security.password.ConfigurationPasswordEncryptionHelper;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.MasterPasswordChangeRequest;
import org.geoserver.security.password.MasterPasswordConfig;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.password.RandomPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.security.rememberme.GeoServerTokenBasedRememberMeServices;
import org.geoserver.security.rememberme.RememberMeServicesConfig;
import org.geoserver.security.validation.MasterPasswordChangeValidator;
import org.geoserver.security.validation.MasterPasswordConfigValidator;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.util.StringUtils;

public class GeoServerSecurityManager
extends ProviderManager
implements ApplicationContextAware,
ApplicationListener,
ResourceStore {
    private static final String VERSION_PROPERTIES = "version.properties";
    private static final Version VERSION_2_1 = new Version("2.1");
    private static final Version VERSION_2_2 = new Version("2.2");
    private static final Version VERSION_2_3 = new Version("2.3");
    private static final Version VERSION_2_4 = new Version("2.4");
    private static final Version VERSION_2_5 = new Version("2.5");
    private static final Version BASE_VERSION = VERSION_2_1;
    private static final Version CURR_VERSION = VERSION_2_5;
    private static final String VERSION = "version";
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    public static final String CONFIG_FILENAME = "config.xml";
    public static final String MASTER_PASSWD_CONFIG_FILENAME = "masterpw.xml";
    public static final String MASTER_PASSWD_INFO_FILENAME = "masterpw.info";
    public static final String MASTER_PASSWD_DIGEST_FILENAME = "masterpw.digest";
    public static final char[] MASTER_PASSWD_DEFAULT = "geoserver".toCharArray();
    GeoServerDataDirectory dataDir;
    ApplicationContext appContext;
    GeoServerRoleService activeRoleService;
    List<GeoServerAuthenticationProvider> authProviders;
    SecurityManagerConfig securityConfig = new SecurityManagerConfig();
    MasterPasswordConfig masterPasswordConfig = new MasterPasswordConfig();
    volatile String masterPasswdDigest;
    ConcurrentHashMap<String, GeoServerUserGroupService> userGroupServices = new ConcurrentHashMap();
    ConcurrentHashMap<String, GeoServerRoleService> roleServices = new ConcurrentHashMap();
    ConcurrentHashMap<String, PasswordValidator> passwordValidators = new ConcurrentHashMap();
    RoleServiceHelper roleServiceHelper = new RoleServiceHelper();
    UserGroupServiceHelper userGroupServiceHelper = new UserGroupServiceHelper();
    AuthProviderHelper authProviderHelper = new AuthProviderHelper();
    FilterHelper filterHelper = new FilterHelper();
    PasswordValidatorHelper passwordValidatorHelper = new PasswordValidatorHelper();
    MasterPasswordProviderHelper masterPasswordProviderHelper = new MasterPasswordProviderHelper();
    ConfigurationPasswordEncryptionHelper configPasswordEncryptionHelper;
    List<SecurityManagerListener> listeners = new ArrayList<SecurityManagerListener>();
    Boolean strongEncryptionAvaialble;
    boolean initialized = false;
    volatile KeyStoreProvider keyStoreProvider;
    RandomPasswordProvider randomPasswdProvider = new RandomPasswordProvider();
    volatile AuthenticationCache authCache;
    volatile RememberMeServices rememberMeService;
    private XStreamPersister xp;
    private XStreamPersister gxp;
    public static final String REALM = "GeoServer Realm";

    public GeoServerSecurityManager(GeoServerDataDirectory dataDir) throws Exception {
        this.dataDir = dataDir;
        this.setEraseCredentialsAfterAuthentication(true);
        Resource masterpw = this.security().get(MASTER_PASSWD_CONFIG_FILENAME);
        if (masterpw.getType() == Resource.Type.RESOURCE) {
            this.init(this.loadMasterPasswordConfig());
        }
        this.configPasswordEncryptionHelper = new ConfigurationPasswordEncryptionHelper(this);
    }

    public Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    public ConfigurationPasswordEncryptionHelper getConfigPasswordEncryptionHelper() {
        return this.configPasswordEncryptionHelper;
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
        this.xp = this.buildPersister();
        this.gxp = this.buildGlobalPersister();
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextLoadedEvent) {
            try {
                File masterPasswordInfo = new File(this.getSecurityRoot(), MASTER_PASSWD_INFO_FILENAME);
                if (masterPasswordInfo.exists()) {
                    LOGGER.warning(masterPasswordInfo.getCanonicalPath() + " is a security risk. Please read this file and remove it afterward");
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            try {
                Version securityVersion = this.getSecurityVersion();
                boolean migratedFrom21 = false;
                if (securityVersion.compareTo(VERSION_2_2) < 0) {
                    migratedFrom21 = this.migrateFrom21();
                }
                if (securityVersion.compareTo(VERSION_2_3) < 0) {
                    this.removeErroneousAccessDeniedPage();
                    this.migrateFrom22(migratedFrom21);
                }
                if (securityVersion.compareTo(VERSION_2_4) < 0) {
                    this.migrateFrom23();
                }
                if (securityVersion.compareTo(VERSION_2_5) < 0) {
                    this.migrateFrom24();
                }
                if (securityVersion.compareTo(CURR_VERSION) < 0) {
                    this.writeCurrentVersion();
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            KeyStoreProvider keyStoreProvider = this.getKeyStoreProvider();
            try {
                keyStoreProvider.commitMasterPasswordChange();
                this.init();
                for (GeoServerSecurityProvider securityProvider : GeoServerExtensions.extensions(GeoServerSecurityProvider.class)) {
                    securityProvider.init(this);
                }
            }
            catch (Exception e) {
                throw new BeanCreationException("Error occured reading security configuration", (Throwable)e);
            }
            try {
                this.afterPropertiesSetInternal();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (event instanceof ContextClosedEvent) {
            try {
                this.destroy();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error destroying security manager", e);
            }
        }
    }

    private Version getSecurityVersion() throws IOException {
        Resource security = this.security();
        if (security.getType() == Resource.Type.UNDEFINED) {
            return BASE_VERSION;
        }
        Resource properties = security.get(VERSION_PROPERTIES);
        if (properties.getType() == Resource.Type.UNDEFINED) {
            return BASE_VERSION;
        }
        Properties p = new Properties();
        try (InputStream is = properties.in();){
            p.load(is);
        }
        String version = p.getProperty(VERSION);
        if (version != null) {
            return new Version(version);
        }
        return BASE_VERSION;
    }

    private void writeCurrentVersion() throws IOException {
        Resource security = this.security();
        security.dir();
        Resource properties = security.get(VERSION_PROPERTIES);
        Properties p = new Properties();
        p.put(VERSION, CURR_VERSION.toString());
        try (OutputStream os = properties.out();){
            p.store(os, "Current version of the security directory. Do not remove or alter this file");
        }
    }

    void migrateFrom24() throws SecurityConfigException, IOException {
        MigrationHelper mh = new MigrationHelper(){

            @Override
            public void migrationPersister(XStreamPersister xp) {
                xp.getXStream().registerConverter(new Converter(){

                    public boolean canConvert(Class cls) {
                        return cls.isAssignableFrom(RoleSource.class);
                    }

                    public void marshal(Object rs, HierarchicalStreamWriter writer, MarshallingContext ctx) {
                        if (rs != null) {
                            writer.setValue(rs.toString());
                        }
                    }

                    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext ctx) {
                        if (reader.getValue() != null) {
                            return J2eeAuthenticationBaseFilterConfig.J2EERoleSource.valueOf(reader.getValue());
                        }
                        return null;
                    }
                });
            }
        };
        for (String fName : this.listFilters()) {
            PreAuthenticatedUserNameFilterConfig userNameConfig;
            RoleSource rs;
            SecurityFilterConfig fConfig = this.loadFilterConfig(fName, mh);
            if (fConfig == null) continue;
            if (fConfig instanceof J2eeAuthenticationBaseFilterConfig) {
                J2eeAuthenticationBaseFilterConfig j2eeConfig = (J2eeAuthenticationBaseFilterConfig)fConfig;
                if (j2eeConfig.getRoleSource() == null) {
                    j2eeConfig.setRoleSource(J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE);
                }
            } else if (fConfig instanceof PreAuthenticatedUserNameFilterConfig && (rs = (userNameConfig = (PreAuthenticatedUserNameFilterConfig)fConfig).getRoleSource()) != null) {
                userNameConfig.setRoleSource(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.valueOf(rs.toString()));
            }
            this.saveFilter(fConfig, mh);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    void afterPropertiesSetInternal() throws Exception {
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        for (GeoServerSecurityProvider securityProvider : GeoServerExtensions.extensions(GeoServerSecurityProvider.class)) {
            securityProvider.destroy(this);
        }
        this.userGroupServices.clear();
        this.roleServices.clear();
        this.userGroupServiceHelper.destroy();
        this.roleServiceHelper.destroy();
        this.rememberMeService = null;
        this.keyStoreProvider = null;
        this.listeners.clear();
        this.appContext = null;
    }

    public void addListener(SecurityManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SecurityManagerListener listener) {
        this.listeners.remove(listener);
    }

    public List<GeoServerAuthenticationProvider> getAuthenticationProviders() {
        return this.authProviders;
    }

    void init() throws Exception {
        this.init(this.loadMasterPasswordConfig());
        this.init(this.loadSecurityConfig());
        this.fireChanged();
    }

    void init(SecurityManagerConfig config) throws Exception {
        this.getKeyStoreProvider().reloadKeyStore();
        String roleServiceName = config.getRoleServiceName();
        GeoServerRoleService roleService = null;
        try {
            roleService = this.loadRoleService(roleServiceName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Error occured loading role service %s, falling back to default role service", roleServiceName), e);
        }
        if (roleService == null) {
            try {
                roleService = this.loadRoleService("default");
            }
            catch (Exception e) {
                throw new RuntimeException("Fatal error occurred loading default role service", e);
            }
        }
        this.setActiveRoleService(roleService);
        this.authProviders = new ArrayList<GeoServerAuthenticationProvider>();
        GeoServerRootAuthenticationProvider rootAuthProvider = new GeoServerRootAuthenticationProvider();
        rootAuthProvider.setSecurityManager(this);
        rootAuthProvider.initializeFromConfig(null);
        this.authProviders.add(rootAuthProvider);
        if (!config.getAuthProviderNames().isEmpty()) {
            for (String authProviderName : config.getAuthProviderNames()) {
                GeoServerAuthenticationProvider authProvider = this.authProviderHelper.load(authProviderName);
                this.authProviders.add(authProvider);
            }
        }
        ArrayList<GeoServerAuthenticationProvider> allAuthProviders = new ArrayList<GeoServerAuthenticationProvider>();
        allAuthProviders.addAll(this.authProviders);
        RememberMeAuthenticationProvider rap = new RememberMeAuthenticationProvider();
        rap.setKey(config.getRememberMeService().getKey());
        rap.afterPropertiesSet();
        allAuthProviders.add((GeoServerAuthenticationProvider)rap);
        this.setProviders(allAuthProviders);
        this.securityConfig = new SecurityManagerConfig(config);
        this.initialized = true;
    }

    void init(MasterPasswordConfig config) {
        this.masterPasswordConfig = new MasterPasswordConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStoreProvider getKeyStoreProvider() {
        if (this.keyStoreProvider == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                if (this.keyStoreProvider == null) {
                    this.keyStoreProvider = this.lookupKeyStoreProvider();
                }
            }
        }
        return this.keyStoreProvider;
    }

    KeyStoreProvider lookupKeyStoreProvider() {
        KeyStoreProvider ksp = (KeyStoreProvider)GeoServerExtensions.bean(KeyStoreProvider.class);
        if (ksp == null) {
            ksp = new KeyStoreProviderImpl();
        }
        ksp.setSecurityManager(this);
        return new LockingKeyStoreProvider(ksp);
    }

    public RandomPasswordProvider getRandomPassworddProvider() {
        return this.randomPasswdProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationCache getAuthenticationCache() {
        if (this.authCache == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                if (this.authCache == null) {
                    this.authCache = this.lookupAuthenticationCache();
                }
            }
        }
        return this.authCache;
    }

    AuthenticationCache lookupAuthenticationCache() {
        AuthenticationCache authCache = (AuthenticationCache)GeoServerExtensions.bean(AuthenticationCache.class);
        return authCache != null ? authCache : new GuavaAuthenticationCacheImpl(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RememberMeServices getRememberMeService() {
        if (this.rememberMeService == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                if (this.rememberMeService == null) {
                    this.rememberMeService = this.lookupRememberMeService();
                }
            }
        }
        return this.rememberMeService;
    }

    RememberMeServices lookupRememberMeService() {
        return (RememberMeServices)GeoServerExtensions.bean((String)"rememberMeServices");
    }

    public DataAccessRuleDAO getDataAccessRuleDAO() {
        return DataAccessRuleDAO.get();
    }

    public ServiceAccessRuleDAO getServiceAccessRuleDAO() {
        return ServiceAccessRuleDAO.get();
    }

    public RESTAccessRuleDAO getRESTAccessRuleDAO() {
        return RESTAccessRuleDAO.get();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Resource get(String path) {
        return this.dataDir.get(path);
    }

    public boolean remove(String path) {
        return this.dataDir.remove(path);
    }

    public boolean move(String path, String target) {
        return this.dataDir.move(path, target);
    }

    public Resource security() {
        return this.get("security");
    }

    public File getSecurityRoot() throws IOException {
        Resource directory = this.get("security");
        return directory.dir();
    }

    public Resource role() {
        return this.get("security/role");
    }

    public File getRoleRoot() throws IOException {
        Resource directory = this.get("security/role");
        return directory.dir();
    }

    public File getRoleRoot(boolean create) throws IOException {
        Resource directory = this.get("security/role");
        if (create) {
            return directory.dir();
        }
        return Resources.directory((Resource)directory);
    }

    public Resource passwordPolicy() {
        return this.get("security/pwpolicy");
    }

    public File getPasswordPolicyRoot() throws IOException {
        return this.get("security/pwpolicy").dir();
    }

    public Resource userGroup() throws IOException {
        return this.get("security/usergroup");
    }

    public File getUserGroupRoot() throws IOException {
        Resource directory = this.get("security/usergroup");
        return directory.dir();
    }

    public Resource auth() throws IOException {
        return this.get("security/auth");
    }

    public File getAuthRoot() throws IOException {
        Resource directory = this.get("security/auth");
        return directory.dir();
    }

    public Resource filterRoot() throws IOException {
        return this.get("security/filter");
    }

    public File getFilterRoot() throws IOException {
        Resource directory = this.get("security/filter");
        return directory.dir();
    }

    public Resource masterPasswordProvider() throws IOException {
        return this.get("security/masterpw");
    }

    public File getMasterPasswordProviderRoot() throws IOException {
        Resource resource = this.get("security/masterpw");
        return resource.dir();
    }

    public SortedSet<String> listRoleServices() throws IOException {
        return this.listFiles(this.getRoleRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoServerRoleService loadRoleService(String name) throws IOException {
        GeoServerRoleService roleService = this.roleServices.get(name);
        if (roleService == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                roleService = this.roleServices.get(name);
                if (roleService == null && (roleService = this.roleServiceHelper.load(name)) != null) {
                    this.roleServices.put(name, roleService);
                }
            }
        }
        return this.wrapRoleService(roleService);
    }

    GeoServerRoleService wrapRoleService(GeoServerRoleService roleService) throws IOException {
        if (!this.initialized) {
            return roleService;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.checkAuthenticationForAdminRole(auth)) {
            return roleService;
        }
        if (this.checkAuthenticationForRole(auth, GeoServerRole.GROUP_ADMIN_ROLE)) {
            roleService = new GroupAdminRoleService(roleService, this.calculateAdminGroups((UserDetails)auth.getPrincipal()));
        }
        return roleService;
    }

    List<String> calculateAdminGroups(UserDetails userDetails) throws IOException {
        Properties props;
        if (userDetails instanceof GeoServerUser && GroupAdminProperty.has(props = ((GeoServerUser)userDetails).getProperties())) {
            return Arrays.asList(GroupAdminProperty.get(props));
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (GeoServerUserGroupService ugService : this.loadUserGroupServices()) {
            GeoServerUser user = ugService.getUserByUsername(userDetails.getUsername());
            if (user == null) continue;
            for (GeoServerUserGroup group : ugService.getGroupsForUser(user)) {
                groupNames.add(group.getGroupname());
            }
        }
        return groupNames;
    }

    public SecurityRoleServiceConfig loadRoleServiceConfig(String name) throws IOException {
        return (SecurityRoleServiceConfig)this.roleServiceHelper.loadConfig(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordValidator loadPasswordValidator(String name) throws IOException {
        PasswordValidator validator = this.passwordValidators.get(name);
        if (validator == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                validator = this.passwordValidators.get(name);
                if (validator == null && (validator = this.passwordValidatorHelper.load(name)) != null) {
                    this.passwordValidators.put(name, validator);
                }
            }
        }
        return validator;
    }

    public PasswordPolicyConfig loadPasswordPolicyConfig(String name) throws IOException {
        return (PasswordPolicyConfig)this.passwordValidatorHelper.loadConfig(name);
    }

    public GeoServerPasswordEncoder loadPasswordEncoder(String name) {
        GeoServerPasswordEncoder encoder = (GeoServerPasswordEncoder)GeoServerExtensions.bean((String)name);
        if (encoder != null) {
            try {
                encoder.initialize(this);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred initializing password encoder");
            }
        }
        return encoder;
    }

    public <T extends GeoServerPasswordEncoder> T loadPasswordEncoder(Class<T> filter) {
        return this.loadPasswordEncoder(filter, null, null);
    }

    public <T extends GeoServerPasswordEncoder> T loadPasswordEncoder(Class<T> filter, Boolean reversible, Boolean strong) {
        List<T> pw = this.loadPasswordEncoders(filter, reversible, strong);
        return (T)(pw.isEmpty() ? null : (GeoServerPasswordEncoder)pw.get(0));
    }

    public List<GeoServerPasswordEncoder> loadPasswordEncoders() {
        return this.loadPasswordEncoders(null);
    }

    public <T extends GeoServerPasswordEncoder> List<T> loadPasswordEncoders(Class<T> filter) {
        return this.loadPasswordEncoders(filter, null, null);
    }

    public <T extends GeoServerPasswordEncoder> List<T> loadPasswordEncoders(Class<T> filter, Boolean reversible, Boolean strong) {
        filter = filter != null ? filter : GeoServerPasswordEncoder.class;
        List list2 = GeoServerExtensions.extensions(filter);
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            boolean remove = false;
            GeoServerPasswordEncoder pw = (GeoServerPasswordEncoder)it.next();
            if (reversible != null && !reversible.equals(pw.isReversible())) {
                remove = true;
            }
            if (!remove && strong != null && strong.equals(pw.isAvailableWithoutStrongCryptogaphy())) {
                remove = true;
            }
            if (remove) {
                it.remove();
                continue;
            }
            try {
                pw.initialize(this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error initializing password encoder " + pw.getName() + ", skipping", e);
                it.remove();
            }
        }
        return list2;
    }

    public boolean isStrongEncryptionAvailable() {
        if (this.strongEncryptionAvaialble != null) {
            return this.strongEncryptionAvaialble;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(256);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            cipher.doFinal("This is just an example".getBytes());
            this.strongEncryptionAvaialble = true;
            LOGGER.info("Strong cryptography is available");
        }
        catch (InvalidKeyException e) {
            this.strongEncryptionAvaialble = false;
            LOGGER.warning("Strong cryptography is NOT available\nDownload and installation the of unlimted length policy files is recommended");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Strong cryptography is NOT available, unexpected error", ex);
            this.strongEncryptionAvaialble = false;
        }
        return this.strongEncryptionAvaialble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRoleService(SecurityRoleServiceConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerRoleService.class, config.getClassName());
        if (config.getId() == null) {
            config.initBeforeSave();
            validator.validateAddRoleService(config);
        } else {
            validator.validateModifiedRoleService(config, (SecurityRoleServiceConfig)this.roleServiceHelper.loadConfig(config.getName()));
        }
        this.roleServiceHelper.saveConfig(config);
        this.roleServices.remove(config.getName());
        if (this.activeRoleService != null && config.getName().equals(this.activeRoleService.getName())) {
            GeoServerRoleService geoServerRoleService = this.activeRoleService;
            synchronized (geoServerRoleService) {
                this.activeRoleService.initializeFromConfig(config);
            }
        }
    }

    public void savePasswordPolicy(PasswordPolicyConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(PasswordValidator.class, config.getClassName());
        if (config.getId() == null) {
            config.initBeforeSave();
            validator.validateAddPasswordPolicy(config);
        } else {
            validator.validateModifiedPasswordPolicy(config, (PasswordPolicyConfig)this.passwordValidatorHelper.loadConfig(config.getName()));
        }
        this.passwordValidatorHelper.saveConfig(config);
    }

    public void removeRoleService(SecurityRoleServiceConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerRoleService.class, config.getClassName());
        validator.validateRemoveRoleService(config);
        this.roleServices.remove(config.getName());
        this.roleServiceHelper.removeConfig(config.getName());
    }

    public void removePasswordValidator(PasswordPolicyConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(PasswordValidator.class, config.getClassName());
        validator.validateRemovePasswordPolicy(config);
        this.passwordValidators.remove(config.getName());
        this.passwordValidatorHelper.removeConfig(config.getName());
    }

    public SortedSet<String> listUserGroupServices() throws IOException {
        return this.listFiles(this.getUserGroupRoot());
    }

    public SortedSet<String> listPasswordValidators() throws IOException {
        return this.listFiles(this.getPasswordPolicyRoot());
    }

    public List<GeoServerUserGroupService> loadUserGroupServices() throws IOException {
        ArrayList<GeoServerUserGroupService> ugServices = new ArrayList<GeoServerUserGroupService>();
        for (String ugServiceName : this.listUserGroupServices()) {
            try {
                GeoServerUserGroupService ugService = this.userGroupServiceHelper.load(ugServiceName);
                ugServices.add(ugService);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load user group service " + ugServiceName, e);
            }
        }
        return ugServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoServerUserGroupService loadUserGroupService(String name) throws IOException {
        GeoServerUserGroupService ugService = this.userGroupServices.get(name);
        if (ugService == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                ugService = this.userGroupServices.get(name);
                if (ugService == null && (ugService = this.userGroupServiceHelper.load(name)) != null) {
                    this.userGroupServices.put(name, ugService);
                }
            }
        }
        return this.wrapUserGroupService(ugService);
    }

    GeoServerUserGroupService wrapUserGroupService(GeoServerUserGroupService ugService) throws IOException {
        if (!this.initialized) {
            return ugService;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.checkAuthenticationForAdminRole(auth)) {
            return ugService;
        }
        if (this.checkAuthenticationForRole(auth, GeoServerRole.GROUP_ADMIN_ROLE)) {
            ugService = new GroupAdminUserGroupService(ugService, this.calculateAdminGroups((UserDetails)auth.getPrincipal()));
        }
        return ugService;
    }

    public SecurityUserGroupServiceConfig loadUserGroupServiceConfig(String name) throws IOException {
        return (SecurityUserGroupServiceConfig)this.userGroupServiceHelper.loadConfig(name);
    }

    public void saveUserGroupService(SecurityUserGroupServiceConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerUserGroupService.class, config.getClassName());
        if (config.getId() == null) {
            config.initBeforeSave();
            validator.validateAddUserGroupService(config);
        } else {
            validator.validateModifiedUserGroupService(config, (SecurityUserGroupServiceConfig)this.userGroupServiceHelper.loadConfig(config.getName()));
        }
        this.userGroupServiceHelper.saveConfig(config);
        this.userGroupServices.remove(config.getName());
    }

    public void removeUserGroupService(SecurityUserGroupServiceConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerUserGroupService.class, config.getClassName());
        validator.validateRemoveUserGroupService(config);
        this.userGroupServices.remove(config.getName());
        this.userGroupServiceHelper.removeConfig(config.getName());
    }

    public SortedSet<String> listAuthenticationProviders() throws IOException {
        return this.listFiles(this.getAuthRoot());
    }

    public GeoServerAuthenticationProvider loadAuthenticationProvider(String name) throws IOException {
        return this.authProviderHelper.load(name);
    }

    public SecurityAuthProviderConfig loadAuthenticationProviderConfig(String name) throws IOException {
        return (SecurityAuthProviderConfig)this.authProviderHelper.loadConfig(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAuthenticationProvider(SecurityAuthProviderConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerAuthenticationProvider.class, config.getClassName());
        if (config.getId() == null) {
            config.initBeforeSave();
            validator.validateAddAuthProvider(config);
        } else {
            validator.validateModifiedAuthProvider(config, (SecurityAuthProviderConfig)this.authProviderHelper.loadConfig(config.getName()));
        }
        if (this.authProviders != null) {
            AbstractGeoServerSecurityService authProvider = null;
            for (GeoServerAuthenticationProvider ap : this.authProviders) {
                if (!config.getName().equals(ap.getName())) continue;
                authProvider = ap;
                break;
            }
            if (authProvider != null) {
                AbstractGeoServerSecurityService abstractGeoServerSecurityService = authProvider;
                synchronized (abstractGeoServerSecurityService) {
                    authProvider.initializeFromConfig(config);
                }
            }
        }
        this.authProviderHelper.saveConfig(config);
    }

    public boolean checkAuthenticationForAdminRole() {
        if (SecurityContextHolder.getContext() == null) {
            return this.checkAuthenticationForAdminRole(null);
        }
        return this.checkAuthenticationForAdminRole(SecurityContextHolder.getContext().getAuthentication());
    }

    public boolean checkAuthenticationForAdminRole(Authentication auth) {
        return this.checkAuthenticationForRole(auth, GeoServerRole.ADMIN_ROLE);
    }

    public boolean checkAuthenticationForRole(Authentication auth, GeoServerRole role) {
        if (!GeoServerSecurityFilterChainProxy.isSecurityEnabledForCurrentRequest()) {
            return true;
        }
        if (auth == null || !auth.isAuthenticated()) {
            return false;
        }
        for (GrantedAuthority authority : auth.getAuthorities()) {
            if (!role.getAuthority().equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public boolean checkForDefaultAdminPassword() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"geoserver");
        try {
            token = this.authenticate((Authentication)token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token.isAuthenticated();
    }

    public SortedSet<String> listFilters() throws IOException {
        return this.listFiles(this.getFilterRoot());
    }

    public SortedSet<String> listFilters(Class<?> type) throws IOException {
        TreeSet<String> configs = new TreeSet<String>();
        for (String name : this.listFilters()) {
            SecurityFilterConfig config = this.loadFilterConfig(name);
            if (config.getClassName() == null) continue;
            try {
                if (!type.isAssignableFrom(Class.forName(config.getClassName()))) continue;
                configs.add(config.getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return configs;
    }

    public GeoServerSecurityFilter loadFilter(String name) throws IOException {
        return this.filterHelper.load(name);
    }

    public SecurityFilterConfig loadFilterConfig(String name, MigrationHelper migrationHelper) throws IOException {
        return (SecurityFilterConfig)this.filterHelper.loadConfig(name, migrationHelper);
    }

    public SecurityFilterConfig loadFilterConfig(String name) throws IOException {
        return (SecurityFilterConfig)this.filterHelper.loadConfig(name);
    }

    public void saveFilter(SecurityNamedServiceConfig config) throws IOException, SecurityConfigException {
        this.saveFilter(config, null);
    }

    public void saveFilter(SecurityNamedServiceConfig config, MigrationHelper migrationHelper) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerSecurityFilter.class, config.getClassName());
        boolean fireChanged = false;
        if (config.getId() == null) {
            config.initBeforeSave();
            validator.validateAddFilter(config);
        } else {
            validator.validateModifiedFilter(config, (SecurityNamedServiceConfig)this.filterHelper.loadConfig(config.getName(), migrationHelper));
            this.getAuthenticationCache().removeAll(config.getName());
            if (!this.securityConfig.getFilterChain().patternsForFilter(config.getName(), true).isEmpty()) {
                fireChanged = true;
            }
        }
        this.filterHelper.saveConfig(config);
        if (fireChanged) {
            this.fireChanged();
        }
    }

    public void removeAuthenticationProvider(SecurityAuthProviderConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerAuthenticationProvider.class, config.getClassName());
        validator.validateRemoveAuthProvider(config);
        this.authProviderHelper.removeConfig(config.getName());
    }

    public void removeFilter(SecurityNamedServiceConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(GeoServerSecurityFilter.class, config.getClassName());
        validator.validateRemoveFilter(config);
        this.getAuthenticationCache().removeAll(config.getName());
        this.filterHelper.removeConfig(config.getName());
    }

    public SecurityManagerConfig getSecurityConfig() {
        return new SecurityManagerConfig(this.securityConfig);
    }

    public boolean isEncryptingUrlParams() {
        if (this.securityConfig == null) {
            return false;
        }
        return this.securityConfig.isEncryptingUrlParams();
    }

    public synchronized void saveSecurityConfig(SecurityManagerConfig config) throws Exception {
        SecurityManagerConfig oldConfig = new SecurityManagerConfig(this.securityConfig);
        SecurityConfigValidator validator = new SecurityConfigValidator(this);
        validator.validateManagerConfig(config, oldConfig);
        try {
            this.init(config);
            if (!config.getConfigPasswordEncrypterName().equals(oldConfig.getConfigPasswordEncrypterName())) {
                this.updateConfigurationFilesWithEncryptedFields();
            }
            IOUtils.xStreamPersist(new File(this.getSecurityRoot(), CONFIG_FILENAME), (Object)config, this.globalPersister());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error saving security config, reverting back to previous", e);
            this.init(oldConfig);
            return;
        }
        this.fireChanged();
    }

    public MasterPasswordConfig getMasterPasswordConfig() {
        return new MasterPasswordConfig(this.masterPasswordConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void saveMasterPasswordConfig(MasterPasswordConfig config, char[] currPasswd, char[] newPasswd, char[] newPasswdConfirm) throws Exception {
        KeyStoreProvider ksProvider;
        MasterPasswordProviderConfig mpProviderConfig = this.loadMasterPassswordProviderConfig(config.getProviderName());
        MasterPasswordProvider mpProvider = this.loadMasterPasswordProvider(config.getProviderName());
        if (mpProviderConfig.isReadOnly()) {
            newPasswd = mpProvider.getMasterPassword();
        }
        MasterPasswordChangeRequest req = new MasterPasswordChangeRequest();
        req.setCurrentPassword(currPasswd);
        req.setNewPassword(newPasswd);
        req.setConfirmPassword(newPasswdConfirm);
        MasterPasswordChangeValidator val = new MasterPasswordChangeValidator(this);
        val.validateChangeRequest(req);
        MasterPasswordConfigValidator validator = new MasterPasswordConfigValidator(this);
        validator.validateMasterPasswordConfig(config);
        MasterPasswordConfig oldConfig = new MasterPasswordConfig(this.masterPasswordConfig);
        String oldMasterPasswdDigest = this.masterPasswdDigest;
        KeyStoreProvider keyStoreProvider = ksProvider = this.getKeyStoreProvider();
        synchronized (keyStoreProvider) {
            ksProvider.prepareForMasterPasswordChange(currPasswd, newPasswdConfirm);
            try {
                if (!mpProviderConfig.isReadOnly()) {
                    try {
                        mpProvider.setMasterPassword(newPasswd);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                this.saveMasterPasswordConfig(config);
                this.masterPasswdDigest = this.computeAndSaveMasterPasswordDigest(newPasswdConfirm);
                ksProvider.commitMasterPasswordChange();
                if (config.getProviderName().equals(oldConfig.getProviderName())) return;
            }
            catch (IOException e) {
                ksProvider.abortMasterPasswordChange();
                this.masterPasswordConfig = oldConfig;
                this.masterPasswdDigest = oldMasterPasswdDigest;
                this.saveMasterPasswordDigest(oldMasterPasswdDigest);
                throw e;
            }
            {
                // empty if block
            }
            return;
        }
    }

    public void saveMasterPasswordConfig(MasterPasswordConfig config) throws IOException {
        IOUtils.xStreamPersist(new File(this.getSecurityRoot(), MASTER_PASSWD_CONFIG_FILENAME), (Object)config, this.globalPersister());
        this.masterPasswordConfig = new MasterPasswordConfig(config);
    }

    public boolean checkMasterPassword(String passwd) {
        return this.checkMasterPassword(passwd.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMasterPassword(char[] passwd) {
        GeoServerDigestPasswordEncoder pwEncoder = this.loadPasswordEncoder(GeoServerDigestPasswordEncoder.class);
        if (this.masterPasswdDigest == null) {
            GeoServerSecurityManager geoServerSecurityManager = this;
            synchronized (geoServerSecurityManager) {
                if (this.masterPasswdDigest == null) {
                    try {
                        this.masterPasswdDigest = this.loadMasterPasswordDigest();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to create master password digest", e);
                    }
                }
            }
        }
        return pwEncoder.isPasswordValid(this.masterPasswdDigest, passwd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadMasterPasswordDigest() throws IOException {
        File pwDigestFile = new File(this.getSecurityRoot(), MASTER_PASSWD_DIGEST_FILENAME);
        if (pwDigestFile.exists()) {
            try (FileInputStream fin = new FileInputStream(pwDigestFile);){
                String string = org.apache.commons.io.IOUtils.toString((InputStream)fin);
                return string;
            }
        }
        char[] masterPasswd = this.getMasterPassword();
        try {
            String string = this.computeAndSaveMasterPasswordDigest(masterPasswd);
            return string;
        }
        finally {
            this.disposePassword(masterPasswd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveMasterPasswordDigest(String masterPasswdDigest) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(new File(this.getSecurityRoot(), MASTER_PASSWD_DIGEST_FILENAME));){
            org.apache.commons.io.IOUtils.write((String)masterPasswdDigest, (OutputStream)fout);
        }
    }

    String computeAndSaveMasterPasswordDigest(char[] passwd) throws IOException {
        GeoServerDigestPasswordEncoder pwEncoder = this.loadPasswordEncoder(GeoServerDigestPasswordEncoder.class);
        String masterPasswdDigest = pwEncoder.encodePassword(passwd, null);
        this.saveMasterPasswordDigest(masterPasswdDigest);
        return masterPasswdDigest;
    }

    char[] getMasterPassword() {
        try {
            MasterPasswordProvider mpp = this.loadMasterPasswordProvider(this.getMasterPasswordConfig().getProviderName());
            return mpp.getMasterPassword();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void disposePassword(char[] passwd) {
        SecurityUtils.scramble(passwd);
    }

    public void disposePassword(byte[] passwd) {
        SecurityUtils.scramble(passwd);
    }

    public MasterPasswordProviderConfig loadMasterPassswordProviderConfig(String name) throws IOException {
        return (MasterPasswordProviderConfig)this.masterPasswordProviderHelper.loadConfig(name);
    }

    protected MasterPasswordProvider loadMasterPasswordProvider(String name) throws IOException {
        return this.masterPasswordProviderHelper.load(name);
    }

    public void saveMasterPasswordProviderConfig(MasterPasswordProviderConfig config) throws IOException, SecurityConfigException {
        this.saveMasterPasswordProviderConfig(config, true);
    }

    void saveMasterPasswordProviderConfig(MasterPasswordProviderConfig config, boolean validate) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(MasterPasswordProvider.class, config.getClassName());
        if (config.getId() == null) {
            config.initBeforeSave();
            if (validate) {
                validator.validateAddMasterPasswordProvider(config);
            }
        } else if (validate) {
            validator.validateModifiedMasterPasswordProvider(config, (MasterPasswordProviderConfig)this.masterPasswordProviderHelper.loadConfig(config.getName()));
        }
        this.masterPasswordProviderHelper.saveConfig(config);
    }

    public void removeMasterPasswordProvder(MasterPasswordProviderConfig config) throws IOException, SecurityConfigException {
        SecurityConfigValidator validator = SecurityConfigValidator.getConfigurationValiator(MasterPasswordProvider.class, config.getClassName());
        validator.validateRemoveMasterPasswordProvider(config);
        this.masterPasswordProviderHelper.removeConfig(config.getName());
    }

    public SortedSet<String> listMasterPasswordProviders() throws IOException {
        return this.listFiles(this.getMasterPasswordProviderRoot());
    }

    void fireChanged() {
        for (SecurityManagerListener l : this.listeners) {
            l.handlePostChanged(this);
        }
    }

    char[] extractMasterPasswordForMigration(Properties props) throws Exception {
        String username;
        String masterPW;
        HashMap<String, String> candidates = new HashMap<String, String>();
        String defaultPasswordAsString = new String(MASTER_PASSWD_DEFAULT);
        if (props != null) {
            UserAttributeEditor configAttribEd = new UserAttributeEditor();
            for (String string : props.keySet()) {
                configAttribEd.setAsText(props.getProperty(string));
                UserAttribute attr = (UserAttribute)configAttribEd.getValue();
                if (attr == null || attr.getPassword() == null || attr.getPassword().length() < 8 || defaultPasswordAsString.equals(attr.getPassword())) continue;
                if ("admin".equals(string)) {
                    candidates.put("admin", attr.getPassword());
                    continue;
                }
                if (!attr.getAuthorities().contains(GeoServerRole.ADMIN_ROLE)) continue;
                candidates.put(string, attr.getPassword());
            }
        }
        if ((masterPW = (String)candidates.get(username = "admin")) == null && candidates.size() > 0) {
            username = (String)candidates.keySet().iterator().next();
            masterPW = (String)candidates.get(username);
        }
        Object var6_7 = null;
        File info = new File(this.getSecurityRoot(), MASTER_PASSWD_INFO_FILENAME);
        char[] masterPasswordArray = null;
        if (masterPW != null) {
            String string = "Master password is identical to the password of user: " + username;
            masterPasswordArray = masterPW.toCharArray();
            this.writeMasterPasswordInfo(info, string, null);
        } else {
            String string = "The generated master password is: ";
            masterPasswordArray = this.getRandomPassworddProvider().getRandomPassword(8);
            this.writeMasterPasswordInfo(info, string, masterPasswordArray);
        }
        LOGGER.info("Information regarding the master password is in: " + info.getCanonicalPath());
        return masterPasswordArray;
    }

    void writeMasterPasswordInfo(File file, String message, char[] masterPasswordArray) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        w.write("This file was created at " + dateFormat.format(new Date()));
        w.newLine();
        w.newLine();
        w.write(message);
        if (masterPasswordArray != null) {
            w.write(masterPasswordArray);
        }
        w.newLine();
        w.newLine();
        w.write("Test the master password by logging in as user \"root\"");
        w.newLine();
        w.newLine();
        w.write("This file should be removed after reading !!!.");
        w.newLine();
        w.close();
    }

    public boolean dumpMasterPassword(File file) throws IOException {
        if (!this.checkAuthenticationForAdminRole()) {
            LOGGER.warning("Unautorized user tries to dump master password");
            return false;
        }
        String[][] allowedMethods = new String[][]{{"org.geoserver.security.GeoServerSecurityManagerTest", "testMasterPasswordDump"}, {"org.geoserver.security.web.passwd.MasterPasswordInfoPage", "dumpMasterPassword"}};
        String result = this.checkStackTrace(10, allowedMethods);
        if (result != null) {
            LOGGER.warning("Dump master password is called by an unautorized method\n" + result);
            return false;
        }
        String message = "The current master password is: ";
        this.writeMasterPasswordInfo(file, message, this.getMasterPassword());
        return true;
    }

    public char[] getMasterPasswordForREST() throws IOException {
        if (!this.checkAuthenticationForAdminRole()) {
            throw new IOException("Unauthorized user tries to read master password");
        }
        String[][] allowedMethods = new String[][]{{"org.geoserver.security.rest.MasterPasswordResource", "getMap"}};
        String result = this.checkStackTrace(10, allowedMethods);
        if (result != null) {
            throw new IOException("Unauthorized method wants to read master password\n" + result);
        }
        return this.getMasterPassword();
    }

    String checkStackTrace(int countMethodsToCheck, String[][] allowedMethods) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isAllowed = false;
        block0: for (int i = 0; i < countMethodsToCheck; ++i) {
            StackTraceElement element = stackTraceElements[i];
            for (String[] methodEntry : allowedMethods) {
                if (!methodEntry[0].equals(element.getClassName()) || !methodEntry[1].equals(element.getMethodName())) continue;
                isAllowed = true;
                continue block0;
            }
        }
        if (isAllowed) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < countMethodsToCheck; ++i) {
            StackTraceElement element = stackTraceElements[i];
            buff.append(element.getClassName()).append(" : ").append(element.getMethodName()).append("\n");
        }
        return buff.toString();
    }

    boolean migrateFrom21() throws Exception {
        File dataFile;
        Properties props;
        GeoServerAuthenticationProvider authProvider;
        SecurityInterceptorFilterConfig siConfig;
        SecurityContextPersistenceFilterConfig pConfig;
        SecurityFilterConfig bfConfig;
        String filterName;
        GeoServerSecurityFilter filter;
        GeoServerRoleService roleService;
        PasswordPolicyConfig pwpconfig;
        if (this.getRoleRoot(false) != null) {
            File oldUserFile = new File(this.getSecurityRoot(), "users.properties.old");
            if (oldUserFile.exists()) {
                LOGGER.warning(oldUserFile.getCanonicalPath() + " could be removed manually");
            }
            return false;
        }
        LOGGER.info("Start security migration");
        this.getRoleRoot();
        this.getUserGroupRoot();
        this.getAuthRoot();
        this.getPasswordPolicyRoot();
        this.getFilterRoot();
        this.getMasterPasswordProviderRoot();
        MasterPasswordProviderConfig mpProviderConfig = this.loadMasterPassswordProviderConfig("default");
        if (mpProviderConfig == null) {
            mpProviderConfig = new URLMasterPasswordProviderConfig();
            mpProviderConfig.setName("default");
            mpProviderConfig.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
            mpProviderConfig.setReadOnly(false);
            ((URLMasterPasswordProviderConfig)mpProviderConfig).setURL(new URL("file:passwd"));
            ((URLMasterPasswordProviderConfig)mpProviderConfig).setEncrypting(true);
            this.saveMasterPasswordProviderConfig(mpProviderConfig, false);
            MasterPasswordProvider mpProvider = this.loadMasterPasswordProvider(mpProviderConfig.getName());
            File propFile = new File(this.getSecurityRoot(), "users.properties");
            Properties userprops = null;
            if (propFile.exists()) {
                userprops = Util.loadPropertyFile(propFile);
            }
            mpProvider.setMasterPassword(this.extractMasterPasswordForMigration(userprops));
        }
        MasterPasswordConfig mpConfig = new MasterPasswordConfig();
        mpConfig.setProviderName(mpProviderConfig.getName());
        this.saveMasterPasswordConfig(mpConfig);
        File serviceFile = new File(this.getSecurityRoot(), "services.properties");
        if (!serviceFile.exists()) {
            FileUtils.copyURLToFile((URL)Util.class.getResource("serviceTemplate.properties"), (File)serviceFile);
        }
        long checkInterval = 10000L;
        GeoServerUserGroupService userGroupService = this.loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        KeyStoreProvider keyStoreProvider = this.getKeyStoreProvider();
        keyStoreProvider.reloadKeyStore();
        keyStoreProvider.setUserGroupKey(XMLUserGroupService.DEFAULT_NAME, this.randomPasswdProvider.getRandomPassword(32));
        keyStoreProvider.storeKeyStore();
        PasswordValidator validator = this.loadPasswordValidator("default");
        if (validator == null) {
            pwpconfig = new PasswordPolicyConfig();
            pwpconfig.setName("default");
            pwpconfig.setClassName(PasswordValidatorImpl.class.getName());
            pwpconfig.setMinLength(0);
            this.savePasswordPolicy(pwpconfig);
            validator = this.loadPasswordValidator("default");
        }
        if ((validator = this.loadPasswordValidator("master")) == null) {
            pwpconfig = new PasswordPolicyConfig();
            pwpconfig.setName("master");
            pwpconfig.setClassName(PasswordValidatorImpl.class.getName());
            pwpconfig.setMinLength(8);
            this.savePasswordPolicy(pwpconfig);
            validator = this.loadPasswordValidator("master");
        }
        if (userGroupService == null) {
            XMLUserGroupServiceConfig ugConfig = new XMLUserGroupServiceConfig();
            ugConfig.setName(XMLUserGroupService.DEFAULT_NAME);
            ugConfig.setClassName(XMLUserGroupService.class.getName());
            ugConfig.setCheckInterval(checkInterval);
            ugConfig.setFileName("users.xml");
            ugConfig.setValidating(true);
            ugConfig.setPasswordEncoderName(this.loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, false).getName());
            ugConfig.setPasswordPolicyName("default");
            this.saveUserGroupService(ugConfig);
            userGroupService = this.loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        }
        if ((roleService = this.loadRoleService(XMLRoleService.DEFAULT_NAME)) == null) {
            XMLRoleServiceConfig gaConfig = new XMLRoleServiceConfig();
            gaConfig.setName(XMLRoleService.DEFAULT_NAME);
            gaConfig.setClassName(XMLRoleService.class.getName());
            gaConfig.setCheckInterval(checkInterval);
            gaConfig.setFileName("roles.xml");
            gaConfig.setValidating(true);
            gaConfig.setAdminRoleName(XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
            gaConfig.setGroupAdminRoleName(XMLRoleService.DEFAULT_LOCAL_GROUP_ADMIN_ROLE);
            this.saveRoleService(gaConfig);
            roleService = this.loadRoleService(XMLRoleService.DEFAULT_NAME);
        }
        if ((filter = this.loadFilter(filterName = "basic")) == null) {
            bfConfig = new BasicAuthenticationFilterConfig();
            bfConfig.setName(filterName);
            bfConfig.setClassName(GeoServerBasicAuthenticationFilter.class.getName());
            ((BasicAuthenticationFilterConfig)bfConfig).setUseRememberMe(true);
            this.saveFilter(bfConfig);
        }
        if ((filter = this.loadFilter(filterName = "form")) == null) {
            UsernamePasswordAuthenticationFilterConfig upConfig = new UsernamePasswordAuthenticationFilterConfig();
            upConfig.setClassName(GeoServerUserNamePasswordAuthenticationFilter.class.getName());
            upConfig.setName(filterName);
            upConfig.setUsernameParameterName("username");
            upConfig.setPasswordParameterName("password");
            this.saveFilter(upConfig);
        }
        if ((filter = this.loadFilter(filterName = "contextAsc")) == null) {
            pConfig = new SecurityContextPersistenceFilterConfig();
            pConfig.setClassName(GeoServerSecurityContextPersistenceFilter.class.getName());
            pConfig.setName(filterName);
            pConfig.setAllowSessionCreation(true);
            this.saveFilter(pConfig);
        }
        if ((filter = this.loadFilter(filterName = "contextNoAsc")) == null) {
            pConfig = new SecurityContextPersistenceFilterConfig();
            pConfig.setClassName(GeoServerSecurityContextPersistenceFilter.class.getName());
            pConfig.setName(filterName);
            pConfig.setAllowSessionCreation(false);
            this.saveFilter(pConfig);
        }
        if ((filter = this.loadFilter(filterName = "anonymous")) == null) {
            AnonymousAuthenticationFilterConfig aConfig = new AnonymousAuthenticationFilterConfig();
            aConfig.setClassName(GeoServerAnonymousAuthenticationFilter.class.getName());
            aConfig.setName(filterName);
            this.saveFilter(aConfig);
        }
        if ((filter = this.loadFilter(filterName = "rememberme")) == null) {
            RememberMeAuthenticationFilterConfig rConfig = new RememberMeAuthenticationFilterConfig();
            rConfig.setClassName(GeoServerRememberMeAuthenticationFilter.class.getName());
            rConfig.setName(filterName);
            this.saveFilter(rConfig);
        }
        if ((filter = this.loadFilter(filterName = "interceptor")) == null) {
            siConfig = new SecurityInterceptorFilterConfig();
            siConfig.setClassName(GeoServerSecurityInterceptorFilter.class.getName());
            siConfig.setName(filterName);
            siConfig.setAllowIfAllAbstainDecisions(false);
            siConfig.setSecurityMetadataSource("geoserverMetadataSource");
            this.saveFilter(siConfig);
        }
        if ((filter = this.loadFilter(filterName = "restInterceptor")) == null) {
            siConfig = new SecurityInterceptorFilterConfig();
            siConfig.setClassName(GeoServerSecurityInterceptorFilter.class.getName());
            siConfig.setName(filterName);
            siConfig.setAllowIfAllAbstainDecisions(false);
            siConfig.setSecurityMetadataSource("restFilterDefinitionMap");
            this.saveFilter(siConfig);
        }
        if ((filter = this.loadFilter(filterName = "formLogout")) == null) {
            LogoutFilterConfig loConfig = new LogoutFilterConfig();
            loConfig.setClassName(GeoServerLogoutFilter.class.getName());
            loConfig.setName(filterName);
            this.saveFilter(loConfig);
        }
        if ((filter = this.loadFilter(filterName = "exception")) == null) {
            bfConfig = new ExceptionTranslationFilterConfig();
            bfConfig.setClassName(GeoServerExceptionTranslationFilter.class.getName());
            bfConfig.setName(filterName);
            ((ExceptionTranslationFilterConfig)bfConfig).setAuthenticationFilterName(null);
            ((ExceptionTranslationFilterConfig)bfConfig).setAccessDeniedErrorPage("/accessDenied.jsp");
            this.saveFilter(bfConfig);
        }
        if ((filter = this.loadFilter(filterName = "guiException")) == null) {
            bfConfig = new ExceptionTranslationFilterConfig();
            bfConfig.setClassName(GeoServerExceptionTranslationFilter.class.getName());
            bfConfig.setName(filterName);
            ((ExceptionTranslationFilterConfig)bfConfig).setAuthenticationFilterName("form");
            ((ExceptionTranslationFilterConfig)bfConfig).setAccessDeniedErrorPage("/accessDenied.jsp");
            this.saveFilter(bfConfig);
        }
        if ((authProvider = this.loadAuthenticationProvider(GeoServerAuthenticationProvider.DEFAULT_NAME)) == null) {
            UsernamePasswordAuthenticationProviderConfig upAuthConfig = new UsernamePasswordAuthenticationProviderConfig();
            upAuthConfig.setName(GeoServerAuthenticationProvider.DEFAULT_NAME);
            upAuthConfig.setClassName(UsernamePasswordAuthenticationProvider.class.getName());
            upAuthConfig.setUserGroupServiceName(userGroupService.getName());
            this.saveAuthenticationProvider(upAuthConfig);
            authProvider = this.loadAuthenticationProvider(GeoServerAuthenticationProvider.DEFAULT_NAME);
        }
        SecurityManagerConfig config = new SecurityManagerConfig();
        config.setRoleServiceName(roleService.getName());
        config.getAuthProviderNames().add(authProvider.getName());
        config.setEncryptingUrlParams(false);
        config.setConfigPasswordEncrypterName(this.loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, true, false).getName());
        RememberMeServicesConfig rememberMeConfig = new RememberMeServicesConfig();
        rememberMeConfig.setClassName(GeoServerTokenBasedRememberMeServices.class.getName());
        config.setRememberMeService(rememberMeConfig);
        config.setFilterChain(GeoServerSecurityFilterChain.createInitialChain());
        this.saveSecurityConfig(config);
        userGroupService.setSecurityManager(this);
        roleService.setSecurityManager(this);
        GeoServerUserGroupStore userGroupStore = userGroupService.createStore();
        GeoServerRoleStore roleStore = roleService.createStore();
        File usersFile = new File(this.getSecurityRoot(), "users.properties");
        if (usersFile.exists()) {
            props = Util.loadPropertyFile(usersFile);
            UserAttributeEditor configAttribEd = new UserAttributeEditor();
            for (String string : props.keySet()) {
                configAttribEd.setAsText(props.getProperty(string));
                UserAttribute attr = (UserAttribute)configAttribEd.getValue();
                if (attr == null) continue;
                GeoServerUser user = userGroupStore.createUserObject(string, attr.getPassword(), attr.isEnabled());
                userGroupStore.addUser(user);
                for (GrantedAuthority auth : attr.getAuthorities()) {
                    String roleName = GeoServerRole.ADMIN_ROLE.getAuthority().equals(auth.getAuthority()) ? XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE : auth.getAuthority();
                    GeoServerRole role = roleStore.getRoleByName(roleName);
                    if (role == null) {
                        role = roleStore.createRoleObject(roleName);
                        roleStore.addRole(role);
                    }
                    roleStore.associateRoleToUser(role, string);
                }
            }
        } else if (userGroupService.getUserByUsername("admin") == null) {
            userGroupStore.addUser(GeoServerUser.createDefaultAdmin());
            GeoServerRole localAdminRole = roleStore.createRoleObject(XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
            roleStore.addRole(localAdminRole);
            roleStore.associateRoleToUser(localAdminRole, "admin");
        }
        if (roleStore.getRoleByName(XMLRoleService.DEFAULT_LOCAL_GROUP_ADMIN_ROLE) == null) {
            roleStore.addRole(roleStore.createRoleObject(XMLRoleService.DEFAULT_LOCAL_GROUP_ADMIN_ROLE));
        }
        for (String string : new String[]{"services.properties", "layers.properties", "rest.properties"}) {
            String line;
            File file = new File(this.getSecurityRoot(), string);
            if (!file.exists()) continue;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                lines.add(line.replace(GeoServerRole.ADMIN_ROLE.getAuthority(), XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE));
            }
            reader.close();
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            for (String s : lines) {
                writer.println(s);
            }
            writer.close();
        }
        serviceFile = new File(this.getSecurityRoot(), "services.properties");
        if (serviceFile.exists()) {
            props = Util.loadPropertyFile(serviceFile);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)entry.getValue(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String roleName = stringTokenizer.nextToken().trim();
                    if (roleName.length() <= 0 || roleStore.getRoleByName(roleName) != null) continue;
                    roleStore.addRole(roleStore.createRoleObject(roleName));
                }
            }
        }
        if ((dataFile = new File(this.getSecurityRoot(), "layers.properties")).exists()) {
            Properties props2 = Util.loadPropertyFile(dataFile);
            for (Map.Entry<Object, Object> entry : props2.entrySet()) {
                if ("mode".equals(entry.getKey().toString())) continue;
                StringTokenizer tokenizer = new StringTokenizer((String)entry.getValue(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String roleName = tokenizer.nextToken().trim();
                    if (roleName.length() <= 0 || roleName.equals("*") || roleStore.getRoleByName(roleName) != null) continue;
                    roleStore.addRole(roleStore.createRoleObject(roleName));
                }
            }
        }
        roleStore.store();
        userGroupStore.store();
        if (usersFile.exists()) {
            File oldUserFile = new File(usersFile.getCanonicalPath() + ".old");
            usersFile.renameTo(oldUserFile);
            LOGGER.info("Renamed " + usersFile.getCanonicalPath() + " to " + oldUserFile.getCanonicalPath());
        }
        LOGGER.info("End security migration");
        return true;
    }

    boolean migrateFrom22(boolean migratedFrom21) throws Exception {
        String filterName = "roleFilter";
        GeoServerSecurityFilter filter = this.loadFilter(filterName);
        File logoutFilterDir = new File(this.getFilterRoot(), "formLogout");
        File oldLogoutFilterConfig = new File(logoutFilterDir, "config.xml.2.2.x");
        File oldSecManagerConfig = new File(this.getSecurityRoot(), "config.xml.2.2.x");
        if (filter != null) {
            if (oldLogoutFilterConfig.exists()) {
                LOGGER.warning(oldLogoutFilterConfig.getCanonicalPath() + " could be removed manually");
            }
            if (oldSecManagerConfig.exists()) {
                LOGGER.warning(oldSecManagerConfig.getCanonicalPath() + " could be removed manually");
            }
            return false;
        }
        RoleFilterConfig rfConfig = new RoleFilterConfig();
        rfConfig.setClassName(GeoServerRoleFilter.class.getName());
        rfConfig.setName(filterName);
        rfConfig.setHttpResponseHeaderAttrForIncludedRoles(GeoServerRoleFilter.DEFAULT_HEADER_ATTRIBUTE);
        rfConfig.setRoleConverterName(GeoServerRoleFilter.DEFAULT_ROLE_CONVERTER);
        this.saveFilter(rfConfig);
        SSLFilterConfig sslConfig = new SSLFilterConfig();
        sslConfig.setClassName(GeoServerSSLFilter.class.getName());
        sslConfig.setName("sslFilter");
        sslConfig.setSslPort(443);
        this.saveFilter(sslConfig);
        if (!migratedFrom21) {
            FileUtils.copyFile((File)new File(logoutFilterDir, CONFIG_FILENAME), (File)oldLogoutFilterConfig);
        }
        LogoutFilterConfig loConfig = (LogoutFilterConfig)this.loadFilterConfig("formLogout");
        loConfig.setRedirectURL("/web/");
        this.saveFilter(loConfig);
        if (!migratedFrom21) {
            FileUtils.copyFile((File)new File(this.getSecurityRoot(), CONFIG_FILENAME), (File)oldSecManagerConfig);
        }
        SecurityManagerConfig config = this.loadSecurityConfig();
        for (RequestFilterChain chain : config.getFilterChain().getRequestChains()) {
            if (chain.getFilterNames().contains("contextAsc")) {
                chain.setAllowSessionCreation(true);
                chain.getFilterNames().remove("contextAsc");
            }
            if (chain.getFilterNames().contains("contextNoAsc")) {
                chain.setAllowSessionCreation(false);
                chain.getFilterNames().remove("contextNoAsc");
            }
            if ("web".equals(chain.getName())) {
                int index = chain.getFilterNames().indexOf("guiException");
                if (index != -1) {
                    chain.getFilterNames().set(index, "exception");
                }
                if (chain.getFilterNames().indexOf("form") == -1) {
                    index = chain.getFilterNames().indexOf("anonymous");
                    if (index == -1) {
                        index = chain.getFilterNames().indexOf("interceptor");
                    }
                    if (index != -1) {
                        chain.getFilterNames().add(index, "form");
                    }
                }
            }
            chain.getFilterNames().remove("exception");
            chain.getFilterNames().remove("interceptor");
            chain.getFilterNames().remove("restInterceptor");
        }
        this.removeFilter(this.loadFilterConfig("guiException"));
        this.saveSecurityConfig(config);
        if (!migratedFrom21) {
            for (String fName : this.listFilters()) {
                SecurityFilterConfig fConfig = this.loadFilterConfig(fName);
                if (fConfig == null) continue;
                this.saveFilter(fConfig);
            }
        }
        return true;
    }

    boolean migrateFrom23() throws Exception {
        SecurityManagerConfig config = this.loadSecurityConfig();
        RequestFilterChain webChain = config.getFilterChain().getRequestChainByName("web");
        boolean migrated = false;
        List<String> patterns = webChain.getPatterns();
        if (!patterns.contains("/")) {
            patterns.add("/");
            this.saveSecurityConfig(config);
            migrated |= true;
        }
        return migrated;
    }

    void removeErroneousAccessDeniedPage() throws Exception {
        ExceptionTranslationFilterConfig config = (ExceptionTranslationFilterConfig)this.loadFilterConfig("exception");
        if (config != null && "/accessDenied.jsp".equals(config.getAccessDeniedErrorPage())) {
            config.setAccessDeniedErrorPage(null);
            this.saveFilter(config);
        }
        if ((config = (ExceptionTranslationFilterConfig)this.loadFilterConfig("guiException")) != null && "/accessDenied.jsp".equals(config.getAccessDeniedErrorPage())) {
            config.setAccessDeniedErrorPage(null);
            this.saveFilter(config);
        }
    }

    public List<GeoServerSecurityProvider> lookupSecurityProviders() {
        ArrayList<GeoServerSecurityProvider> list2 = new ArrayList<GeoServerSecurityProvider>();
        for (GeoServerSecurityProvider provider : GeoServerExtensions.extensions(GeoServerSecurityProvider.class, (ApplicationContext)this.appContext)) {
            if (!provider.isAvailable()) continue;
            list2.add(provider);
        }
        return list2;
    }

    SortedSet<String> listFiles(File dir) {
        File[] dirs;
        TreeSet<String> result = new TreeSet<String>();
        for (File d : dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && new File(pathname, GeoServerSecurityManager.CONFIG_FILENAME).exists();
            }
        })) {
            result.add(d.getName());
        }
        return result;
    }

    XStreamPersister globalPersister() throws IOException {
        if (this.gxp == null) {
            this.gxp = this.buildGlobalPersister();
        }
        return this.gxp;
    }

    private XStreamPersister buildGlobalPersister() {
        XStreamPersister xp = this.buildPersister();
        xp.getXStream().alias("security", SecurityManagerConfig.class);
        xp.getXStream().alias("masterPassword", MasterPasswordConfig.class);
        xp.getXStream().registerLocalConverter(SecurityManagerConfig.class, "filterChain", (Converter)new FilterChainConverter(xp.getXStream().getMapper()));
        xp.getXStream().omitField(SecurityManagerConfig.class, "anonymousAuth");
        return xp;
    }

    XStreamPersister persister() throws IOException {
        if (this.xp == null) {
            this.xp = this.buildPersister();
        }
        return this.xp;
    }

    private XStreamPersister buildPersister() {
        List<GeoServerSecurityProvider> all = this.lookupSecurityProviders();
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        xp.getXStream().alias("security", SecurityManagerConfig.class);
        for (GeoServerSecurityProvider roleService : all) {
            roleService.configure(xp);
        }
        return xp;
    }

    public SecurityManagerConfig loadSecurityConfig() throws IOException {
        return (SecurityManagerConfig)this.loadConfigFile(this.getSecurityRoot(), this.globalPersister());
    }

    public MasterPasswordConfig loadMasterPasswordConfig() throws IOException {
        Resource resource = this.security().get(MASTER_PASSWD_CONFIG_FILENAME);
        return this.loadConfig(MasterPasswordConfig.class, resource, this.globalPersister());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends SecurityConfig> T loadConfig(Class<T> config, Resource resource, XStreamPersister xp) throws IOException {
        try (InputStream in = resource.in();){
            SecurityConfig loaded = xp.load(in, SecurityConfig.class);
            SecurityConfig securityConfig = (SecurityConfig)config.cast(loaded);
            return (T)securityConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityConfig loadConfigFile(File directory, String filename, XStreamPersister xp) throws IOException {
        try (FileInputStream fin = new FileInputStream(new File(directory, filename));){
            SecurityConfig securityConfig = xp.load(fin, SecurityConfig.class);
            return securityConfig;
        }
    }

    SecurityConfig loadConfigFile(File directory, XStreamPersister xp) throws IOException {
        return this.loadConfigFile(directory, CONFIG_FILENAME, xp);
    }

    void saveConfigFile(SecurityConfig config, File directory, String filename, XStreamPersister xp) throws IOException {
        IOUtils.xStreamPersist(new File(directory, filename), (Object)config, xp);
    }

    void saveConfigFile(SecurityConfig config, File directory, XStreamPersister xp) throws IOException {
        this.saveConfigFile(config, directory, CONFIG_FILENAME, xp);
    }

    Resource getConfigFile(String configFileLocation) throws IOException {
        File file = new File(configFileLocation);
        if (file.isAbsolute()) {
            if (file.canRead()) {
                return Files.asResource((File)file);
            }
            throw new IOException("Cannot read file: " + file.getCanonicalPath());
        }
        return null;
    }

    public GeoServerRoleService getActiveRoleService() {
        try {
            return this.wrapRoleService(this.activeRoleService);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setActiveRoleService(GeoServerRoleService activeRoleService) {
        this.activeRoleService = activeRoleService;
    }

    public void updateConfigurationFilesWithEncryptedFields() throws IOException {
        PasswordPolicyConfig config;
        LOGGER.info("Start encrypting configuration passwords using " + this.getSecurityConfig().getConfigPasswordEncrypterName());
        Catalog catalog = this.getCatalog();
        List<StoreInfo> stores = catalog.getStores(StoreInfo.class);
        for (StoreInfo info : stores) {
            if (this.configPasswordEncryptionHelper.getEncryptedFields(info).isEmpty()) continue;
            catalog.save(info);
        }
        HashSet configClasses = new HashSet();
        for (GeoServerSecurityProvider prov : this.lookupSecurityProviders()) {
            configClasses.addAll(prov.getFieldsForEncryption().keySet());
        }
        block2: for (String name : this.listPasswordValidators()) {
            config = (PasswordPolicyConfig)this.passwordValidatorHelper.loadConfig(name);
            for (Class clazz : configClasses) {
                if (!config.getClass().isAssignableFrom(clazz)) continue;
                this.passwordValidatorHelper.saveConfig(config);
                continue block2;
            }
        }
        block4: for (String name : this.listRoleServices()) {
            config = this.roleServiceHelper.loadConfig(name);
            for (Class clazz : configClasses) {
                if (!config.getClass().isAssignableFrom(clazz)) continue;
                this.roleServiceHelper.saveConfig(config);
                continue block4;
            }
        }
        block6: for (String name : this.listUserGroupServices()) {
            config = this.userGroupServiceHelper.loadConfig(name);
            for (Class clazz : configClasses) {
                if (!config.getClass().isAssignableFrom(clazz)) continue;
                this.userGroupServiceHelper.saveConfig(config);
                continue block6;
            }
        }
        block8: for (String name : this.listAuthenticationProviders()) {
            config = this.authProviderHelper.loadConfig(name);
            for (Class clazz : configClasses) {
                if (!config.getClass().isAssignableFrom(clazz)) continue;
                this.authProviderHelper.saveConfig(config);
                continue block8;
            }
        }
        block10: for (String name : this.listFilters()) {
            config = this.filterHelper.loadConfig(name);
            for (Class clazz : configClasses) {
                if (!config.getClass().isAssignableFrom(clazz)) continue;
                this.filterHelper.saveConfig(config);
                continue block10;
            }
        }
        LOGGER.info("End encrypting configuration passwords");
    }

    public SortedSet<GeoServerRole> getRolesForAccessControl() throws IOException {
        TreeSet<GeoServerRole> allRoles = new TreeSet<GeoServerRole>();
        for (String serviceName : this.listRoleServices()) {
            try {
                allRoles.addAll(this.loadRoleService(serviceName).getRoles());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        allRoles.add(GeoServerRole.AUTHENTICATED_ROLE);
        allRoles.add(GeoServerRole.ANONYMOUS_ROLE);
        return allRoles;
    }

    class FilterChainConverter
    extends AbstractCollectionConverter {
        public FilterChainConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return GeoServerSecurityFilterChain.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GeoServerSecurityFilterChain filterChain = (GeoServerSecurityFilterChain)source;
            for (RequestFilterChain requestChain : filterChain.getRequestChains()) {
                writer.startNode("filters");
                StringBuilder sb = new StringBuilder();
                for (String s : requestChain.getPatterns()) {
                    sb.append(s).append(",");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                if (requestChain.getName() != null) {
                    writer.addAttribute("name", requestChain.getName());
                }
                writer.addAttribute("class", requestChain.getClass().getName());
                if (StringUtils.hasLength((String)requestChain.getRoleFilterName())) {
                    writer.addAttribute("roleFilterName", requestChain.getRoleFilterName());
                }
                if (requestChain instanceof VariableFilterChain) {
                    if (StringUtils.hasLength((String)((VariableFilterChain)requestChain).getInterceptorName())) {
                        writer.addAttribute("interceptorName", ((VariableFilterChain)requestChain).getInterceptorName());
                    }
                    if (StringUtils.hasLength((String)((VariableFilterChain)requestChain).getExceptionTranslationName())) {
                        writer.addAttribute("exceptionTranslationName", ((VariableFilterChain)requestChain).getExceptionTranslationName());
                    }
                }
                writer.addAttribute("path", sb.toString());
                writer.addAttribute("disabled", Boolean.toString(requestChain.isDisabled()));
                writer.addAttribute("allowSessionCreation", Boolean.toString(requestChain.isAllowSessionCreation()));
                writer.addAttribute("ssl", Boolean.toString(requestChain.isRequireSSL()));
                writer.addAttribute("matchHTTPMethod", Boolean.toString(requestChain.isMatchHTTPMethod()));
                if (requestChain.getHttpMethods() != null && requestChain.getHttpMethods().size() > 0) {
                    writer.addAttribute("httpMethods", StringUtils.collectionToCommaDelimitedString(requestChain.getHttpMethods()));
                }
                for (String filterName : requestChain.getFilterNames()) {
                    writer.startNode("filter");
                    writer.setValue(filterName);
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            GeoServerSecurityFilterChain filterChain = new GeoServerSecurityFilterChain();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String path = reader.getAttribute("path");
                String name = reader.getAttribute("name");
                String classname = reader.getAttribute("class");
                String roleFilterName = reader.getAttribute("roleFilterName");
                String disabledString = reader.getAttribute("disabled");
                String allowSessionCreationString = reader.getAttribute("allowSessionCreation");
                String interceptorName = reader.getAttribute("interceptorName");
                String exceptionTranslationName = reader.getAttribute("exceptionTranslationName");
                String sslString = reader.getAttribute("ssl");
                String matchHTTPMethodString = reader.getAttribute("matchHTTPMethod");
                String httpMethodsString = reader.getAttribute("httpMethods");
                if (name == null) {
                    RequestFilterChain requestChain = GeoServerSecurityFilterChain.lookupRequestChainByPattern(path, GeoServerSecurityManager.this);
                    name = requestChain != null ? requestChain.getName() : path;
                }
                if (classname == null) {
                    if ("web".equals(name)) {
                        classname = HtmlLoginFilterChain.class.getName();
                        allowSessionCreationString = "true";
                        interceptorName = "interceptor";
                    }
                    if ("webLogin".equals(name)) {
                        classname = ConstantFilterChain.class.getName();
                        allowSessionCreationString = "true";
                        interceptorName = "interceptor";
                    }
                    if ("webLogout".equals(name)) {
                        classname = LogoutFilterChain.class.getName();
                        allowSessionCreationString = "true";
                        interceptorName = "interceptor";
                    }
                    if ("rest".equals(name)) {
                        classname = ServiceLoginFilterChain.class.getName();
                        allowSessionCreationString = "false";
                        interceptorName = "restInterceptor";
                    }
                    if ("gwc".equals(name)) {
                        classname = ServiceLoginFilterChain.class.getName();
                        allowSessionCreationString = "false";
                        interceptorName = "restInterceptor";
                    }
                    if ("default".equals(name)) {
                        classname = ServiceLoginFilterChain.class.getName();
                        allowSessionCreationString = "false";
                        interceptorName = "interceptor";
                    }
                }
                ArrayList<String> filterNames = new ArrayList<String>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    filterNames.add(reader.getValue());
                    reader.moveUp();
                }
                RequestFilterChain requestChain = null;
                try {
                    Class<?> chainClass = Class.forName(classname);
                    Constructor<?> cons = chainClass.getConstructor(String[].class);
                    String[] args = path.split(",");
                    requestChain = (RequestFilterChain)cons.newInstance(new Object[]{args});
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                requestChain.setName(name);
                if (StringUtils.hasLength((String)disabledString)) {
                    requestChain.setDisabled(Boolean.parseBoolean(disabledString));
                }
                if (StringUtils.hasLength((String)allowSessionCreationString)) {
                    requestChain.setAllowSessionCreation(Boolean.parseBoolean(allowSessionCreationString));
                }
                if (StringUtils.hasLength((String)sslString)) {
                    requestChain.setRequireSSL(Boolean.parseBoolean(sslString));
                }
                if (StringUtils.hasLength((String)matchHTTPMethodString)) {
                    requestChain.setMatchHTTPMethod(Boolean.parseBoolean(matchHTTPMethodString));
                }
                if (StringUtils.hasLength((String)httpMethodsString)) {
                    for (String method : httpMethodsString.split(",")) {
                        requestChain.getHttpMethods().add(HTTPMethod.fromString(method));
                    }
                }
                requestChain.setRoleFilterName(roleFilterName);
                if (requestChain instanceof VariableFilterChain) {
                    ((VariableFilterChain)requestChain).setInterceptorName(interceptorName);
                    if (StringUtils.hasLength((String)exceptionTranslationName)) {
                        ((VariableFilterChain)requestChain).setExceptionTranslationName(exceptionTranslationName);
                    } else {
                        ((VariableFilterChain)requestChain).setExceptionTranslationName("exception");
                    }
                }
                requestChain.setFilterNames(filterNames);
                filterChain.getRequestChains().add(requestChain);
                reader.moveUp();
            }
            return filterChain;
        }
    }

    class FilterHelper
    extends HelperBase<GeoServerSecurityFilter, SecurityFilterConfig> {
        FilterHelper() {
        }

        @Override
        public GeoServerSecurityFilter load(String name) throws IOException {
            Object config = this.loadConfig(name);
            if (config == null) {
                return null;
            }
            AbstractGeoServerSecurityService filter = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getFilterClass() == null || !p.getFilterClass().getName().equals(config.getClassName())) continue;
                filter = p.createFilter((SecurityNamedServiceConfig)config);
                break;
            }
            if (filter == null) {
                throw new IOException("No authentication provider matching config: " + config);
            }
            filter.setName(name);
            filter.setSecurityManager(GeoServerSecurityManager.this);
            filter.initializeFromConfig((SecurityNamedServiceConfig)config);
            return filter;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getFilterRoot();
        }
    }

    class AuthProviderHelper
    extends HelperBase<GeoServerAuthenticationProvider, SecurityAuthProviderConfig> {
        AuthProviderHelper() {
        }

        @Override
        public GeoServerAuthenticationProvider load(String name) throws IOException {
            Object config = this.loadConfig(name);
            if (config == null) {
                return null;
            }
            AbstractGeoServerSecurityService authProvider = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getAuthenticationProviderClass() == null || !p.getAuthenticationProviderClass().getName().equals(config.getClassName())) continue;
                authProvider = p.createAuthenticationProvider((SecurityNamedServiceConfig)config);
                break;
            }
            if (authProvider == null) {
                throw new IOException("No authentication provider matching config: " + config);
            }
            authProvider.setName(name);
            authProvider.setSecurityManager(GeoServerSecurityManager.this);
            authProvider.initializeFromConfig((SecurityNamedServiceConfig)config);
            return authProvider;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getAuthRoot();
        }
    }

    static interface MigrationHelper {
        public void migrationPersister(XStreamPersister var1);
    }

    class MasterPasswordProviderHelper
    extends HelperBase<MasterPasswordProvider, MasterPasswordProviderConfig> {
        MasterPasswordProviderHelper() {
        }

        @Override
        public MasterPasswordProvider load(String name) throws IOException {
            MasterPasswordProviderConfig config = (MasterPasswordProviderConfig)this.loadConfig(name);
            if (config == null) {
                return null;
            }
            Object provider = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getMasterPasswordProviderClass() == null || !p.getMasterPasswordProviderClass().getName().equals(config.getClassName())) continue;
                provider = p.createMasterPasswordProvider(config);
                break;
            }
            if (provider == null) {
                throw new IOException("No master password provider matching config: " + config);
            }
            if (!Modifier.isFinal(provider.getClass().getModifiers())) {
                throw new RuntimeException("Master password provider class: " + provider.getClass().getCanonicalName() + " is not final");
            }
            ((AbstractGeoServerSecurityService)provider).setName(config.getName());
            ((AbstractGeoServerSecurityService)provider).setSecurityManager(GeoServerSecurityManager.this);
            ((AbstractGeoServerSecurityService)provider).initializeFromConfig(config);
            return provider;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getMasterPasswordProviderRoot();
        }
    }

    class PasswordValidatorHelper
    extends HelperBase<PasswordValidator, PasswordPolicyConfig> {
        PasswordValidatorHelper() {
        }

        @Override
        public PasswordValidator load(String name) throws IOException {
            PasswordPolicyConfig config = (PasswordPolicyConfig)this.loadConfig(name);
            if (config == null) {
                return null;
            }
            PasswordValidator validator = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getPasswordValidatorClass() == null || !p.getPasswordValidatorClass().getName().equals(config.getClassName())) continue;
                validator = p.createPasswordValidator(config, GeoServerSecurityManager.this);
                break;
            }
            if (validator == null) {
                throw new IOException("No password policy matching config: " + config);
            }
            validator.setConfig(config);
            return validator;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getPasswordPolicyRoot();
        }
    }

    class RoleServiceHelper
    extends HelperBase<GeoServerRoleService, SecurityRoleServiceConfig> {
        RoleServiceHelper() {
        }

        @Override
        public GeoServerRoleService load(String name) throws IOException {
            FileBasedSecurityServiceConfig fileConfig;
            boolean needsLockProtection;
            Object config = this.loadConfig(name);
            if (config == null) {
                return null;
            }
            GeoServerSecurityService service = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getRoleServiceClass() == null || !p.getRoleServiceClass().getName().equals(config.getClassName())) continue;
                service = p.createRoleService((SecurityNamedServiceConfig)config);
                break;
            }
            if (service == null) {
                throw new IOException("No authority service matching config: " + config);
            }
            service.setSecurityManager(GeoServerSecurityManager.this);
            if (config instanceof SecurityRoleServiceConfig && (needsLockProtection = GeoServerSecurityProvider.getProvider(GeoServerRoleService.class, config.getClassName()).roleServiceNeedsLockProtection())) {
                service = new LockingRoleService((GeoServerRoleService)service);
            }
            service.setName(name);
            service.initializeFromConfig((SecurityNamedServiceConfig)config);
            if (config instanceof FileBasedSecurityServiceConfig && (fileConfig = (FileBasedSecurityServiceConfig)config).getCheckInterval() > 0L) {
                Resource resource = GeoServerSecurityManager.this.getConfigFile(fileConfig.getFileName());
                if (resource == null) {
                    String path = Paths.path((String[])new String[]{"security/role", name, fileConfig.getFileName()});
                    resource = GeoServerSecurityManager.this.get(path);
                }
                RoleFileWatcher watcher = new RoleFileWatcher(resource, (GeoServerRoleService)service, resource.lastmodified());
                service.registerRoleLoadedListener(watcher);
                watcher.start();
                this.fileWatchers.add(watcher);
            }
            return service;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getRoleRoot();
        }
    }

    class UserGroupServiceHelper
    extends HelperBase<GeoServerUserGroupService, SecurityUserGroupServiceConfig> {
        UserGroupServiceHelper() {
        }

        @Override
        public GeoServerUserGroupService load(String name) throws IOException {
            FileBasedSecurityServiceConfig fileConfig;
            boolean needsLockProtection;
            Object config = this.loadConfig(name);
            if (config == null) {
                return null;
            }
            GeoServerSecurityService service = null;
            for (GeoServerSecurityProvider p : GeoServerSecurityManager.this.lookupSecurityProviders()) {
                if (p.getUserGroupServiceClass() == null || !p.getUserGroupServiceClass().getName().equals(config.getClassName())) continue;
                service = p.createUserGroupService((SecurityNamedServiceConfig)config);
                break;
            }
            if (service == null) {
                throw new IOException("No user group service matching config: " + config);
            }
            service.setSecurityManager(GeoServerSecurityManager.this);
            if (config instanceof SecurityUserGroupServiceConfig && (needsLockProtection = GeoServerSecurityProvider.getProvider(GeoServerUserGroupService.class, config.getClassName()).roleServiceNeedsLockProtection())) {
                service = new LockingUserGroupService((GeoServerUserGroupService)service);
            }
            service.setName(name);
            service.initializeFromConfig((SecurityNamedServiceConfig)config);
            if (config instanceof FileBasedSecurityServiceConfig && (fileConfig = (FileBasedSecurityServiceConfig)config).getCheckInterval() > 0L) {
                Resource resource = GeoServerSecurityManager.this.getConfigFile(fileConfig.getFileName());
                if (resource == null) {
                    String path = Paths.path((String[])new String[]{"security/usergroup", name, fileConfig.getFileName()});
                    resource = GeoServerSecurityManager.this.get(path);
                }
                UserGroupFileWatcher watcher = new UserGroupFileWatcher(resource, (GeoServerUserGroupService)service);
                service.registerUserGroupLoadedListener(watcher);
                watcher.start();
                this.fileWatchers.add(watcher);
            }
            return service;
        }

        @Override
        protected File getRoot() throws IOException {
            return GeoServerSecurityManager.this.getUserGroupRoot();
        }
    }

    abstract class HelperBase<T, C extends SecurityNamedServiceConfig> {
        protected List<FileWatcher> fileWatchers = new ArrayList<FileWatcher>();

        HelperBase() {
        }

        public abstract T load(String var1) throws IOException;

        public C loadConfig(String name, MigrationHelper migrationHelper) throws IOException {
            File dir = new File(this.getRoot(), name);
            if (!dir.exists()) {
                return null;
            }
            XStreamPersister xp = GeoServerSecurityManager.this.persister();
            if (migrationHelper != null) {
                migrationHelper.migrationPersister(xp);
            }
            return (C)((SecurityNamedServiceConfig)GeoServerSecurityManager.this.loadConfigFile(dir, xp));
        }

        public C loadConfig(String name) throws IOException {
            return this.loadConfig(name, null);
        }

        public void saveConfig(SecurityNamedServiceConfig config) throws IOException {
            boolean isNew;
            File dir = new File(this.getRoot(), config.getName());
            dir.mkdir();
            boolean bl = isNew = config.getId() == null;
            if (isNew) {
                config.setId(this.newId());
            }
            try {
                GeoServerSecurityManager.this.saveConfigFile(config, dir, GeoServerSecurityManager.this.persister());
            }
            catch (Exception e) {
                if (isNew) {
                    config.setId(null);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }

        String newId() {
            return new UID().toString();
        }

        public void removeConfig(String name) throws IOException {
            FileUtils.deleteDirectory((File)new File(this.getRoot(), name));
        }

        public void destroy() {
            for (FileWatcher fw : this.fileWatchers) {
                fw.setTerminate(true);
            }
        }

        protected abstract File getRoot() throws IOException;
    }
}

