/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AbstractCatalogFilter;
import org.opengis.filter.Filter;

public class DisabledResourceFilter
extends AbstractCatalogFilter {
    static final Filter ENABLED_FILTER = Predicates.equal("enabled", true);

    private boolean shouldApplyFilter() {
        Request request = (Request)Dispatcher.REQUEST.get();
        return request != null && request.getService() != null && request.getRequest() != null;
    }

    @Override
    public Filter getSecurityFilter(Class<? extends CatalogInfo> clazz) {
        if (this.shouldApplyFilter() && LayerInfo.class.isAssignableFrom(clazz) || ResourceInfo.class.isAssignableFrom(clazz)) {
            return ENABLED_FILTER;
        }
        return Filter.INCLUDE;
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        if (this.shouldApplyFilter()) {
            return !layer.isEnabled();
        }
        return false;
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (this.shouldApplyFilter()) {
            return !resource.isEnabled();
        }
        return false;
    }
}

