/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AbstractResourceAccessManager;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public class DataAccessManagerAdapter
extends AbstractResourceAccessManager {
    static final Logger LOGGER = Logging.getLogger(DataAccessManagerAdapter.class);
    DataAccessManager delegate;

    public DataAccessManagerAdapter(DataAccessManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        boolean read = this.delegate.canAccess(user, layer, AccessMode.READ);
        boolean write = this.delegate.canAccess(user, layer, AccessMode.WRITE);
        Filter readFilter = (Filter)(read ? Filter.INCLUDE : Filter.EXCLUDE);
        Filter writeFilter = (Filter)(write ? Filter.INCLUDE : Filter.EXCLUDE);
        return this.buildLimits(layer.getResource().getClass(), readFilter, writeFilter);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        boolean read = this.delegate.canAccess(user, resource, AccessMode.READ);
        boolean write = this.delegate.canAccess(user, resource, AccessMode.WRITE);
        Filter readFilter = (Filter)(read ? Filter.INCLUDE : Filter.EXCLUDE);
        Filter writeFilter = (Filter)(write ? Filter.INCLUDE : Filter.EXCLUDE);
        return this.buildLimits(resource.getClass(), readFilter, writeFilter);
    }

    DataAccessLimits buildLimits(Class<? extends ResourceInfo> resourceClass, Filter readFilter, Filter writeFilter) {
        CatalogMode mode = this.delegate.getMode();
        if ((readFilter == null || readFilter == Filter.INCLUDE) && (writeFilter == null || writeFilter == Filter.INCLUDE || WMSLayerInfo.class.isAssignableFrom(resourceClass) || CoverageInfo.class.isAssignableFrom(resourceClass))) {
            return null;
        }
        if (FeatureTypeInfo.class.isAssignableFrom(resourceClass)) {
            return new VectorAccessLimits(mode, null, readFilter, null, writeFilter);
        }
        if (CoverageInfo.class.isAssignableFrom(resourceClass)) {
            return new CoverageAccessLimits(mode, readFilter, null, null);
        }
        if (WMSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMSAccessLimits(mode, readFilter, null, true);
        }
        LOGGER.log(Level.INFO, "Warning, adapting to generic access limits for unrecognized resource type " + resourceClass);
        return new DataAccessLimits(mode, readFilter);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        boolean readable = this.delegate.canAccess(user, workspace, AccessMode.READ);
        boolean writable = this.delegate.canAccess(user, workspace, AccessMode.WRITE);
        boolean adminable = this.delegate.canAccess(user, workspace, AccessMode.ADMIN);
        CatalogMode mode = this.delegate.getMode();
        if (readable && writable && AdminRequest.get() == null) {
            return null;
        }
        return new WorkspaceAccessLimits(mode, readable, writable, adminable);
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        if (this.delegate.getMode() == CatalogMode.CHALLENGE) {
            return Predicates.acceptAll();
        }
        return super.getSecurityFilter(user, clazz);
    }
}

