/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.ows.LocalLayer;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.security.AbstractCatalogFilter;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class LocalWorkspaceCatalogFilter
extends AbstractCatalogFilter {
    Catalog catalog;

    public LocalWorkspaceCatalogFilter(Catalog catalog) {
        Catalog unwrapped;
        while (catalog instanceof Wrapper && ((Wrapper)((Object)catalog)).isWrapperFor(Catalog.class) && (unwrapped = ((Wrapper)((Object)catalog)).unwrap(Catalog.class)) != catalog && unwrapped != null) {
            catalog = unwrapped;
        }
        this.catalog = catalog;
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        return LocalLayer.get() != null && !LocalLayer.get().equals(layer);
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (LocalLayer.get() != null) {
            for (LayerInfo l : resource.getCatalog().getLayers(resource)) {
                if (l.equals(LocalLayer.get())) continue;
                return true;
            }
        }
        return this.hideWorkspace(resource.getStore().getWorkspace());
    }

    @Override
    public boolean hideWorkspace(WorkspaceInfo workspace) {
        return LocalWorkspace.get() != null && !LocalWorkspace.get().equals(workspace);
    }

    @Override
    public boolean hideStyle(StyleInfo style) {
        if (style.getWorkspace() == null) {
            return LocalWorkspace.get() != null && this.catalog.getStyleByName(LocalWorkspace.get(), style.getName()) != null;
        }
        return this.hideWorkspace(style.getWorkspace());
    }

    @Override
    public boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        if (layerGroup.getWorkspace() == null) {
            return LocalWorkspace.get() != null && this.catalog.getLayerGroupByName(LocalWorkspace.get(), layerGroup.getName()) != null;
        }
        return this.hideWorkspace(layerGroup.getWorkspace());
    }

    protected boolean subLayersHidden(LayerGroupInfo layerGroup) {
        boolean anySublayersVisible = false;
        for (PublishedInfo subLayer : layerGroup.getLayers()) {
            if (subLayer instanceof LayerInfo) {
                if (this.hideLayer((LayerInfo)subLayer)) continue;
                anySublayersVisible = true;
                break;
            }
            if (!(subLayer instanceof LayerGroupInfo) || this.hideLayerGroup((LayerGroupInfo)subLayer)) continue;
            anySublayersVisible = true;
            break;
        }
        return !anySublayersVisible;
    }

    private Filter inWorkspace() {
        WorkspaceInfo localWS = LocalWorkspace.get();
        if (localWS == null) {
            return Predicates.acceptAll();
        }
        return Predicates.equal("workspace.id", localWS.getId());
    }

    private Filter standardFilter(Class<? extends CatalogInfo> clazz) {
        Filter forGlobal = LocalWorkspace.get() != null ? super.getSecurityFilter(clazz) : Predicates.acceptAll();
        return Predicates.or(Predicates.and(Predicates.isNull("workspace.id"), forGlobal), Predicates.and((Filter)Predicates.factory.not(Predicates.isNull("workspace.id")), this.inWorkspace()));
    }

    @Override
    public Filter getSecurityFilter(Class<? extends CatalogInfo> clazz) {
        WorkspaceInfo localWS = LocalWorkspace.get();
        LayerInfo localLayer = LocalLayer.get();
        if (localWS == null && localLayer == null) {
            return Predicates.acceptAll();
        }
        if (ResourceInfo.class.isAssignableFrom(clazz)) {
            if (localLayer != null) {
                return super.getSecurityFilter(clazz);
            }
            Filter localLayerFilter = Predicates.acceptAll();
            return Predicates.or(localLayerFilter, this.inWorkspace());
        }
        if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            if (localWS == null) {
                return Predicates.acceptAll();
            }
            return Predicates.equal("id", localWS.getId());
        }
        if (LayerGroupInfo.class.isAssignableFrom(clazz)) {
            Filter filter = this.standardFilter(clazz);
            InternalVolatileFunction subLayersHidden = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !LocalWorkspaceCatalogFilter.this.subLayersHidden((LayerGroupInfo)object);
                }
            };
            FilterFactory factory = Predicates.factory;
            filter = Predicates.and(filter, (Filter)factory.equals((Expression)factory.literal((Object)Boolean.TRUE), (Expression)subLayersHidden));
            if (localLayer != null) {
                filter = Predicates.and(filter, Predicates.equal("id", localLayer.getId()));
            }
            return filter;
        }
        if (StyleInfo.class.isAssignableFrom(clazz)) {
            return this.standardFilter(clazz);
        }
        if (LayerInfo.class.isAssignableFrom(clazz)) {
            if (localLayer == null) {
                return Predicates.acceptAll();
            }
            return Predicates.equal("id", localLayer.getId());
        }
        if (NamespaceInfo.class.isAssignableFrom(clazz)) {
            return super.getSecurityFilter(clazz);
        }
        return super.getSecurityFilter(clazz);
    }
}

