/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.jai.JAI;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class ConcurrentOperationRegistry
extends OperationRegistry {
    static String JAI_REGISTRY_FILE = "META-INF/javax.media.jai.registryFile.jai";
    static String USR_REGISTRY_FILE = "META-INF/registryFile.jai";
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public static OperationRegistry initializeRegistry() {
        try {
            InputStream url = PropertyUtil.getFileFromClasspath((String)JAI_REGISTRY_FILE);
            if (url == null) {
                throw new RuntimeException("Could not find the main registry file");
            }
            ConcurrentOperationRegistry registry = new ConcurrentOperationRegistry();
            if (url != null) {
                registry.updateFromStream(url);
            }
            registry.registerServices(null);
            return registry;
        }
        catch (IOException ioe) {
            ImagingListener listener = JAI.getDefaultInstance().getImagingListener();
            String message = "Error occurred while initializing JAI";
            listener.errorOccurred(message, (Throwable)new ImagingException(message, (Throwable)ioe), OperationRegistry.class, false);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String string = super.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream out) throws IOException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            super.writeToStream(out);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFromStream(InputStream in) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.initializeFromStream(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromStream(InputStream in) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.updateFromStream(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.readExternal(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            super.writeExternal(out);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryMode(String modeName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.removeRegistryMode(modeName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRegistryModes() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getRegistryModes();
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDescriptor(RegistryElementDescriptor descriptor) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.registerDescriptor(descriptor);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDescriptor(RegistryElementDescriptor descriptor) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unregisterDescriptor(descriptor);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryElementDescriptor getDescriptor(Class descriptorClass, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(descriptorClass, descriptorName);
            return registryElementDescriptor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescriptors(Class descriptorClass) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list2 = super.getDescriptors(descriptorClass);
            return list2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDescriptorNames(Class descriptorClass) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getDescriptorNames(descriptorClass);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryElementDescriptor getDescriptor(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(modeName, descriptorName);
            return registryElementDescriptor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescriptors(String modeName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list2 = super.getDescriptors(modeName);
            return list2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDescriptorNames(String modeName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getDescriptorNames(modeName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProductPreference(String modeName, String descriptorName, String preferredProductName, String otherProductName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.setProductPreference(modeName, descriptorName, preferredProductName, otherProductName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetProductPreference(String modeName, String descriptorName, String preferredProductName, String otherProductName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unsetProductPreference(modeName, descriptorName, preferredProductName, otherProductName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProductPreferences(String modeName, String descriptorName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearProductPreferences(modeName, descriptorName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getProductPreferences(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[][] stringArray = super.getProductPreferences(modeName, descriptorName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOrderedProductList(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Vector vector = super.getOrderedProductList(modeName, descriptorName);
            return vector;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactory(String modeName, String descriptorName, String productName, Object factory) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.registerFactory(modeName, descriptorName, productName, factory);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFactory(String modeName, String descriptorName, String productName, Object factory) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unregisterFactory(modeName, descriptorName, productName, factory);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactoryPreference(String modeName, String descriptorName, String productName, Object preferredOp, Object otherOp) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.setFactoryPreference(modeName, descriptorName, productName, preferredOp, otherOp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetFactoryPreference(String modeName, String descriptorName, String productName, Object preferredOp, Object otherOp) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unsetFactoryPreference(modeName, descriptorName, productName, preferredOp, otherOp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFactoryPreferences(String modeName, String descriptorName, String productName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearFactoryPreferences(modeName, descriptorName, productName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getFactoryPreferences(String modeName, String descriptorName, String productName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object[][] objectArray = super.getFactoryPreferences(modeName, descriptorName, productName);
            return objectArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOrderedFactoryList(String modeName, String descriptorName, String productName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list2 = super.getOrderedFactoryList(modeName, descriptorName, productName);
            return list2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFactoryIterator(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Iterator iterator = super.getFactoryIterator(modeName, descriptorName);
            return iterator;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFactory(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object object = super.getFactory(modeName, descriptorName);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFactory(String modeName, String descriptorName, Object[] args) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object object = super.invokeFactory(modeName, descriptorName, args);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyGenerator(String modeName, String descriptorName, PropertyGenerator generator) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.addPropertyGenerator(modeName, descriptorName, generator);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyGenerator(String modeName, String descriptorName, PropertyGenerator generator) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.removePropertyGenerator(modeName, descriptorName, generator);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPropertyFromSource(String modeName, String descriptorName, String propertyName, int sourceIndex) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.copyPropertyFromSource(modeName, descriptorName, propertyName, sourceIndex);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressProperty(String modeName, String descriptorName, String propertyName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.suppressProperty(modeName, descriptorName, propertyName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressAllProperties(String modeName, String descriptorName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.suppressAllProperties(modeName, descriptorName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPropertyState(String modeName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearPropertyState(modeName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGeneratedPropertyNames(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getGeneratedPropertyNames(modeName, descriptorName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySource getPropertySource(String modeName, String descriptorName, Object op, Vector sources) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            PropertySource propertySource = super.getPropertySource(modeName, descriptorName, op, sources);
            return propertySource;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySource getPropertySource(OperationNode op) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            PropertySource propertySource = super.getPropertySource(op);
            return propertySource;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServices(ClassLoader cl) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.registerServices(cl);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOperationDescriptor(String operationName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unregisterOperationDescriptor(operationName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOperationPreferences(String operationName, String productName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearOperationPreferences(operationName, productName);
        }
        finally {
            writeLock.unlock();
        }
    }
}

