/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;

public class CompositeFeatureCollection
extends DataFeatureCollection {
    List<FeatureCollection> collections;

    public CompositeFeatureCollection(List collections) {
        this.collections = collections;
    }

    protected Iterator openIterator() throws IOException {
        return new CompositeIterator();
    }

    public SimpleFeatureType getSchema() {
        return null;
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() throws IOException {
        int count = 0;
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                i.next();
                ++count;
            }
        }
        finally {
            this.close(i);
        }
        return count;
    }

    public Object[] toArray(Object[] arg0) {
        ArrayList<FeatureCollection> list2 = new ArrayList<FeatureCollection>();
        Iterator<FeatureCollection> it = this.collections.iterator();
        while (it.hasNext()) {
            FeatureCollection col = it.next();
            FeatureIterator it2 = col.features();
            while (it2.hasNext()) {
                list2.add(it.next());
            }
            it2.close();
        }
        return list2.toArray(arg0);
    }

    public FeatureId getIdentifier() {
        throw new RuntimeException("Can't get the id for a composite featurecollection; you need to identify the consituent collections directly.");
    }

    public List<FeatureCollection> getCollections() {
        return this.collections;
    }

    class CompositeIterator
    implements Iterator {
        int index = 0;
        FeatureIterator iterator;

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return true;
            }
            while (this.index < CompositeFeatureCollection.this.collections.size()) {
                if (this.iterator != null) {
                    this.iterator.close();
                }
                this.iterator = CompositeFeatureCollection.this.collections.get(this.index++).features();
                if (!this.iterator.hasNext()) continue;
                return true;
            }
            if (this.iterator != null) {
                this.iterator.close();
            }
            return false;
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

