/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;

public abstract class XStreamServiceLoader<T extends ServiceInfo>
implements ServiceLoader<T> {
    GeoServerResourceLoader resourceLoader;
    String filenameBase;
    XStreamPersisterFactory xpf = new XStreamPersisterFactory();

    public XStreamServiceLoader(GeoServerResourceLoader resourceLoader, String filenameBase) {
        this.resourceLoader = resourceLoader;
        this.filenameBase = filenameBase;
    }

    public String getFilename() {
        return this.filenameBase + ".xml";
    }

    public void setXStreamPeristerFactory(XStreamPersisterFactory xpf) {
        this.xpf = xpf;
    }

    @Override
    public final T load(GeoServer gs) throws Exception {
        return this.load(gs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T load(GeoServer gs, File directory) throws Exception {
        String filename = this.getFilename();
        File file = this.resourceLoader.find(directory, filename);
        if (file != null && file.exists()) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                XStreamPersister xp = this.xpf.createXMLPersister();
                this.initXStreamPersister(xp, gs);
                ServiceInfo serviceInfo = this.initialize((ServiceInfo)xp.load(in, this.getServiceClass()));
                return (T)serviceInfo;
            }
        }
        T service = this.createServiceFromScratch(gs);
        return this.initialize(service);
    }

    public void initializeService(ServiceInfo info) {
        this.initialize(info);
    }

    protected T initialize(T service) {
        if (service instanceof ServiceInfoImpl) {
            ServiceInfoImpl impl = (ServiceInfoImpl)service;
            if (impl.getClientProperties() == null) {
                impl.setClientProperties(new HashMap());
            }
            if (impl.getExceptionFormats() == null) {
                impl.setExceptionFormats(new ArrayList());
            }
            if (impl.getKeywords() == null) {
                impl.setKeywords(new ArrayList<KeywordInfo>());
            }
            if (impl.getMetadata() == null) {
                impl.setMetadata(new MetadataMap());
            }
            if (impl.getVersions() == null) {
                impl.setVersions(new ArrayList());
            }
        }
        return service;
    }

    @Override
    public final void save(T service, GeoServer gs) throws Exception {
    }

    public final void save(T service, GeoServer gs, File directory) throws Exception {
        String filename = this.getFilename();
        Resource resource = this.resourceLoader.get(Paths.convert((File)this.resourceLoader.getBaseDirectory(), (File)directory, (String)filename));
        try (OutputStream out = resource.out();){
            XStreamPersister xp = this.xpf.createXMLPersister();
            this.initXStreamPersister(xp, gs);
            xp.save(service, out);
        }
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        xp.setGeoServer(gs);
        xp.setCatalog(gs.getCatalog());
        xp.getXStream().alias(this.filenameBase, this.getServiceClass());
    }

    @Override
    public final T create(GeoServer gs) {
        return this.createServiceFromScratch(gs);
    }

    protected abstract T createServiceFromScratch(GeoServer var1);
}

