/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SecureXStream
extends XStream {
    private static final String WHITELIST_KEY = "GEOSERVER_XSTREAM_WHITELIST";
    static final Logger LOGGER = Logging.getLogger(SecureXStream.class);

    public SecureXStream() {
        this.init();
    }

    public SecureXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super(reflectionProvider, driver, classLoaderReference, mapper);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference) {
        super(reflectionProvider, driver, classLoaderReference);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, hierarchicalStreamDriver);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider) {
        super(reflectionProvider);
        this.init();
    }

    private void init() {
        this.addPermission(NoTypePermission.NONE);
        this.allowTypes(new Class[]{Mapper.Null.class});
        this.addPermission((TypePermission)new PrimitiveTypePermission());
        this.allowTypes(new Class[]{String.class, java.util.Date.class, Date.class, Timestamp.class, Time.class});
        this.allowTypeHierarchy(Filter.class);
        this.allowTypeHierarchy(NumberRange.class);
        this.allowTypeHierarchy(CoordinateReferenceSystem.class);
        this.allowTypeHierarchy(Name.class);
        this.allowTypes(new Class[]{Version.class, SimpleInternationalString.class});
        this.allowTypes(new Class[]{TreeSet.class, SortedSet.class, Set.class, HashSet.class, LinkedHashSet.class, List.class, ArrayList.class, CopyOnWriteArrayList.class, Map.class, HashMap.class, TreeMap.class, ConcurrentHashMap.class});
        String whitelistProp = GeoServerExtensions.getProperty((String)WHITELIST_KEY);
        if (whitelistProp != null) {
            String[] wildcards = whitelistProp.split("\\s+|(\\s*;\\s*)");
            this.allowTypesByWildcard(wildcards);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return new DetailedSecurityExceptionWrapper((Mapper)next);
    }

    static class ForbiddenClassExceptionEx
    extends RuntimeException {
        public ForbiddenClassExceptionEx(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class DetailedSecurityExceptionWrapper
    extends MapperWrapper {
        public DetailedSecurityExceptionWrapper(Mapper wrapped) {
            super(wrapped);
        }

        public Class realClass(String elementName) {
            try {
                return super.realClass(elementName);
            }
            catch (ForbiddenClassException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Class {0} is not whitelisted for XML parsing. \n");
                sb.append("This is done to prevent Remote Code Execution attacks, but it might be \n").append("you need this class to be authorized for GeoServer to actually work\n");
                sb.append("If you are a user, you can set a variable named ").append(SecureXStream.WHITELIST_KEY).append("\n").append("  with a semicolon separated list of fully qualified names, or patterns\n").append("  to match several classes.The variable can be set as a system variable\n").append("  a enviromment variable, or a servlet context variable, just like \n").append("  GEOSERVER_DATA_DIR.\n").append("  For example, in order to authorize the org.geoserver.Foo class, \n").append("  plus any class in the org.geoserver.custom package, one could set\n").append("  a system variable: \n").append("  -D").append(SecureXStream.WHITELIST_KEY).append("=org.geoserver.Foo;org.geoserver.custom.**\n");
                sb.append("If instead you are a developer, you can call allowTypes/allowTypeHierarchy against \n").append("  the XStream used for serialization by rolling a custom \n").append("  XStreamPersisterInitializer or customizing your XStreamServiceLoader.");
                LOGGER.log(Level.SEVERE, sb.toString(), e.getMessage());
                throw new ForbiddenClassExceptionEx("Unauthorized class found, see logs for more details on how to handle it: " + e.getMessage(), e);
            }
        }
    }
}

