/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.data.util.IOUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;

public class GeoServerPersister
implements CatalogListener,
ConfigurationListener {
    private static final int MAX_RENAME_ATTEMPTS = 100;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    GeoServerResourceLoader rl;
    GeoServerDataDirectory dd;
    XStreamPersister xp;

    public GeoServerPersister(GeoServerResourceLoader rl, XStreamPersister xp) {
        this.rl = rl;
        this.dd = new GeoServerDataDirectory(rl);
        this.xp = xp;
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.addWorkspace((WorkspaceInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.addNamespace((NamespaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.addDataStore((DataStoreInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.addWMSStore((WMSStoreInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.addFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.addCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.addCoverage((CoverageInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.addWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.addLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.addStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.addLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) {
        CatalogInfo source = event.getSource();
        try {
            WorkspaceInfo defWorkspace;
            Resource newDir;
            Resource oldDir;
            WorkspaceInfo newWorkspace;
            int i = event.getPropertyNames().indexOf("name");
            if (i > -1) {
                String newName = (String)event.getNewValues().get(i);
                if (source instanceof WorkspaceInfo) {
                    this.renameWorkspace((WorkspaceInfo)source, newName);
                } else if (source instanceof StoreInfo) {
                    this.renameStore((StoreInfo)source, newName);
                } else if (source instanceof ResourceInfo) {
                    this.renameResource((ResourceInfo)source, newName);
                } else if (source instanceof StyleInfo) {
                    this.renameStyle((StyleInfo)source, newName);
                } else if (source instanceof LayerGroupInfo) {
                    this.renameLayerGroup((LayerGroupInfo)source, newName);
                }
            }
            if (source instanceof StoreInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                oldDir = this.dd.get((StoreInfo)source, new String[0]);
                this.moveResToDir(oldDir, this.dd.get(newWorkspace, new String[0]));
            }
            if (source instanceof FeatureTypeInfo && (i = event.getPropertyNames().indexOf("store")) > -1) {
                StoreInfo newStore = (StoreInfo)event.getNewValues().get(i);
                oldDir = this.dd.get((FeatureTypeInfo)source, new String[0]);
                newDir = this.dd.get(newStore, new String[0]);
                this.moveResToDir(oldDir, newDir);
            }
            if (source instanceof StyleInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                Resource newDir2 = this.dd.getStyles(newWorkspace, new String[0]);
                for (Resource old : this.dd.additionalStyleResources((StyleInfo)source)) {
                    if (old.getType() == Resource.Type.UNDEFINED) continue;
                    this.copyResToDir(old, newDir2);
                }
                for (Resource old : this.baseResources((StyleInfo)source)) {
                    if (old.getType() == Resource.Type.UNDEFINED) continue;
                    this.moveResToDir(old, newDir2);
                }
            }
            if (source instanceof LayerGroupInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                Resource oldRes = this.dd.config((LayerGroupInfo)source);
                newDir = this.dd.getLayerGroups(newWorkspace, new String[0]);
                this.moveResToDir(oldRes, newDir);
            }
            if (source instanceof Catalog && (i = event.getPropertyNames().indexOf("defaultWorkspace")) > -1 && (defWorkspace = (WorkspaceInfo)event.getNewValues().get(i)) != null) {
                this.persist(defWorkspace, this.dd.getWorkspaces("default.xml"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.modifyWorkspace((WorkspaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.modifyDataStore((DataStoreInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.modifyWMSStore((WMSStoreInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.modifyNamespace((NamespaceInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.modifyFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.modifyCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.modifyCoverage((CoverageInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.modifyWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.modifyLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.modifyStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.modifyLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.removeWorkspace((WorkspaceInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.removeNamespace((NamespaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.removeDataStore((DataStoreInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.removeFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.removeCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.removeCoverage((CoverageInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.removeWMSStore((WMSStoreInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.removeWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.removeLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.removeStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.removeLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostGlobalChange(GeoServerInfo global) {
        try {
            this.persist(global, this.dd.config(global));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleSettingsAdded(SettingsInfo settings) {
        this.handleSettingsPostModified(settings);
    }

    @Override
    public void handleSettingsModified(SettingsInfo settings, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        int i = propertyNames.indexOf("workspace");
        if (i > -1) {
            WorkspaceInfo newWorkspace = (WorkspaceInfo)newValues.get(i);
            LOGGER.fine("Moving settings '" + settings + " to workspace: " + newWorkspace);
            this.moveResToDir(this.dd.config(settings), this.dd.get(newWorkspace, new String[0]));
        }
    }

    @Override
    public void handleSettingsPostModified(SettingsInfo settings) {
        LOGGER.fine("Persisting settings " + settings);
        try {
            this.persist(settings, this.dd.config(settings));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleSettingsRemoved(SettingsInfo settings) {
        LOGGER.fine("Removing settings " + settings);
        this.rmRes(this.dd.config(settings));
    }

    @Override
    public void handleLoggingChange(LoggingInfo logging, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostLoggingChange(LoggingInfo logging) {
        try {
            this.persist(logging, this.dd.config(logging));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleServiceAdded(ServiceInfo service) {
    }

    @Override
    public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostServiceChange(ServiceInfo service) {
    }

    @Override
    public void handleServiceRemove(ServiceInfo service) {
    }

    @Override
    public void reloaded() {
    }

    private void addWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Persisting workspace " + ws.getName());
        Resource xml = this.dd.config(ws);
        this.ensureParent(xml);
        this.persist(ws, xml);
    }

    private void renameWorkspace(WorkspaceInfo ws, String newName) throws IOException {
        LOGGER.fine("Renaming workspace " + ws.getName() + "to " + newName);
        Resource directory = this.dd.get(ws, new String[0]);
        this.renameRes(directory, newName);
    }

    private void modifyWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Persisting workspace " + ws.getName());
        Resource r = this.dd.config(ws);
        this.persist(ws, r);
    }

    private void removeWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Removing workspace " + ws.getName());
        Resource directory = this.dd.get(ws, new String[0]);
        this.rmRes(directory);
    }

    private void addNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Persisting namespace " + ns.getPrefix());
        Resource xml = this.dd.config(ns);
        this.ensureParent(xml);
        this.persist(ns, xml);
    }

    private void modifyNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Persisting namespace " + ns.getPrefix());
        Resource xml = this.dd.config(ns);
        this.ensureParent(xml);
        this.persist(ns, xml);
    }

    private void removeNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Removing namespace " + ns.getPrefix());
        Resource directory = this.dd.get(ns, new String[0]);
        this.rmRes(directory);
    }

    private void addDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Persisting datastore " + ds.getName());
        Resource xml = this.dd.config(ds);
        this.ensureParent(xml);
        this.persist(ds, xml);
    }

    private void renameStore(StoreInfo s, String newName) throws IOException {
        LOGGER.fine("Renaming store " + s.getName() + "to " + newName);
        Resource directory = this.dd.get(s, new String[0]);
        this.renameRes(directory, newName);
    }

    private void modifyDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Persisting datastore " + ds.getName());
        Resource xml = this.dd.config(ds);
        this.persist(ds, xml);
    }

    private void removeDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Removing datastore " + ds.getName());
        Resource directory = this.dd.get(ds, new String[0]);
        this.rmRes(directory);
    }

    private void addFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Persisting feature type " + ft.getName());
        Resource xml = this.dd.config(ft);
        this.ensureParent(xml);
        this.persist(ft, xml);
    }

    private void renameResource(ResourceInfo r, String newName) throws IOException {
        LOGGER.fine("Renaming resource " + r.getName() + " to " + newName);
        Resource directory = this.dd.get(r, new String[0]);
        this.renameRes(directory, newName);
    }

    private void modifyFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Persisting feature type " + ft.getName());
        Resource xml = this.dd.config(ft);
        this.persist(ft, xml);
    }

    private void removeFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Removing feature type " + ft.getName());
        Resource directory = this.dd.get(ft, new String[0]);
        this.rmRes(directory);
    }

    private void addCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Persisting coverage store " + cs.getName());
        Resource xml = this.dd.config(cs);
        this.ensureParent(xml);
        this.persist(cs, xml);
    }

    private void modifyCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Persisting coverage store " + cs.getName());
        Resource r = this.dd.config(cs);
        this.persist(cs, r);
    }

    private void removeCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Removing coverage store " + cs.getName());
        Resource r = this.dd.get(cs, new String[0]);
        this.rmRes(r);
    }

    private void addCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Persisting coverage " + c.getName());
        Resource xml = this.dd.config(c);
        this.ensureParent(xml);
        this.persist(c, xml);
    }

    private void modifyCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Persisting coverage " + c.getName());
        Resource xml = this.dd.config(c);
        this.persist(c, xml);
    }

    private void removeCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Removing coverage " + c.getName());
        Resource directory = this.dd.get(c, new String[0]);
        this.rmRes(directory);
    }

    private void addWMSStore(WMSStoreInfo wmss) throws IOException {
        LOGGER.fine("Persisting wms store " + wmss.getName());
        Resource xml = this.dd.config(wmss);
        this.ensureParent(xml);
        this.persist(wmss, xml);
    }

    private void modifyWMSStore(WMSStoreInfo wmss) throws IOException {
        LOGGER.fine("Persisting wms store " + wmss.getName());
        Resource xml = this.dd.config(wmss);
        this.persist(wmss, xml);
    }

    private void removeWMSStore(WMSStoreInfo wmss) throws IOException {
        LOGGER.fine("Removing datastore " + wmss.getName());
        Resource directory = this.dd.get(wmss, new String[0]);
        this.rmRes(directory);
    }

    private void addWMSLayer(WMSLayerInfo wms) throws IOException {
        LOGGER.fine("Persisting wms layer " + wms.getName());
        Resource xml = this.dd.config(wms);
        this.ensureParent(xml);
        this.persist(wms, xml);
    }

    private void modifyWMSLayer(WMSLayerInfo wms) throws IOException {
        LOGGER.fine("Persisting wms layer" + wms.getName());
        Resource xml = this.dd.config(wms);
        this.persist(wms, xml);
    }

    private void removeWMSLayer(WMSLayerInfo wms) throws IOException {
        LOGGER.fine("Removing wms layer " + wms.getName());
        Resource directory = this.dd.get(wms, new String[0]);
        this.rmRes(directory);
    }

    private void addLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Persisting layer " + l.getName());
        Resource xml = this.dd.config(l);
        this.ensureParent(xml);
        this.persist(l, xml);
    }

    private void modifyLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Persisting layer " + l.getName());
        Resource xml = this.dd.config(l);
        this.persist(l, xml);
    }

    private void removeLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Removing layer " + l.getName());
        Resource directory = this.dd.get(l, new String[0]);
        this.rmRes(directory);
    }

    private void addStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Persisting style " + s.getName());
        Resource xml = this.dd.config(s);
        this.ensureParent(xml);
        this.persist(s, xml);
    }

    private void renameStyle(StyleInfo s, String newName) throws IOException {
        Resource sld;
        LOGGER.fine("Renaming style " + s.getName() + " to " + newName);
        Resource xml = this.dd.config(s);
        this.renameRes(xml, newName + ".xml");
        Resource style = this.dd.style(s);
        StyleHandler format = Styles.handler(s.getFormat());
        Resource target = this.uniqueResource(style, newName, format.getFileExtension());
        this.renameRes(style, target.name());
        s.setFilename(target.name());
        if (!"sld".equals(format.getFormat()) && (sld = style.parent().get(FilenameUtils.getBaseName((String)style.name()) + ".sld")).getType() == Resource.Type.RESOURCE) {
            Resource generated = this.uniqueResource(sld, newName, "sld");
            this.renameRes(sld, generated.name());
        }
    }

    private Resource uniqueResource(Resource resource, String newName, String extension) throws IOException {
        Resource target = resource.parent().get(newName + "." + extension);
        int i = 0;
        while (target.getType() != Resource.Type.UNDEFINED && ++i <= 100) {
            target = resource.parent().get(newName + i + "." + extension);
        }
        if (i > 100) {
            throw new IOException("All target files between " + newName + "1." + extension + " and " + newName + 100 + "." + extension + " are in use already, giving up");
        }
        return target;
    }

    private void modifyStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Persisting style " + s.getName());
        Resource xml = this.dd.config(s);
        this.persist(s, xml);
    }

    private void removeStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Removing style " + s.getName());
        Resource xml = this.dd.config(s);
        this.rmRes(xml);
    }

    private List<Resource> baseResources(StyleInfo s) throws IOException {
        List<Resource> list2 = Arrays.asList(this.dd.config(s), this.dd.style(s));
        return list2;
    }

    private List<Resource> additionalResources(StyleInfo s) throws IOException {
        final ArrayList<Resource> files = new ArrayList<Resource>();
        final Resource baseDir = this.dd.get(s, new String[0]);
        try {
            Style parsedStyle = this.dd.parsedStyle(s);
            parsedStyle.accept((StyleVisitor)new AbstractStyleVisitor(){

                public void visit(ExternalGraphic exgr) {
                    if (exgr.getOnlineResource() == null) {
                        return;
                    }
                    URI uri = exgr.getOnlineResource().getLinkage();
                    if (uri == null) {
                        return;
                    }
                    Resource r = null;
                    try {
                        r = GeoServerPersister.this.uriToResource(baseDir, uri);
                        if (r != null && r.getType() != Resource.Type.UNDEFINED) {
                            files.add(r);
                        }
                    }
                    catch (IllegalArgumentException | MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "Error attemping to process SLD resource", e);
                    }
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error loading style", e);
        }
        return files;
    }

    private void addLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Persisting layer group " + lg.getName());
        Resource xml = this.dd.config(lg);
        this.ensureParent(xml);
        this.persist(lg, xml);
    }

    private void renameLayerGroup(LayerGroupInfo lg, String newName) throws IOException {
        LOGGER.fine("Renaming layer group " + lg.getName() + " to " + newName);
        Resource xml = this.dd.config(lg);
        this.renameRes(xml, String.format("%s.xml", newName));
    }

    private void modifyLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Persisting layer group " + lg.getName());
        Resource xml = this.dd.config(lg);
        this.persist(lg, xml);
    }

    private void removeLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Removing layer group " + lg.getName());
        Resource xml = this.dd.config(lg);
        this.rmRes(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(Object o, Resource r) throws IOException {
        try {
            XStreamPersister xStreamPersister = this.xp;
            synchronized (xStreamPersister) {
                IOUtils.xStreamPersist(r, o, this.xp);
            }
            LOGGER.fine("Persisted " + o.getClass().getName() + " to " + r.path());
        }
        catch (Exception e) {
            String msg = "Error persisting " + o + " to " + r.path();
            throw new CatalogException(msg, e);
        }
    }

    private void rmRes(Resource r) {
        this.rl.remove(r.path());
    }

    private void renameRes(Resource r, String newName) {
        this.rl.move(r.path(), r.parent().get(newName).path());
    }

    private void moveResToDir(Resource r, Resource newDir) {
        this.rl.move(r.path(), newDir.get(r.name()).path());
    }

    private void copyResToDir(Resource r, Resource newDir) throws IOException {
        Resource newR = newDir.get(r.name());
        try (InputStream in = r.in();
             OutputStream out = newR.out();){
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void ensureParent(Resource r) {
        r.parent().dir();
    }

    private Resource uriToResource(Resource base, URI uri) throws MalformedURLException {
        if (uri.getScheme() != null && !uri.getScheme().equals("file")) {
            return null;
        }
        if (uri.isAbsolute() && !uri.isOpaque()) {
            assert (uri.getScheme().equals("file"));
            return Files.asResource((File)new File(uri.toURL().getFile()));
        }
        return base.get(uri.getSchemeSpecificPart());
    }
}

