/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.catalog.util.LegacyCatalogReader;
import org.geoserver.catalog.util.LegacyFeatureTypeInfoReader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.GeoServerPersister;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public abstract class GeoServerLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    protected GeoServerResourceLoader resourceLoader;
    GeoServer geoserver;
    XStreamPersisterFactory xpf = new XStreamPersisterFactory();
    static boolean legacy = false;

    public GeoServerLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    public void setXStreamPeristerFactory(XStreamPersisterFactory xpf) {
        this.xpf = xpf;
    }

    public static void setLegacy(boolean legacy) {
        GeoServerLoader.legacy = legacy;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Catalog) {
            if (bean instanceof Wrapper && ((Wrapper)bean).isWrapperFor(Catalog.class)) {
                return bean;
            }
            try {
                Catalog catalog = (Catalog)bean;
                XStreamPersister xp = this.xpf.createXMLPersister();
                xp.setCatalog(catalog);
                this.loadCatalog(catalog, xp);
                this.initializeStyles(catalog, xp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (bean instanceof GeoServer) {
            this.geoserver = (GeoServer)bean;
            try {
                XStreamPersister xp = this.xpf.createXMLPersister();
                xp.setCatalog(this.geoserver.getCatalog());
                this.loadGeoServer(this.geoserver, xp);
                this.loadInitializers(this.geoserver);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return bean;
    }

    protected abstract void loadCatalog(Catalog var1, XStreamPersister var2) throws Exception;

    protected abstract void loadGeoServer(GeoServer var1, XStreamPersister var2) throws Exception;

    protected void loadInitializers(GeoServer geoServer) throws Exception {
        List initializers = GeoServerExtensions.extensions(GeoServerInitializer.class);
        for (GeoServerInitializer initer : initializers) {
            try {
                initer.initialize(geoServer);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Failed to run initializer " + initer, t);
            }
        }
    }

    protected void initializeStyles(Catalog catalog, XStreamPersister xp) throws IOException {
        if (catalog.getStyleByName("point") == null) {
            this.initializeStyle(catalog, "point", "default_point.sld");
        }
        if (catalog.getStyleByName("line") == null) {
            this.initializeStyle(catalog, "line", "default_line.sld");
        }
        if (catalog.getStyleByName("polygon") == null) {
            this.initializeStyle(catalog, "polygon", "default_polygon.sld");
        }
        if (catalog.getStyleByName("raster") == null) {
            this.initializeStyle(catalog, "raster", "default_raster.sld");
        }
        if (catalog.getStyleByName("generic") == null) {
            this.initializeStyle(catalog, "generic", "default_generic.sld");
        }
    }

    void initializeStyle(Catalog catalog, String styleName, String sld) throws IOException {
        if (this.resourceLoader.find(new String[]{"styles", sld}) == null) {
            FileUtils.copyURLToFile((URL)GeoServerLoader.class.getResource(sld), (File)new File(this.resourceLoader.findOrCreateDirectory("styles"), sld));
        }
        StyleInfo s = catalog.getFactory().createStyle();
        s.setName(styleName);
        s.setFilename(sld);
        catalog.add(s);
    }

    public void reload() throws Exception {
        this.destroy();
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper) {
            catalog = ((Wrapper)((Object)this.geoserver.getCatalog())).unwrap(Catalog.class);
        }
        XStreamPersister xp = this.xpf.createXMLPersister();
        xp.setCatalog(catalog);
        this.loadCatalog(catalog, xp);
        this.loadGeoServer(this.geoserver, xp);
    }

    protected void readCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        CatalogImpl catalog2;
        catalog.removeListeners(ResourcePool.CacheClearingListener.class);
        catalog.removeListeners(GeoServerPersister.class);
        ArrayList<CatalogListener> listeners = new ArrayList<CatalogListener>(catalog.getListeners());
        File f = this.resourceLoader.find("catalog.xml");
        if (f == null) {
            catalog2 = (CatalogImpl)this.readCatalog(xp);
            ((CatalogImpl)catalog).sync(catalog2);
        } else {
            catalog2 = (CatalogImpl)this.readLegacyCatalog(f, xp);
            ((CatalogImpl)catalog).sync(catalog2);
        }
        for (CatalogListener listener : listeners) {
            catalog.addListener(listener);
        }
    }

    Catalog readCatalog(XStreamPersister xp) throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        catalog.setResourceLoader(this.resourceLoader);
        xp.setCatalog(catalog);
        xp.setUnwrapNulls(false);
        CatalogFactory factory = catalog.getFactory();
        this.loadStyles(this.resourceLoader.find("styles"), catalog, xp);
        File workspaces = this.resourceLoader.find("workspaces");
        if (workspaces != null) {
            File dws = new File(workspaces, "default.xml");
            WorkspaceInfo defaultWorkspace = null;
            if (dws.exists()) {
                try {
                    defaultWorkspace = this.depersist(xp, dws, WorkspaceInfo.class);
                    LOGGER.info("Loaded default workspace " + defaultWorkspace.getName());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load default workspace", e);
                }
            } else {
                LOGGER.warning("No default workspace was found.");
            }
            for (File wsd : this.list(workspaces, DirectoryFileFilter.INSTANCE)) {
                File styles;
                File f = new File(wsd, "workspace.xml");
                if (!f.exists()) continue;
                WorkspaceInfo ws = null;
                try {
                    ws = this.depersist(xp, f, WorkspaceInfo.class);
                    catalog.add(ws);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load workspace '" + wsd.getName() + "'", e);
                    continue;
                }
                LOGGER.info("Loaded workspace '" + ws.getName() + "'");
                File nsf = new File(wsd, "namespace.xml");
                NamespaceInfo ns = null;
                if (nsf.exists()) {
                    try {
                        ns = this.depersist(xp, nsf, NamespaceInfo.class);
                        catalog.add(ns);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to load namespace for '" + wsd.getName() + "'", e);
                    }
                }
                if (defaultWorkspace != null) {
                    if (ws.getName().equals(defaultWorkspace.getName())) {
                        catalog.setDefaultWorkspace(ws);
                        if (ns != null) {
                            catalog.setDefaultNamespace(ns);
                        }
                    }
                } else {
                    defaultWorkspace = catalog.getDefaultWorkspace();
                    if (defaultWorkspace != null) {
                        try {
                            this.persist(xp, defaultWorkspace, dws);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to persist default workspace '" + wsd.getName() + "'", e);
                        }
                    }
                }
                if ((styles = this.resourceLoader.find(wsd, "styles")) == null) continue;
                this.loadStyles(styles, catalog, xp);
            }
            for (File wsd : this.list(workspaces, DirectoryFileFilter.INSTANCE)) {
                for (File sd : this.list(wsd, DirectoryFileFilter.INSTANCE)) {
                    LayerInfo l;
                    File f = new File(sd, "datastore.xml");
                    if (f.exists()) {
                        DataStoreInfo ds;
                        block51: {
                            ds = null;
                            try {
                                ds = this.depersist(xp, f, DataStoreInfo.class);
                                catalog.add(ds);
                                LOGGER.info("Loaded data store '" + ds.getName() + "'");
                                if (!ds.isEnabled()) break block51;
                                try {
                                    ds.getDataStore(null);
                                }
                                catch (Throwable t) {
                                    LOGGER.warning("Error connecting to '" + ds.getName() + "'. Disabling.");
                                    LOGGER.log(Level.INFO, "", t);
                                    ds.setError(t);
                                    ds.setEnabled(false);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Failed to load data store '" + sd.getName() + "'", e);
                                continue;
                            }
                        }
                        for (File ftd : this.list(sd, DirectoryFileFilter.INSTANCE)) {
                            f = new File(ftd, "featuretype.xml");
                            if (f.exists()) {
                                FeatureTypeInfo ft = null;
                                try {
                                    ft = this.depersist(xp, f, FeatureTypeInfo.class);
                                    catalog.add(ft);
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load feature type '" + ftd.getName() + "'", e);
                                    continue;
                                }
                                LOGGER.info("Loaded feature type '" + ds.getName() + "'");
                                f = new File(ftd, "layer.xml");
                                if (!f.exists()) continue;
                                try {
                                    l = this.depersist(xp, f, LayerInfo.class);
                                    catalog.add(l);
                                    LOGGER.info("Loaded layer '" + l.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load layer for feature type '" + ft.getName() + "'", e);
                                }
                                continue;
                            }
                            LOGGER.warning("Ignoring feature type directory " + ftd.getAbsolutePath());
                        }
                        continue;
                    }
                    f = new File(sd, "coveragestore.xml");
                    if (f.exists()) {
                        CoverageStoreInfo cs = null;
                        try {
                            cs = this.depersist(xp, f, CoverageStoreInfo.class);
                            catalog.add(cs);
                            LOGGER.info("Loaded coverage store '" + cs.getName() + "'");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to load coverage store '" + sd.getName() + "'", e);
                            continue;
                        }
                        for (File cd : this.list(sd, DirectoryFileFilter.INSTANCE)) {
                            f = new File(cd, "coverage.xml");
                            if (f.exists()) {
                                CoverageInfo c = null;
                                try {
                                    c = this.depersist(xp, f, CoverageInfo.class);
                                    catalog.add(c);
                                    LOGGER.info("Loaded coverage '" + cs.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load coverage '" + cd.getName() + "'", e);
                                    continue;
                                }
                                f = new File(cd, "layer.xml");
                                if (!f.exists()) continue;
                                try {
                                    l = this.depersist(xp, f, LayerInfo.class);
                                    catalog.add(l);
                                    LOGGER.info("Loaded layer '" + l.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load layer coverage '" + c.getName() + "'", e);
                                }
                                continue;
                            }
                            LOGGER.warning("Ignoring coverage directory " + cd.getAbsolutePath());
                        }
                        continue;
                    }
                    f = new File(sd, "wmsstore.xml");
                    if (f.exists()) {
                        WMSStoreInfo wms = null;
                        try {
                            wms = this.depersist(xp, f, WMSStoreInfo.class);
                            catalog.add(wms);
                            LOGGER.info("Loaded wmsstore '" + wms.getName() + "'");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to load wms store '" + sd.getName() + "'", e);
                            continue;
                        }
                        for (File cd : this.list(sd, DirectoryFileFilter.INSTANCE)) {
                            f = new File(cd, "wmslayer.xml");
                            if (f.exists()) {
                                WMSLayerInfo wl = null;
                                try {
                                    wl = this.depersist(xp, f, WMSLayerInfo.class);
                                    catalog.add(wl);
                                    LOGGER.info("Loaded wms layer'" + wl.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load wms layer '" + cd.getName() + "'", e);
                                    continue;
                                }
                                f = new File(cd, "layer.xml");
                                if (!f.exists()) continue;
                                try {
                                    l = this.depersist(xp, f, LayerInfo.class);
                                    catalog.add(l);
                                    LOGGER.info("Loaded layer '" + l.getName() + "'");
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to load cascaded wms layer '" + wl.getName() + "'", e);
                                }
                                continue;
                            }
                            LOGGER.warning("Ignoring coverage directory " + cd.getAbsolutePath());
                        }
                        continue;
                    }
                    if (this.isConfigDirectory(sd)) continue;
                    LOGGER.warning("Ignoring store directory '" + sd.getName() + "'");
                }
                File layergroups = this.resourceLoader.find(wsd, "layergroups");
                if (layergroups == null) continue;
                this.loadLayerGroups(layergroups, catalog, xp);
            }
        } else {
            LOGGER.warning("No 'workspaces' directory found, unable to load any stores.");
        }
        File layergroups = this.resourceLoader.find("layergroups");
        if (layergroups != null) {
            this.loadLayerGroups(layergroups, catalog, xp);
        }
        xp.setUnwrapNulls(true);
        catalog.resolve();
        return catalog;
    }

    private boolean isConfigDirectory(File dir) {
        String name = dir.getName();
        boolean result = "styles".equals(name) || "layergroups".equals(name);
        return result;
    }

    Catalog readLegacyCatalog(File f, XStreamPersister xp) throws Exception {
        CatalogImpl catalog2 = new CatalogImpl();
        catalog2.setResourceLoader(this.resourceLoader);
        GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
        if (!legacy) {
            catalog2.addListener(p);
        }
        LegacyCatalogImporter importer = new LegacyCatalogImporter(catalog2);
        importer.setResourceLoader(this.resourceLoader);
        importer.imprt(this.resourceLoader.getBaseDirectory());
        if (!legacy) {
            catalog2.removeListener(p);
        }
        if (!legacy) {
            File featureTypesDir = this.resourceLoader.find("featureTypes");
            if (featureTypesDir != null) {
                LegacyCatalogReader creader = new LegacyCatalogReader();
                creader.read(f);
                Map<String, Map<String, Object>> dataStores = creader.dataStores();
                for (File featureTypeDir : featureTypesDir.listFiles()) {
                    File featureTypeInfo;
                    if (!featureTypeDir.isDirectory() || !(featureTypeInfo = new File(featureTypeDir, "info.xml")).exists()) continue;
                    LegacyFeatureTypeInfoReader reader = new LegacyFeatureTypeInfoReader();
                    reader.read(featureTypeInfo);
                    Map<String, Object> dataStore = dataStores.get(reader.dataStore());
                    if (dataStore == null) continue;
                    String namespace = (String)dataStore.get("namespace");
                    File destFeatureTypeDir = this.resourceLoader.find(new String[]{"workspaces", namespace, reader.dataStore(), reader.name()});
                    if (destFeatureTypeDir == null) continue;
                    for (File file : featureTypeDir.listFiles()) {
                        if (!file.isFile() || featureTypeInfo.equals(file)) continue;
                        FileUtils.copyFile((File)file, (File)new File(destFeatureTypeDir, file.getName()));
                    }
                }
            }
            f.renameTo(new File(f.getParentFile(), "catalog.xml.old"));
        }
        return catalog2;
    }

    protected void readConfiguration(GeoServer geoServer, XStreamPersister xp) throws Exception {
        File f = this.resourceLoader.find("services.xml");
        if (f == null) {
            File workspaces;
            f = this.resourceLoader.find("global.xml");
            if (f != null) {
                GeoServerInfo global = this.depersist(xp, f, GeoServerInfo.class);
                geoServer.setGlobal(global);
            }
            if ((f = this.resourceLoader.find("logging.xml")) != null) {
                LoggingInfo logging = this.depersist(xp, f, LoggingInfo.class);
                geoServer.setLogging(logging);
            }
            if ((workspaces = this.resourceLoader.find("workspaces")) != null) {
                for (File dir : workspaces.listFiles()) {
                    if (!dir.isDirectory() && !dir.isHidden() || (f = this.resourceLoader.find(dir, "settings.xml")) == null) continue;
                    SettingsInfo settings = this.depersist(xp, f, SettingsInfo.class);
                    geoServer.add(settings);
                }
            }
            List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
            this.loadServices(null, loaders, geoServer);
            if (workspaces != null) {
                for (File dir : workspaces.listFiles()) {
                    if (!dir.isDirectory() && !dir.isHidden()) continue;
                    this.loadServices(dir, loaders, geoServer);
                }
            }
        } else {
            GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
            geoServer.addListener(p);
            new LegacyConfigurationImporter(geoServer).imprt(this.resourceLoader.getBaseDirectory());
            geoServer.removeListener(p);
            f.renameTo(new File(f.getParentFile(), "services.xml.old"));
        }
    }

    void loadStyles(File styles, Catalog catalog, XStreamPersister xp) {
        for (File sf : this.list(styles, (IOFileFilter)new SuffixFileFilter(".xml"))) {
            try {
                if (new File(styles, sf.getName() + ".xml").exists()) continue;
                StyleInfo s = this.depersist(xp, sf, StyleInfo.class);
                catalog.add(s);
                LOGGER.info("Loaded style '" + s.getName() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load style from file '" + sf.getName() + "'", e);
            }
        }
    }

    void loadLayerGroups(File layergroups, Catalog catalog, XStreamPersister xp) {
        for (File lgf : this.list(layergroups, (IOFileFilter)new SuffixFileFilter(".xml"))) {
            try {
                LayerGroupInfo lg = this.depersist(xp, lgf, LayerGroupInfo.class);
                if (lg.getLayers() == null || lg.getLayers().size() == 0) {
                    LOGGER.warning("Skipping empty layer group '" + lg.getName() + "', it is invalid");
                    continue;
                }
                catalog.add(lg);
                LOGGER.info("Loaded layer group '" + lg.getName() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load layer group '" + lgf.getName() + "'", e);
            }
        }
    }

    void loadServices(File directory, List<XStreamServiceLoader> loaders, GeoServer geoServer) {
        for (XStreamServiceLoader l : loaders) {
            try {
                Object s = l.load(geoServer, directory);
                if (directory != null && s.getWorkspace() == null) continue;
                geoServer.add((ServiceInfo)s);
                LOGGER.info("Loaded service '" + s.getId() + "', " + (s.isEnabled() ? "enabled" : "disabled"));
            }
            catch (Throwable t) {
                if (directory != null) {
                    LOGGER.log(Level.SEVERE, "Failed to load the service configuration in directory: " + directory + " with loader for " + l.getServiceClass(), t);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Failed to load the root service configuration with loader for " + l.getServiceClass(), t);
            }
        }
    }

    void persist(XStreamPersister xp, Object obj, File f) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        xp.save(obj, out);
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T depersist(XStreamPersister xp, File f, Class<T> clazz) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            T t = xp.load(in, clazz);
            return t;
        }
    }

    Collection<File> list(File d, IOFileFilter filter) {
        if (d == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : d.listFiles()) {
            if (!filter.accept(f)) continue;
            files.add(f);
        }
        return files;
    }

    public void destroy() throws Exception {
        this.geoserver.dispose();
    }
}

