/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerPersister;
import org.geoserver.config.ServicePersister;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;

public class DefaultGeoServerLoader
extends GeoServerLoader {
    ConfigurationListener listener;
    GeoServerPersister persister;

    public DefaultGeoServerLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    protected void loadCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        this.readCatalog(catalog, xp);
        if (!legacy) {
            catalog.addListener(new GeoServerPersister(this.resourceLoader, xp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadGeoServer(GeoServer geoServer, XStreamPersister xp) throws Exception {
        if (this.listener == null) {
            List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
            this.listener = new ServicePersister(loaders, geoServer);
        } else {
            this.geoserver.removeListener(this.listener);
        }
        try {
            if (this.persister != null) {
                this.geoserver.removeListener(this.persister);
            } else {
                this.persister = new GeoServerPersister(this.resourceLoader, xp);
            }
            this.readConfiguration(geoServer, xp);
        }
        finally {
            this.geoserver.addListener(this.persister);
            this.geoserver.addListener(this.listener);
        }
    }

    @Override
    protected void initializeStyles(Catalog catalog, XStreamPersister xp) throws IOException {
        GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
        catalog.addListener(p);
        super.initializeStyles(catalog, xp);
        catalog.removeListener(p);
    }
}

