/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class ReaderDimensionsAccessor {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Logger LOGGER = Logging.getLogger(ReaderDimensionsAccessor.class);
    private static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Comparator<Object> TEMPORAL_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Date && o2 instanceof Date) {
                return ((Date)o1).compareTo((Date)o2);
            }
            if (o1 instanceof DateRange && o2 instanceof DateRange) {
                return ((DateRange)o1).getMinValue().compareTo(((DateRange)o2).getMinValue());
            }
            throw new IllegalArgumentException("Unexpected, values to be ordered have to be either all Date objects, or all DateRange objects, instead they are: " + o1 + ", " + o2);
        }
    };
    private static final Comparator<Object> ELEVATION_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Double && o2 instanceof Double) {
                return ((Double)o1).compareTo((Double)o2);
            }
            if (o1 instanceof NumberRange && o2 instanceof NumberRange) {
                return ((Double)((NumberRange)o1).getMinValue()).compareTo((Double)((NumberRange)o2).getMinValue());
            }
            throw new IllegalArgumentException("Unexpected, values to be ordered have to be either all Double objects, or all NumberRange objects");
        }
    };
    private final GridCoverage2DReader reader;
    private final List<String> metadataNames = new ArrayList<String>();

    public ReaderDimensionsAccessor(GridCoverage2DReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        this.reader = reader;
        String[] dimensions = reader.getMetadataNames();
        if (dimensions != null) {
            this.metadataNames.addAll(Arrays.asList(dimensions));
        }
    }

    public boolean hasTime() throws IOException {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_TIME_DOMAIN"));
    }

    public TreeSet<Object> getTimeDomain() throws IOException {
        if (!this.hasTime()) {
            Collections.emptySet();
        }
        SimpleDateFormat df = this.getTimeFormat();
        String domain = this.reader.getMetadataValue("TIME_DOMAIN");
        String[] timeInstants = domain.split("\\s*,\\s*");
        TreeSet<Object> values = new TreeSet<Object>(TEMPORAL_COMPARATOR);
        for (String tp : timeInstants) {
            try {
                values.add(this.parseTimeOrRange(df, tp));
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return values;
    }

    private Object parseTimeOrRange(SimpleDateFormat df, String timeOrRange) throws ParseException {
        if (timeOrRange.contains("/")) {
            String[] splitted = timeOrRange.split("/");
            Date start = df.parse(splitted[0]);
            Date end = df.parse(splitted[1]);
            return new DateRange(start, end);
        }
        return df.parse(timeOrRange);
    }

    private Object parseNumberOrRange(String val) {
        if (val.contains("/")) {
            String[] splitted = val.split("/");
            double start = Double.parseDouble(splitted[0]);
            double end = Double.parseDouble(splitted[1]);
            return new NumberRange(Double.class, (Number)start, (Number)end);
        }
        return Double.parseDouble(val);
    }

    public Date getMaxTime() throws IOException {
        if (!this.hasTime()) {
            return null;
        }
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MAXIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get CURRENT time from coverage reader", e);
        }
    }

    public Date getMinTime() throws IOException {
        if (!this.hasTime()) {
            return null;
        }
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MINIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get minimum time from coverage reader", e);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(UTC_PATTERN);
        df.setTimeZone(UTC_TIME_ZONE);
        return df;
    }

    public boolean hasElevation() throws IOException {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
    }

    public TreeSet<Object> getElevationDomain() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String[] elevationValues = this.reader.getMetadataValue("ELEVATION_DOMAIN").split(",");
        TreeSet<Object> elevations = new TreeSet<Object>(ELEVATION_COMPARATOR);
        for (String val : elevationValues) {
            try {
                elevations.add(this.parseNumberOrRange(val));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return elevations;
    }

    public Double getMaxElevation() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get maximum elevation from coverage reader", e);
        }
    }

    public Double getMinElevation() throws IOException {
        if (!this.hasElevation()) {
            return null;
        }
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get minimum elevation from coverage reader", e);
        }
    }

    public List<String> getCustomDomains() {
        if (this.metadataNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> names = new HashSet<String>(this.metadataNames);
        TreeSet<String> result = new TreeSet<String>();
        for (String name : names) {
            String dimension;
            if (!name.startsWith("HAS_") || !name.endsWith("_DOMAIN") || !names.contains((dimension = name.substring(4, name.length() - 7)) + "_DOMAIN") || "TIME".equals(dimension) || "ELEVATION".equals(dimension)) continue;
            result.add(dimension);
        }
        return new ArrayList<String>(result);
    }

    public String getDomainDatatype(String domainName) throws IOException {
        return this.reader.getMetadataValue(domainName.toUpperCase() + "_DOMAIN_DATATYPE");
    }

    public boolean hasDomain(String name) throws IOException {
        Utilities.ensureNonNull((String)"name", (Object)name);
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_" + name.toUpperCase() + "_DOMAIN"));
    }

    public List<String> getDomain(String name) throws IOException {
        String[] values = this.reader.getMetadataValue(name.toUpperCase() + "_DOMAIN").split(",");
        ArrayList<String> valueSet = new ArrayList<String>();
        for (String val : values) {
            valueSet.add(val);
        }
        return valueSet;
    }

    public String getCustomDomainDefaultValue(String name) throws IOException {
        Utilities.ensureNonNull((String)"name", (Object)name);
        String minimum = this.reader.getMetadataValue(name.toUpperCase() + "_DOMAIN_MINIMUM");
        if (minimum != null) {
            return minimum;
        }
        List<String> domain = this.getDomain(name);
        if (domain.isEmpty()) {
            return null;
        }
        return domain.get(0);
    }

    public boolean hasRange(String domain) {
        return this.metadataNames.contains(domain + "_DOMAIN_MAXIMUM") && this.metadataNames.contains(domain + "_DOMAIN_MINIMUM");
    }

    public boolean hasResolution(String domain) {
        Utilities.ensureNonNull((String)"name", (Object)domain);
        return this.metadataNames.contains(domain.toUpperCase() + "_DOMAIN_RESOLUTION");
    }
}

