/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LegacyCatalogReader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    Element catalog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        try (Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));){
            this.catalog = ReaderUtils.parse(reader);
        }
    }

    public Map<String, Map<String, Object>> dataStores() throws Exception {
        Element dataStoresElement = ReaderUtils.getChildElement(this.catalog, "datastores", true);
        NodeList dataStoreElements = dataStoresElement.getElementsByTagName("datastore");
        LinkedHashMap<String, Map<String, Object>> dataStores = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < dataStoreElements.getLength(); ++i) {
            Element dataStoreElement = (Element)dataStoreElements.item(i);
            HashMap<String, Object> dataStore = new HashMap<String, Object>();
            String id = ReaderUtils.getAttribute(dataStoreElement, "id", true);
            dataStore.put("id", id);
            dataStore.put("namespace", ReaderUtils.getAttribute(dataStoreElement, "namespace", false));
            dataStore.put("enabled", ReaderUtils.getBooleanAttribute(dataStoreElement, "enabled", false, true));
            try {
                Map params = this.dataStoreParams(dataStoreElement);
                dataStore.put("connectionParams", params);
            }
            catch (Exception e) {
                LOGGER.warning("Error reading data store paramaters: " + e.getMessage());
                LOGGER.log(Level.INFO, "", e);
                continue;
            }
            dataStores.put(id, dataStore);
        }
        return dataStores;
    }

    public List<Map<String, Object>> formats() throws Exception {
        Element formatsElement = ReaderUtils.getChildElement(this.catalog, "formats", true);
        NodeList formatElements = formatsElement.getElementsByTagName("format");
        ArrayList<Map<String, Object>> formats = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < formatElements.getLength(); ++i) {
            Element formatElement = (Element)formatElements.item(i);
            HashMap<String, Object> format = new HashMap<String, Object>();
            format.put("id", ReaderUtils.getAttribute(formatElement, "id", true));
            format.put("namespace", ReaderUtils.getAttribute(formatElement, "namespace", false));
            format.put("enabled", ReaderUtils.getBooleanAttribute(formatElement, "enabled", false, true));
            format.put("type", ReaderUtils.getChildText(formatElement, "type", true));
            format.put("url", ReaderUtils.getChildText(formatElement, "url", false));
            format.put("title", ReaderUtils.getChildText(formatElement, "title", false));
            format.put("description", ReaderUtils.getChildText(formatElement, "description", false));
            formats.add(format);
        }
        return formats;
    }

    public Map<String, String> namespaces() throws Exception {
        Element namespacesElement = ReaderUtils.getChildElement(this.catalog, "namespaces", true);
        NodeList namespaceElements = namespacesElement.getElementsByTagName("namespace");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < namespaceElements.getLength(); ++i) {
            Element namespaceElement = (Element)namespaceElements.item(i);
            try {
                Map.Entry tuple = this.namespaceTuple(namespaceElement);
                namespaces.put((String)tuple.getKey(), (String)tuple.getValue());
                if (!"true".equals(namespaceElement.getAttribute("default"))) continue;
                namespaces.put("", (String)tuple.getValue());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return namespaces;
    }

    public Map<String, String> styles() throws Exception {
        Element stylesElement = ReaderUtils.getChildElement(this.catalog, "styles", true);
        NodeList styleElements = stylesElement.getElementsByTagName("style");
        HashMap<String, String> styles = new HashMap<String, String>();
        for (int i = 0; i < styleElements.getLength(); ++i) {
            Element styleElement = (Element)styleElements.item(i);
            styles.put(styleElement.getAttribute("id"), styleElement.getAttribute("filename"));
        }
        return styles;
    }

    protected Map dataStoreParams(Element dataStoreElement) throws Exception {
        Element paramsElement = ReaderUtils.getChildElement(dataStoreElement, "connectionParams", true);
        NodeList paramList = paramsElement.getElementsByTagName("parameter");
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element paramElement = (Element)paramList.item(i);
            String key = ReaderUtils.getAttribute(paramElement, "name", true);
            String value = ReaderUtils.getAttribute(paramElement, "value", false);
            params.put(key, value);
        }
        return params;
    }

    protected Map.Entry namespaceTuple(Element namespaceElement) throws Exception {
        final String pre = namespaceElement.getAttribute("prefix");
        final String uri = namespaceElement.getAttribute("uri");
        return new Map.Entry(){

            public Object getKey() {
                return pre;
            }

            public Object getValue() {
                return uri;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

