/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.catalog.impl.WrappingProxy;

public class ProxyUtils {
    public static <T> T createProxy(T proxyObject, Class<T> clazz, InvocationHandler h) {
        Object proxy;
        List<Class<?>> proxyInterfaces = Arrays.asList(proxyObject.getClass().getInterfaces());
        boolean add = true;
        for (Class<?> interfce : proxyObject.getClass().getInterfaces()) {
            if (!clazz.isAssignableFrom(interfce)) continue;
            add = false;
            break;
        }
        if (add) {
            proxyInterfaces = new ArrayList(proxyInterfaces);
            proxyInterfaces.add(clazz);
        }
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), proxyInterfaces.toArray(new Class[proxyInterfaces.size()]));
        try {
            proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)proxy;
    }

    public static <T> T unwrap(T object, Class<? extends InvocationHandler> handlerClass) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = ProxyUtils.handler(object, handlerClass)) != null && h instanceof WrappingProxy) {
            return (T)((WrappingProxy)h).getProxyObject();
        }
        if (object instanceof ProxyList) {
            return (T)((ProxyList)object).proxyList;
        }
        return object;
    }

    public static <H extends InvocationHandler> H handler(Object object, Class<H> handlerClass) {
        InvocationHandler h;
        if (object instanceof Proxy && handlerClass.isInstance(h = Proxy.getInvocationHandler(object))) {
            return (H)h;
        }
        return null;
    }
}

