/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.impl.ModificationProxyCloner;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.impl.WrappingProxy;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class ModificationProxy
implements WrappingProxy,
Serializable {
    Object proxyObject;
    transient ClassProperties cp;
    HashMap<String, Object> properties;
    HashMap<String, Object> oldCollectionValues;

    public ModificationProxy(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    private ClassProperties cp() {
        if (this.cp == null) {
            this.cp = OwsUtils.getClassProperties(this.proxyObject.getClass());
        }
        return this.cp;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String property = null;
        if ((method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0) {
            property = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
            if (this.properties != null && this.properties().containsKey(property)) {
                return this.properties().get(property);
            }
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                Collection real = (Collection)method.invoke(this.proxyObject, null);
                if (real == null) {
                    return null;
                }
                Collection wrap = ModificationProxyCloner.cloneCollection(real, true);
                this.properties().put(property, wrap);
                Collection clone = ModificationProxyCloner.cloneCollection(real, false);
                this.oldCollectionValues().put(property, clone);
                return wrap;
            }
            if (Map.class.isAssignableFrom(method.getReturnType())) {
                Map real = (Map)method.invoke(this.proxyObject, null);
                if (real == null) {
                    return null;
                }
                Map wrap = ModificationProxyCloner.cloneMap(real, true);
                this.properties().put(property, wrap);
                Map clone = ModificationProxyCloner.cloneMap(real, false);
                this.oldCollectionValues().put(property, clone);
                return wrap;
            }
        }
        if (method.getName().startsWith("set") && args.length == 1) {
            property = method.getName().substring(3);
            this.properties().put(property, args[0]);
            return null;
        }
        try {
            Object o;
            Object result = method.invoke(this.proxyObject, args);
            if (result != null && this.shouldProxyProperty(result.getClass()) && (o = ModificationProxy.unwrap(result)) == result) {
                result = ModificationProxy.create(result, method.getReturnType());
                this.properties().put(property, result);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
    }

    @Override
    public Object getProxyObject() {
        return this.proxyObject;
    }

    public HashMap<String, Object> getProperties() {
        return this.properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.proxyObject;
        synchronized (object) {
            for (Map.Entry<String, Object> e : this.properties().entrySet()) {
                String p = e.getKey();
                Object v = e.getValue();
                try {
                    Method g = this.getter(p);
                    if (Collection.class.isAssignableFrom(g.getReturnType())) {
                        Collection c = (Collection)g.invoke(this.proxyObject, null);
                        c.clear();
                        c.addAll((Collection)v);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(g.getReturnType())) {
                        Map m = (Map)g.invoke(this.proxyObject, null);
                        m.clear();
                        m.putAll((Map)v);
                        continue;
                    }
                    Method s = this.setter(p, g.getReturnType());
                    if (Info.class.isAssignableFrom(g.getReturnType())) {
                        Info modified;
                        Info original = (Info)g.invoke(this.proxyObject, null);
                        if (original == (modified = (Info)ModificationProxy.unwrap(v))) {
                            ModificationProxy h;
                            if (!(v instanceof Proxy) || (h = ModificationProxy.handler(v)) == null || !h.isDirty()) continue;
                            h.commit();
                            continue;
                        }
                        if (s != null) {
                            s.invoke(this.proxyObject, v);
                            continue;
                        }
                        throw new IllegalStateException("New info object set, but no setter for it.");
                    }
                    s.invoke(this.proxyObject, v);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.properties = null;
        }
    }

    boolean shouldProxyProperty(Class propertyType) {
        if (Catalog.class.isAssignableFrom(propertyType)) {
            return false;
        }
        return Info.class.isAssignableFrom(propertyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> properties() {
        if (this.properties != null) {
            return this.properties;
        }
        ModificationProxy modificationProxy = this;
        synchronized (modificationProxy) {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap();
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> oldCollectionValues() {
        if (this.oldCollectionValues != null) {
            return this.oldCollectionValues;
        }
        ModificationProxy modificationProxy = this;
        synchronized (modificationProxy) {
            if (this.oldCollectionValues != null) {
                return this.oldCollectionValues;
            }
            this.oldCollectionValues = new HashMap();
        }
        return this.oldCollectionValues;
    }

    public boolean isDirty() {
        boolean dirty = false;
        Iterator<Map.Entry<String, Object>> i = this.properties().entrySet().iterator();
        while (i.hasNext() && !dirty) {
            Map.Entry<String, Object> e = i.next();
            if (e.getValue() instanceof Proxy) {
                ModificationProxy h = ModificationProxy.handler(e.getValue());
                if (h != null && !h.isDirty()) {
                    continue;
                }
            } else {
                try {
                    Object orig = ModificationProxy.unwrap(this.getter(e.getKey()).invoke(this.proxyObject, null));
                    if (orig == null ? e.getValue() == null : e.getValue() != null && orig.equals(e.getValue())) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            dirty = true;
        }
        return dirty;
    }

    List<String> getDirtyProperties() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String propertyName : this.properties().keySet()) {
            ModificationProxy h;
            Object value = this.properties.get(propertyName);
            if (value instanceof Proxy && (h = ModificationProxy.handler(value)) != null && !h.isDirty()) {
                Object curr = ModificationProxy.unwrap(value);
                try {
                    Object orig = ModificationProxy.unwrap(this.getter(propertyName).invoke(this.proxyObject, null));
                    if (curr == orig) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    public List<String> getPropertyNames() {
        List<String> propertyNames = this.getDirtyProperties();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String name = propertyNames.get(i);
            propertyNames.set(i, Character.toLowerCase(name.charAt(0)) + name.substring(1));
        }
        return propertyNames;
    }

    public List<Object> getOldValues() {
        ArrayList<Object> oldValues = new ArrayList<Object>();
        for (String propertyName : this.getDirtyProperties()) {
            if (this.oldCollectionValues().containsKey(propertyName)) {
                oldValues.add(this.oldCollectionValues.get(propertyName));
                continue;
            }
            try {
                Method g = this.getter(propertyName);
                if (g == null) {
                    throw new IllegalArgumentException("No such property: " + propertyName);
                }
                oldValues.add(g.invoke(this.proxyObject, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return oldValues;
    }

    public List<Object> getNewValues() {
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (String propertyName : this.getDirtyProperties()) {
            newValues.add(this.properties().get(propertyName));
        }
        return newValues;
    }

    Method getter(String propertyName) {
        Method g = null;
        try {
            g = this.proxyObject.getClass().getMethod("get" + propertyName, null);
        }
        catch (NoSuchMethodException e1) {
            try {
                g = this.proxyObject.getClass().getMethod("is" + propertyName, null);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        if (g == null) {
            g = this.cp().getter(propertyName, null);
        }
        return g;
    }

    Method setter(String propertyName, Class type) {
        Method s = null;
        try {
            s = this.proxyObject.getClass().getMethod("set" + propertyName, type);
        }
        catch (NoSuchMethodException e) {
            s = this.cp().setter(propertyName, type);
        }
        return s;
    }

    private Object readResolve() throws ObjectStreamException {
        Object clone;
        Object value;
        CatalogInfo replacement;
        if (this.proxyObject instanceof CatalogInfo && (replacement = this.replaceCatalogInfo((CatalogInfo)this.proxyObject)) != null) {
            this.proxyObject = ModificationProxy.unwrap(replacement);
        }
        if (this.properties != null) {
            for (Map.Entry<String, Object> property : this.properties.entrySet()) {
                value = property.getValue();
                if (value instanceof CatalogInfo) {
                    CatalogInfo replacement2 = this.replaceCatalogInfo((CatalogInfo)value);
                    if (replacement2 == null) continue;
                    property.setValue(ModificationProxy.unwrap(replacement2));
                    continue;
                }
                if (value instanceof Collection) {
                    clone = this.cloneCollection((Collection)value);
                    property.setValue(clone);
                    continue;
                }
                if (!(value instanceof MetadataMap)) continue;
                clone = this.cloneMetadataMap((MetadataMap)value);
                property.setValue(clone);
            }
        }
        if (this.oldCollectionValues != null) {
            for (Map.Entry<String, Object> oce : this.oldCollectionValues.entrySet()) {
                value = oce.getValue();
                if (value instanceof Collection) {
                    Collection oldCollection = (Collection)value;
                    Collection clone2 = this.cloneCollection(oldCollection);
                    oce.setValue(clone2);
                    continue;
                }
                if (!(value instanceof MetadataMap)) continue;
                clone = this.cloneMetadataMap((MetadataMap)value);
                oce.setValue(clone);
            }
        }
        return this;
    }

    private MetadataMap cloneMetadataMap(MetadataMap original) {
        MetadataMap clone = new MetadataMap();
        for (Map.Entry<String, Serializable> entry : original.entrySet()) {
            CatalogInfo replacement;
            String key = entry.getKey();
            Serializable value = entry.getValue();
            if (value instanceof CatalogInfo && (replacement = this.replaceCatalogInfo((CatalogInfo)value)) != null) {
                value = replacement;
            }
            clone.put(key, value);
        }
        return clone;
    }

    private Collection cloneCollection(Collection oldCollection) {
        Class<?> oldCollectionClass = oldCollection.getClass();
        try {
            Collection clone = (Collection)oldCollectionClass.newInstance();
            for (Object o : oldCollection) {
                if (o instanceof CatalogInfo) {
                    CatalogInfo replacement = this.replaceCatalogInfo((CatalogInfo)o);
                    if (replacement != null) {
                        clone.add(ModificationProxy.unwrap(replacement));
                        continue;
                    }
                    clone.add(o);
                    continue;
                }
                clone.add(o);
            }
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected failure while cloning collection of class " + oldCollectionClass, e);
        }
    }

    private CatalogInfo replaceCatalogInfo(CatalogInfo ci) {
        String id = ci.getId();
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Class iface = this.getCatalogInfoInterface(ci.getClass());
        Object replacement = catalog.get(iface, (Filter)ff.equal((Expression)ff.property("id"), (Expression)ff.literal((Object)id), true));
        return replacement;
    }

    private Class getCatalogInfoInterface(Class<? extends CatalogInfo> clazz) {
        Class result = CatalogInfo.class;
        for (Class<?> c : clazz.getInterfaces()) {
            if (!result.isAssignableFrom(c)) continue;
            result = c;
        }
        return result;
    }

    public static <T> T create(T proxyObject, Class<T> clazz) {
        return ProxyUtils.createProxy(proxyObject, clazz, new ModificationProxy(proxyObject));
    }

    public static <T> List<T> createList(List<T> proxyList, Class<T> clazz) {
        return new list<T>(proxyList, clazz);
    }

    public static <T> T unwrap(T object) {
        return ProxyUtils.unwrap(object, ModificationProxy.class);
    }

    public static ModificationProxy handler(Object object) {
        return ProxyUtils.handler(object, ModificationProxy.class);
    }

    static class list<T>
    extends ProxyList {
        list(List<T> list2, Class<T> clazz) {
            super(list2, clazz);
        }

        @Override
        protected <T> T createProxy(T proxyObject, Class<T> proxyInterface) {
            return ModificationProxy.create(proxyObject, proxyInterface);
        }

        protected <U> U unwrapProxy(U proxy, Class<U> proxyInterface) {
            return ModificationProxy.unwrap(proxy);
        }
    }
}

