/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.MetadataLinkInfo;

public class MetadataLinkInfoImpl
implements MetadataLinkInfo {
    String id;
    String type;
    String about;
    String metadataType;
    String content;
    static final List<String> protocols = Arrays.asList("http", "https", "ftp");

    public MetadataLinkInfoImpl() {
    }

    public MetadataLinkInfoImpl(MetadataLinkInfoImpl other) {
        this.id = other.id;
        this.type = other.type;
        this.about = other.about;
        this.metadataType = other.metadataType;
        this.content = other.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getAbout() {
        return this.about;
    }

    @Override
    public void setAbout(String about) {
        this.about = about;
    }

    @Override
    public String getMetadataType() {
        return this.metadataType;
    }

    @Override
    public void setMetadataType(String metadataType) {
        this.metadataType = metadataType;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public static void validate(String url) {
        URL dummy;
        if (url == null) {
            return;
        }
        try {
            dummy = new URL("http://dummy/");
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Could not parse dummy context URL", ex);
        }
        try {
            URL parsed = new URL(dummy, url);
            String protocol = parsed.getProtocol();
            parsed.toURI();
            if (!protocols.contains(protocol)) {
                throw new IllegalArgumentException("Protocol " + protocol + " is not supported in url " + url);
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException("Not a valid URL: " + url, ex);
        }
    }

    @Override
    public void setContent(String content) {
        MetadataLinkInfoImpl.validate(content);
        this.content = content;
    }

    private Object readResolve() {
        MetadataLinkInfoImpl.validate(this.content);
        return this;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.about == null ? 0 : this.about.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.metadataType == null ? 0 : this.metadataType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataLinkInfo)) {
            return false;
        }
        MetadataLinkInfo other = (MetadataLinkInfo)obj;
        if (this.about == null ? other.getAbout() != null : !this.about.equals(other.getAbout())) {
            return false;
        }
        if (this.content == null ? other.getContent() != null : !this.content.equals(other.getContent())) {
            return false;
        }
        if (this.metadataType == null ? other.getMetadataType() != null : !this.metadataType.equals(other.getMetadataType())) {
            return false;
        }
        return !(this.type == null ? other.getType() != null : !this.type.equals(other.getType()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type:" + this.type + ", metadataType:" + this.metadataType + ", content:" + this.content + ']';
    }
}

