/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Function;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.ValidationResult;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AbstractCatalogDecorator;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.impl.WrappingProxy;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.LocalWorkspace;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class LocalWorkspaceCatalog
extends AbstractCatalogDecorator
implements Catalog {
    private GeoServer geoServer;

    public LocalWorkspaceCatalog(Catalog delegate) {
        super(delegate);
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        StyleInfo style;
        if (LocalWorkspace.get() != null && (style = super.getStyleByName(LocalWorkspace.get(), name)) != null) {
            return style;
        }
        return super.getStyleByName(name);
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.wrap(super.getLayer(id));
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        if (LocalWorkspace.get() != null) {
            String wsName = LocalWorkspace.get().getName();
            if (name.contains(":") && name.startsWith(wsName + ":")) {
                return this.wrap(super.getLayerByName(name));
            }
            NamespaceInfo ns = super.getNamespaceByPrefix(LocalWorkspace.get().getName());
            LayerInfo layer = super.getLayerByName((Name)new NameImpl(ns.getURI(), name));
            return this.wrap(layer);
        }
        return super.getLayerByName(name);
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        if (LocalWorkspace.get() != null) {
            return this.getLayerByName(name.getLocalPart());
        }
        return super.getLayerByName(name);
    }

    @Override
    public List<LayerInfo> getLayers() {
        if (this.useNameDequalifyingProxy()) {
            return NameDequalifyingProxy.createList(super.getLayers(), LayerInfo.class);
        }
        return super.getLayers();
    }

    private boolean useNameDequalifyingProxy() {
        WorkspaceInfo workspaceInfo = LocalWorkspace.get();
        boolean hidePrefix = this.geoServer == null || !this.geoServer.getSettings().isLocalWorkspaceIncludesPrefix();
        boolean useNameDequalifyingProxy = workspaceInfo != null && hidePrefix;
        return useNameDequalifyingProxy;
    }

    @Override
    public void add(LayerInfo layer) {
        super.add(this.unwrap(layer));
    }

    @Override
    public void save(LayerInfo layer) {
        super.save(this.unwrap(layer));
    }

    @Override
    public void remove(LayerInfo layer) {
        super.remove(this.unwrap(layer));
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return super.detach(this.unwrap(layer));
    }

    @Override
    public ValidationResult validate(LayerInfo layer, boolean isNew) {
        return super.validate(this.unwrap(layer), isNew);
    }

    LayerInfo wrap(LayerInfo layer) {
        return this.wrap(layer, LayerInfo.class);
    }

    LayerInfo unwrap(LayerInfo layer) {
        return NameDequalifyingProxy.unwrap(layer);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.wrap(super.getLayerGroup(id));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        LayerGroupInfo layerGroup;
        if (LocalWorkspace.get() != null && (layerGroup = super.getLayerGroupByName(LocalWorkspace.get(), name)) != null) {
            return this.wrap(layerGroup);
        }
        return this.wrap(super.getLayerGroupByName(name));
    }

    LayerGroupInfo check(LayerGroupInfo layerGroup) {
        if (LocalWorkspace.get() != null && layerGroup.getWorkspace() != null && !LocalWorkspace.get().equals(layerGroup.getWorkspace())) {
            return null;
        }
        return layerGroup;
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String workspaceName, String name) {
        return this.wrap(super.getLayerGroupByName(workspaceName, name));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        return this.wrap(super.getLayerGroupByName(workspace, name));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.wrap(super.getLayerGroups());
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(String workspaceName) {
        return this.wrap(super.getLayerGroupsByWorkspace(workspaceName));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        return this.wrap(super.getLayerGroupsByWorkspace(workspace));
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        super.add(this.unwrap(layerGroup));
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        super.save(this.unwrap(layerGroup));
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        super.remove(this.unwrap(layerGroup));
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return super.detach(this.unwrap(layerGroup));
    }

    @Override
    public ValidationResult validate(LayerGroupInfo layerGroup, boolean isNew) {
        return super.validate(this.unwrap(layerGroup), isNew);
    }

    LayerGroupInfo wrap(LayerGroupInfo layerGroup) {
        return this.wrap(layerGroup, LayerGroupInfo.class);
    }

    <T> T wrap(T obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (this.useNameDequalifyingProxy()) {
            return NameDequalifyingProxy.create(obj, clazz);
        }
        return obj;
    }

    <T> T unwrap(T obj) {
        return NameDequalifyingProxy.unwrap(obj);
    }

    List<LayerGroupInfo> wrap(List<LayerGroupInfo> layerGroups) {
        if (LocalWorkspace.get() != null) {
            return NameDequalifyingProxy.createList(layerGroups, LayerGroupInfo.class);
        }
        return layerGroups;
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        return ((Catalog)this.delegate).count(of, filter);
    }

    @Override
    public <T extends CatalogInfo> T get(Class<T> type, Filter filter) throws IllegalArgumentException {
        return (T)((CatalogInfo)this.wrap(((Catalog)this.delegate).get(type, filter), type));
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter) {
        return this.list(of, filter, null, null, null);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(final Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortBy) {
        CloseableIterator<T> iterator = ((Catalog)this.delegate).list(of, filter, offset, count, sortBy);
        Function wrappingFunction = new Function<T, T>(){
            final Class<T> type;
            {
                this.type = of;
            }

            public T apply(T catalogObject) {
                return (CatalogInfo)LocalWorkspaceCatalog.this.wrap(catalogObject, this.type);
            }
        };
        return CloseableIteratorAdapter.transform(iterator, wrappingFunction);
    }

    @Override
    public void removeListeners(Class listenerClass) {
        ((Catalog)this.delegate).removeListeners(listenerClass);
    }

    static class NameDequalifyingProxy
    implements WrappingProxy,
    Serializable {
        Object object;

        NameDequalifyingProxy(Object object) {
            this.object = object;
        }

        @Override
        public Object getProxyObject() {
            return this.object;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("prefixedName".equals(method.getName()) || "getPrefixedName".equals(method.getName()) || "getName".equals(method.getName())) {
                String val = (String)method.invoke(this.object, args);
                if (val == null || val.indexOf(58) == -1) {
                    return val;
                }
                return val.split(":")[1];
            }
            return method.invoke(this.object, args);
        }

        public static <T> T create(T object, Class<T> clazz) {
            return ProxyUtils.createProxy(object, clazz, new NameDequalifyingProxy(object));
        }

        public static <T> List<T> createList(List<T> object, Class<T> clazz) {
            return new ProxyList(object, clazz){

                @Override
                protected <T> T createProxy(T proxyObject, Class<T> proxyInterface) {
                    return NameDequalifyingProxy.create(proxyObject, proxyInterface);
                }

                @Override
                protected <T> T unwrapProxy(T proxy, Class<T> proxyInterface) {
                    return NameDequalifyingProxy.unwrap(proxy);
                }
            };
        }

        public static <T> T unwrap(T object) {
            return ProxyUtils.unwrap(object, NameDequalifyingProxy.class);
        }
    }
}

