/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class LayerGroupInfoImpl
implements LayerGroupInfo {
    protected String id;
    protected String name;
    protected LayerGroupInfo.Mode mode = LayerGroupInfo.Mode.SINGLE;
    protected String title;
    protected String abstractTxt;
    protected WorkspaceInfo workspace;
    protected String path;
    protected LayerInfo rootLayer;
    protected StyleInfo rootLayerStyle;
    protected List<LayerInfo> layers = new ArrayList<LayerInfo>();
    protected List<PublishedInfo> publishables = new ArrayList<PublishedInfo>();
    protected List<StyleInfo> styles = new ArrayList<StyleInfo>();
    protected ReferencedEnvelope bounds;
    protected MetadataMap metadata = new MetadataMap();
    protected List<AuthorityURLInfo> authorityURLs = new ArrayList<AuthorityURLInfo>(2);
    protected List<LayerIdentifierInfo> identifiers = new ArrayList<LayerIdentifierInfo>(2);

    public LayerGroupInfoImpl() {
        this.mode = LayerGroupInfo.Mode.SINGLE;
        this.publishables = new ArrayList<PublishedInfo>();
        this.styles = new ArrayList<StyleInfo>();
        this.metadata = new MetadataMap();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LayerGroupInfo.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(LayerGroupInfo.Mode mode) {
        this.mode = mode;
    }

    @Override
    public String getTitle() {
        if (this.title == null && this.metadata != null) {
            this.title = this.metadata.get("title", String.class);
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAbstract() {
        if (this.abstractTxt == null && this.metadata != null) {
            this.abstractTxt = this.metadata.get("title", String.class);
        }
        return this.abstractTxt;
    }

    @Override
    public void setAbstract(String abstractTxt) {
        this.abstractTxt = abstractTxt;
    }

    @Override
    public WorkspaceInfo getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    @Override
    public String prefixedName() {
        return this.workspace != null ? this.workspace.getName() + ":" + this.name : this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public LayerInfo getRootLayer() {
        return this.rootLayer;
    }

    @Override
    public void setRootLayer(LayerInfo rootLayer) {
        this.rootLayer = rootLayer;
    }

    @Override
    public StyleInfo getRootLayerStyle() {
        return this.rootLayerStyle;
    }

    @Override
    public void setRootLayerStyle(StyleInfo style) {
        this.rootLayerStyle = style;
    }

    @Override
    public List<PublishedInfo> getLayers() {
        return this.publishables;
    }

    public void setLayers(List<PublishedInfo> publishables) {
        this.publishables = publishables;
    }

    public void convertLegacyLayers() {
        if (this.layers != null && this.publishables == null) {
            this.publishables = new ArrayList<PublishedInfo>();
            for (LayerInfo layer : this.layers) {
                this.publishables.add(layer);
            }
            this.layers = null;
        }
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.styles;
    }

    public void setStyles(List<StyleInfo> styles) {
        this.styles = styles;
    }

    @Override
    public List<LayerInfo> layers() {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allLayersForRendering();
    }

    @Override
    public List<StyleInfo> styles() {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allStylesForRendering();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    @Override
    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.publishables == null ? 0 : this.publishables.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.abstractTxt == null ? 0 : this.abstractTxt.hashCode());
        result = 31 * result + (this.workspace == null ? 0 : this.workspace.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.styles == null ? 0 : this.styles.hashCode());
        result = 31 * result + (this.rootLayer == null ? 0 : this.rootLayer.hashCode());
        result = 31 * result + (this.rootLayerStyle == null ? 0 : this.rootLayerStyle.hashCode());
        result = 31 * result + (this.authorityURLs == null ? 0 : this.authorityURLs.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerGroupInfo)) {
            return false;
        }
        LayerGroupInfo other = (LayerGroupInfo)obj;
        if (this.bounds == null ? other.getBounds() != null : !this.bounds.equals((Object)other.getBounds())) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.publishables == null ? other.getLayers() != null : !this.publishables.equals(other.getLayers())) {
            return false;
        }
        if (this.metadata == null ? other.getMetadata() != null : !this.metadata.equals(other.getMetadata())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.mode == null ? other.getMode() != null : !this.mode.equals((Object)other.getMode())) {
            return false;
        }
        if (this.title == null ? other.getTitle() != null : !this.title.equals(other.getTitle())) {
            return false;
        }
        if (this.abstractTxt == null ? other.getAbstract() != null : !this.abstractTxt.equals(other.getAbstract())) {
            return false;
        }
        if (this.workspace == null ? other.getWorkspace() != null : !this.workspace.equals(other.getWorkspace())) {
            return false;
        }
        if (this.styles == null ? other.getStyles() != null : !this.styles.equals(other.getStyles())) {
            return false;
        }
        if (this.authorityURLs == null ? other.getAuthorityURLs() != null : !this.authorityURLs.equals(other.getAuthorityURLs())) {
            return false;
        }
        if (this.identifiers == null ? other.getIdentifiers() != null : !this.identifiers.equals(other.getIdentifiers())) {
            return false;
        }
        if (this.rootLayer == null ? other.getRootLayer() != null : !this.rootLayer.equals(other.getRootLayer())) {
            return false;
        }
        return !(this.rootLayerStyle == null ? other.getRootLayerStyle() != null : !this.rootLayerStyle.equals(other.getRootLayerStyle()));
    }

    @Override
    public List<AuthorityURLInfo> getAuthorityURLs() {
        return this.authorityURLs;
    }

    public void setAuthorityURLs(List<AuthorityURLInfo> authorities) {
        this.authorityURLs = authorities;
    }

    @Override
    public List<LayerIdentifierInfo> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<LayerIdentifierInfo> identifiers) {
        this.identifiers = identifiers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ']';
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName();
    }

    @Override
    public PublishedType getType() {
        return PublishedType.GROUP;
    }
}

