/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiHashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AbstractCatalogFacade;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.ows.util.OwsUtils;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class DefaultCatalogFacade
extends AbstractCatalogFacade
implements CatalogFacade {
    protected MultiHashMap stores = new MultiHashMap();
    protected Map<String, DataStoreInfo> defaultStores = new HashMap<String, DataStoreInfo>();
    protected MultiHashMap resources = new MultiHashMap();
    protected HashMap<String, NamespaceInfo> namespaces = new HashMap();
    protected HashMap<String, WorkspaceInfo> workspaces = new HashMap();
    protected List<LayerInfo> layers = new CopyOnWriteArrayList<LayerInfo>();
    protected List<MapInfo> maps = new ArrayList<MapInfo>();
    protected List<LayerGroupInfo> layerGroups = new CopyOnWriteArrayList<LayerGroupInfo>();
    protected List<StyleInfo> styles = new CopyOnWriteArrayList<StyleInfo>();
    private CatalogImpl catalog;

    public DefaultCatalogFacade(Catalog catalog) {
        this.setCatalog(catalog);
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = (CatalogImpl)catalog;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreInfo add(StoreInfo store) {
        this.resolve(store);
        MultiHashMap multiHashMap = this.stores;
        synchronized (multiHashMap) {
            this.stores.put(store.getClass(), (Object)store);
        }
        return ModificationProxy.create(store, StoreInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StoreInfo store) {
        store = DefaultCatalogFacade.unwrap(store);
        MultiHashMap multiHashMap = this.stores;
        synchronized (multiHashMap) {
            this.stores.remove(store.getClass(), (Object)store);
        }
    }

    @Override
    public void save(StoreInfo store) {
        this.saved(store);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return store;
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        List<T> l = this.lookup(clazz, this.stores);
        for (StoreInfo store : l) {
            if (!id.equals(store.getId())) continue;
            return (T)ModificationProxy.create(store, clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        List<T> l = this.lookup(clazz, this.stores);
        if (workspace == ANY_WORKSPACE) {
            ArrayList<StoreInfo> matches = new ArrayList<StoreInfo>();
            for (StoreInfo store : l) {
                if (!name.equals(store.getName())) continue;
                matches.add(store);
            }
            if (matches.size() == 1) {
                return (T)ModificationProxy.create((StoreInfo)matches.get(0), clazz);
            }
        } else {
            for (StoreInfo store : l) {
                if (!name.equals(store.getName()) || !store.getWorkspace().equals(workspace)) continue;
                return (T)ModificationProxy.create(store, clazz);
            }
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        List<T> all = this.lookup(clazz, this.stores);
        ArrayList<StoreInfo> matches = new ArrayList<StoreInfo>();
        for (StoreInfo store : all) {
            if (!workspace.equals(store.getWorkspace())) continue;
            matches.add(store);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    public List getStores(Class clazz) {
        return ModificationProxy.createList(this.lookup(clazz, this.stores), clazz);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        if (this.defaultStores.containsKey(workspace.getId())) {
            DataStoreInfo defaultStore = this.defaultStores.get(workspace.getId());
            return ModificationProxy.create(defaultStore, DataStoreInfo.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo store) {
        DataStoreInfo old = this.defaultStores.get(workspace.getId());
        Map<String, DataStoreInfo> map = this.defaultStores;
        synchronized (map) {
            if (store != null) {
                this.defaultStores.put(workspace.getId(), store);
            } else {
                this.defaultStores.remove(workspace.getId());
            }
        }
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultDataStore"), (List)Arrays.asList(old), (List)Arrays.asList(store));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInfo add(ResourceInfo resource) {
        this.resolve(resource);
        MultiHashMap multiHashMap = this.resources;
        synchronized (multiHashMap) {
            this.resources.put(resource.getClass(), (Object)resource);
        }
        return ModificationProxy.create(resource, ResourceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ResourceInfo resource) {
        resource = DefaultCatalogFacade.unwrap(resource);
        MultiHashMap multiHashMap = this.resources;
        synchronized (multiHashMap) {
            this.resources.remove(resource.getClass(), (Object)resource);
        }
    }

    @Override
    public void save(ResourceInfo resource) {
        this.saved(resource);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return resource;
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        List<T> l = this.lookup(clazz, this.resources);
        for (ResourceInfo resource : l) {
            if (!id.equals(resource.getId())) continue;
            return (T)ModificationProxy.create(resource, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo namespace, String name, Class<T> clazz) {
        List<T> l = this.lookup(clazz, this.resources);
        if (namespace == ANY_NAMESPACE) {
            ArrayList<ResourceInfo> matches = new ArrayList<ResourceInfo>();
            for (ResourceInfo resource : l) {
                if (!name.equals(resource.getName())) continue;
                matches.add(resource);
            }
            if (matches.size() == 1) {
                return (T)ModificationProxy.create((ResourceInfo)matches.get(0), clazz);
            }
        } else {
            for (ResourceInfo resource : l) {
                NamespaceInfo namespace1;
                if (!name.equals(resource.getName()) || (namespace1 = resource.getNamespace()) == null || !namespace1.equals(namespace)) continue;
                return (T)ModificationProxy.create(resource, clazz);
            }
        }
        return null;
    }

    public List getResources(Class clazz) {
        return ModificationProxy.createList(this.lookup(clazz, this.resources), clazz);
    }

    public List getResourcesByNamespace(NamespaceInfo namespace, Class clazz) {
        List all = this.lookup(clazz, this.resources);
        ArrayList<ResourceInfo> matches = new ArrayList<ResourceInfo>();
        if (namespace == null) {
            namespace = this.getDefaultNamespace();
        }
        for (ResourceInfo resource : all) {
            if (namespace != null) {
                if (!namespace.equals(resource.getNamespace())) continue;
                matches.add(resource);
                continue;
            }
            if (resource.getNamespace() != null) continue;
            matches.add(resource);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        List<T> all = this.lookup(clazz, this.resources);
        for (ResourceInfo resource : all) {
            if (!name.equals(resource.getName()) || !store.equals(resource.getStore())) continue;
            return (T)ModificationProxy.create(resource, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        List<T> all = this.lookup(clazz, this.resources);
        ArrayList<ResourceInfo> matches = new ArrayList<ResourceInfo>();
        for (ResourceInfo resource : all) {
            if (!store.equals(resource.getStore())) continue;
            matches.add(resource);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public LayerInfo add(LayerInfo layer) {
        this.resolve(layer);
        this.layers.add(layer);
        return ModificationProxy.create(layer, LayerInfo.class);
    }

    @Override
    public void remove(LayerInfo layer) {
        this.layers.remove(DefaultCatalogFacade.unwrap(layer));
    }

    @Override
    public void save(LayerInfo layer) {
        this.saved(layer);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return layer;
    }

    @Override
    public LayerInfo getLayer(String id) {
        for (LayerInfo layer : this.layers) {
            if (!id.equals(layer.getId())) continue;
            return ModificationProxy.create(layer, LayerInfo.class);
        }
        return null;
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        for (LayerInfo layer : this.layers) {
            if (!name.equals(layer.getName())) continue;
            return ModificationProxy.create(layer, LayerInfo.class);
        }
        return null;
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        ArrayList<LayerInfo> matches = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.layers) {
            if (!resource.equals(layer.getResource())) continue;
            matches.add(layer);
        }
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        ArrayList<LayerInfo> matches = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.layers) {
            if (!style.equals(layer.getDefaultStyle()) && !layer.getStyles().contains(style)) continue;
            matches.add(layer);
        }
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers() {
        return ModificationProxy.createList(new ArrayList<LayerInfo>(this.layers), LayerInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapInfo add(MapInfo map) {
        this.resolve(map);
        List<MapInfo> list2 = this.maps;
        synchronized (list2) {
            this.maps.add(map);
        }
        return ModificationProxy.create(map, MapInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MapInfo map) {
        List<MapInfo> list2 = this.maps;
        synchronized (list2) {
            this.maps.remove(DefaultCatalogFacade.unwrap(map));
        }
    }

    @Override
    public void save(MapInfo map) {
        this.saved(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return map;
    }

    @Override
    public MapInfo getMap(String id) {
        for (MapInfo map : this.maps) {
            if (!id.equals(map.getId())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public MapInfo getMapByName(String name) {
        for (MapInfo map : this.maps) {
            if (!name.equals(map.getName())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public List<MapInfo> getMaps() {
        return ModificationProxy.createList(new ArrayList<MapInfo>(this.maps), MapInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LayerGroupInfo add(LayerGroupInfo layerGroup) {
        this.resolve(layerGroup);
        List<LayerGroupInfo> list2 = this.layerGroups;
        synchronized (list2) {
            this.layerGroups.add(layerGroup);
        }
        return ModificationProxy.create(layerGroup, LayerGroupInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(LayerGroupInfo layerGroup) {
        List<LayerGroupInfo> list2 = this.layerGroups;
        synchronized (list2) {
            this.layerGroups.remove(DefaultCatalogFacade.unwrap(layerGroup));
        }
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        this.saved(layerGroup);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return layerGroup;
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return ModificationProxy.createList(new ArrayList<LayerGroupInfo>(this.layerGroups), LayerGroupInfo.class);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        ArrayList<LayerGroupInfo> matches = new ArrayList<LayerGroupInfo>();
        for (LayerGroupInfo layerGroup : this.layerGroups) {
            boolean match = false;
            match = workspace == NO_WORKSPACE ? layerGroup.getWorkspace() == null : workspace.equals(layerGroup.getWorkspace());
            if (!match) continue;
            matches.add(layerGroup);
        }
        return ModificationProxy.createList(matches, LayerGroupInfo.class);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        for (LayerGroupInfo layerGroup : this.layerGroups) {
            if (!id.equals(layerGroup.getId())) continue;
            return ModificationProxy.create(layerGroup, LayerGroupInfo.class);
        }
        return null;
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.getLayerGroupByName(NO_WORKSPACE, name);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        ArrayList<LayerGroupInfo> matches = new ArrayList<LayerGroupInfo>(2);
        for (LayerGroupInfo layerGroup : this.layerGroups) {
            if (!name.equals(layerGroup.getName())) continue;
            WorkspaceInfo lgWorkspace = layerGroup.getWorkspace();
            if (NO_WORKSPACE == workspace) {
                if (lgWorkspace == null) {
                    matches.add(layerGroup);
                }
            } else if (ANY_WORKSPACE == workspace) {
                matches.add(layerGroup);
            } else if (lgWorkspace != null && workspace.equals(lgWorkspace)) {
                matches.add(layerGroup);
            }
            if (matches.size() <= 1) continue;
            break;
        }
        if (matches.size() == 1) {
            return ModificationProxy.create(matches.get(0), LayerGroupInfo.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceInfo add(NamespaceInfo namespace) {
        this.resolve(namespace);
        HashMap<String, NamespaceInfo> hashMap = this.namespaces;
        synchronized (hashMap) {
            this.namespaces.put(namespace.getPrefix(), namespace);
        }
        return ModificationProxy.create(namespace, NamespaceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(NamespaceInfo namespace) {
        HashMap<String, NamespaceInfo> hashMap = this.namespaces;
        synchronized (hashMap) {
            NamespaceInfo defaultNamespace = this.getDefaultNamespace();
            if (namespace.equals(defaultNamespace)) {
                this.namespaces.remove(null);
                this.namespaces.remove("default");
            }
            this.namespaces.remove(namespace.getPrefix());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(NamespaceInfo namespace) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(namespace);
        NamespaceInfo ns = (NamespaceInfo)h.getProxyObject();
        if (!namespace.getPrefix().equals(ns.getPrefix())) {
            HashMap<String, NamespaceInfo> hashMap = this.namespaces;
            synchronized (hashMap) {
                this.namespaces.remove(ns.getPrefix());
                this.namespaces.put(namespace.getPrefix(), ns);
            }
        }
        this.saved(namespace);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return namespace;
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.namespaces.get(null) != null ? ModificationProxy.create(this.namespaces.get(null), NamespaceInfo.class) : null;
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        NamespaceInfo ns = defaultNamespace != null ? this.namespaces.get(defaultNamespace.getPrefix()) : null;
        NamespaceInfo old = this.namespaces.get(null);
        if (ns != null) {
            this.namespaces.put(null, ns);
            this.namespaces.put("default", ns);
        } else {
            this.namespaces.remove(null);
            this.namespaces.remove("default");
        }
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultNamespace"), (List)Arrays.asList(old), (List)Arrays.asList(defaultNamespace));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        for (NamespaceInfo namespace : this.namespaces.values()) {
            if (!id.equals(namespace.getId())) continue;
            return ModificationProxy.create(namespace, NamespaceInfo.class);
        }
        return null;
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        NamespaceInfo ns = this.namespaces.get(prefix);
        return ns != null ? ModificationProxy.create(ns, NamespaceInfo.class) : null;
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        for (NamespaceInfo namespace : this.namespaces.values()) {
            if (!uri.equals(namespace.getURI())) continue;
            return ModificationProxy.create(namespace, NamespaceInfo.class);
        }
        return null;
    }

    public List getNamespaces() {
        ArrayList<NamespaceInfo> ns = new ArrayList<NamespaceInfo>();
        for (Map.Entry<String, NamespaceInfo> e : this.namespaces.entrySet()) {
            if (e.getKey() == null || e.getKey().equals("default")) continue;
            ns.add(e.getValue());
        }
        return ModificationProxy.createList(ns, NamespaceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkspaceInfo add(WorkspaceInfo workspace) {
        this.resolve(workspace);
        HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
        synchronized (hashMap) {
            this.workspaces.put(workspace.getName(), workspace);
        }
        return ModificationProxy.create(workspace, WorkspaceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(WorkspaceInfo workspace) {
        HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
        synchronized (hashMap) {
            this.workspaces.remove(workspace.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkspaceInfo workspace) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(workspace);
        WorkspaceInfo ws = (WorkspaceInfo)h.getProxyObject();
        if (!workspace.getName().equals(ws.getName())) {
            HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
            synchronized (hashMap) {
                this.workspaces.remove(ws.getName());
                this.workspaces.put(workspace.getName(), ws);
            }
        }
        this.saved(workspace);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return workspace;
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.workspaces.containsKey(null) ? ModificationProxy.create(this.workspaces.get(null), WorkspaceInfo.class) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        WorkspaceInfo old = this.workspaces.get(null);
        HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
        synchronized (hashMap) {
            if (workspace != null) {
                WorkspaceInfo ws = this.workspaces.get(workspace.getName());
                this.workspaces.put(null, ws);
                this.workspaces.put("default", ws);
            } else {
                this.workspaces.remove(null);
                this.workspaces.remove("default");
            }
        }
        this.catalog.fireModified((CatalogInfo)this.catalog, (List)Arrays.asList("defaultWorkspace"), (List)Arrays.asList(old), (List)Arrays.asList(workspace));
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        ArrayList<WorkspaceInfo> ws = new ArrayList<WorkspaceInfo>();
        for (Map.Entry<String, WorkspaceInfo> e : this.workspaces.entrySet()) {
            if (e.getKey() == null || e.getKey().equals("default")) continue;
            ws.add(e.getValue());
        }
        return ModificationProxy.createList(ws, WorkspaceInfo.class);
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        for (WorkspaceInfo ws : this.workspaces.values()) {
            if (!id.equals(ws.getId())) continue;
            return ModificationProxy.create(ws, WorkspaceInfo.class);
        }
        return null;
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.workspaces.containsKey(name) ? ModificationProxy.create(this.workspaces.get(name), WorkspaceInfo.class) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleInfo add(StyleInfo style) {
        this.resolve(style);
        List<StyleInfo> list2 = this.styles;
        synchronized (list2) {
            this.styles.add(style);
        }
        return ModificationProxy.create(style, StyleInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StyleInfo style) {
        List<StyleInfo> list2 = this.styles;
        synchronized (list2) {
            this.styles.remove(DefaultCatalogFacade.unwrap(style));
        }
    }

    @Override
    public void save(StyleInfo style) {
        this.saved(style);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return style;
    }

    @Override
    public StyleInfo getStyle(String id) {
        for (StyleInfo style : this.styles) {
            if (!id.equals(style.getId())) continue;
            return ModificationProxy.create(style, StyleInfo.class);
        }
        return null;
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        for (StyleInfo style : this.styles) {
            if (null != style.getWorkspace() || !name.equals(style.getName())) continue;
            return ModificationProxy.create(style, StyleInfo.class);
        }
        return null;
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        if (null == workspace) {
            throw new NullPointerException("workspace");
        }
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (workspace == ANY_WORKSPACE) {
            ArrayList<StyleInfo> matches = new ArrayList<StyleInfo>();
            for (StyleInfo style : this.styles) {
                if (!name.equals(style.getName())) continue;
                matches.add(style);
            }
            if (matches.size() == 1) {
                return ModificationProxy.create(matches.get(0), StyleInfo.class);
            }
        } else {
            for (StyleInfo style : this.styles) {
                if (!name.equals(style.getName()) || (style.getWorkspace() == null || !style.getWorkspace().equals(workspace)) && (style.getWorkspace() != null || workspace != NO_WORKSPACE)) continue;
                return ModificationProxy.create(style, StyleInfo.class);
            }
        }
        return null;
    }

    @Override
    public List<StyleInfo> getStyles() {
        return ModificationProxy.createList(new ArrayList<StyleInfo>(this.styles), StyleInfo.class);
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        ArrayList<StyleInfo> matches = new ArrayList<StyleInfo>();
        for (StyleInfo style : this.styles) {
            boolean match = false;
            match = workspace == NO_WORKSPACE ? style.getWorkspace() == null : workspace.equals(style.getWorkspace());
            if (!match) continue;
            matches.add(style);
        }
        return ModificationProxy.createList(matches, StyleInfo.class);
    }

    <T> List<T> lookup(Class<T> clazz, MultiHashMap map) {
        ArrayList result = new ArrayList();
        for (Class key : map.keySet()) {
            Collection value;
            if (!clazz.isAssignableFrom(key) || (value = map.getCollection((Object)key)) == null) continue;
            result.addAll(value);
        }
        return result;
    }

    @Override
    public void dispose() {
        if (this.stores != null) {
            this.stores.clear();
        }
        if (this.defaultStores != null) {
            this.defaultStores.clear();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (this.layers != null) {
            this.layers.clear();
        }
        if (this.layerGroups != null) {
            this.layerGroups.clear();
        }
        if (this.maps != null) {
            this.maps.clear();
        }
        if (this.styles != null) {
            this.styles.clear();
        }
    }

    @Override
    public void resolve() {
        if (this.workspaces == null) {
            this.workspaces = new HashMap();
        }
        for (WorkspaceInfo ws : this.workspaces.values()) {
            this.resolve(ws);
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        for (NamespaceInfo ns : this.namespaces.values()) {
            this.resolve(ns);
        }
        if (this.stores == null) {
            this.stores = new MultiHashMap();
        }
        for (CatalogInfo o : this.stores.values()) {
            this.resolve((StoreInfoImpl)o);
        }
        if (this.styles == null) {
            this.styles = new ArrayList<StyleInfo>();
        }
        for (StyleInfo s : this.styles) {
            this.resolve(s);
        }
        if (this.resources == null) {
            this.resources = new MultiHashMap();
        }
        for (CatalogInfo o : this.resources.values()) {
            this.resolve((ResourceInfo)o);
        }
        if (this.layers == null) {
            this.layers = new CopyOnWriteArrayList<LayerInfo>();
        }
        for (LayerInfo l : this.layers) {
            this.resolve(l);
        }
        if (this.layerGroups == null) {
            this.layerGroups = new ArrayList<LayerGroupInfo>();
        }
        for (LayerGroupInfo lg : this.layerGroups) {
            this.resolve(lg);
        }
        if (this.maps == null) {
            this.maps = new ArrayList<MapInfo>();
        }
        for (MapInfo m : this.maps) {
            this.resolve(m);
        }
    }

    @Override
    public void syncTo(CatalogFacade dao) {
        if (dao instanceof DefaultCatalogFacade) {
            DefaultCatalogFacade other = (DefaultCatalogFacade)dao;
            other.stores = this.stores;
            other.defaultStores = this.defaultStores;
            other.resources = this.resources;
            other.namespaces = this.namespaces;
            other.workspaces = this.workspaces;
            other.layers = this.layers;
            other.maps = this.maps;
            other.layerGroups = this.layerGroups;
            other.styles = this.styles;
        } else {
            Collection val;
            for (Map.Entry<String, WorkspaceInfo> entry : this.workspaces.entrySet()) {
                if (entry.getKey() == null || "default".equals(entry.getKey())) continue;
                dao.add(entry.getValue());
            }
            for (Map.Entry<String, CatalogInfo> entry : this.namespaces.entrySet()) {
                if (entry.getKey() == null || "default".equals(entry.getKey())) continue;
                dao.add((NamespaceInfo)entry.getValue());
            }
            for (Class clazz : this.stores.keySet()) {
                val = this.stores.getCollection((Object)clazz);
                for (StoreInfo s : val) {
                    dao.add(s);
                }
            }
            for (Class clazz : this.resources.keySet()) {
                val = this.resources.getCollection((Object)clazz);
                for (ResourceInfo r : val) {
                    dao.add(r);
                }
            }
            for (StyleInfo styleInfo : this.styles) {
                dao.add(styleInfo);
            }
            for (LayerInfo layerInfo : this.layers) {
                dao.add(layerInfo);
            }
            for (LayerGroupInfo layerGroupInfo : this.layerGroups) {
                dao.add(layerGroupInfo);
            }
            for (MapInfo mapInfo : this.maps) {
                dao.add(mapInfo);
            }
            if (this.workspaces.containsKey(null)) {
                dao.setDefaultWorkspace(this.workspaces.get(null));
            }
            if (this.namespaces.containsKey(null)) {
                dao.setDefaultNamespace(this.namespaces.get(null));
            }
            for (Map.Entry entry : this.defaultStores.entrySet()) {
                WorkspaceInfo ws = this.workspaces.get(entry.getKey());
                if (null == ws) continue;
                dao.setDefaultDataStore(ws, (DataStoreInfo)entry.getValue());
            }
        }
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        return Iterables.size(this.iterable(of, filter, null));
    }

    @Override
    public boolean canSort(Class<? extends CatalogInfo> type, String propertyName) {
        String[] path = propertyName.split("\\.");
        Class<CatalogInfo> clazz = type;
        for (int i = 0; i < path.length; ++i) {
            Method getter;
            String property = path[i];
            try {
                getter = OwsUtils.getter(clazz, (String)property, null);
            }
            catch (RuntimeException e) {
                return false;
            }
            clazz = getter.getReturnType();
            if (i != path.length - 1) continue;
            boolean primitive = clazz.isPrimitive();
            boolean comparable = Comparable.class.isAssignableFrom(clazz);
            boolean canSort = primitive || comparable;
            return canSort;
        }
        throw new IllegalStateException("empty property name");
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, @Nullable Integer offset, @Nullable Integer count, @Nullable SortBy sortOrder) {
        SortBy[] sortOrderList = null;
        if (sortOrder != null) {
            sortOrderList = new SortBy[]{sortOrder};
        }
        return this.list(of, filter, offset, count, sortOrderList);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, @Nullable Integer offset, @Nullable Integer count, SortBy ... sortOrder) {
        if (sortOrder != null) {
            for (SortBy so : sortOrder) {
                if (sortOrder == null || this.canSort(of, so.getPropertyName().getPropertyName())) continue;
                throw new IllegalArgumentException("Can't sort objects of type " + of.getName() + " by " + so.getPropertyName());
            }
        }
        Iterable iterable = this.iterable(of, filter, sortOrder);
        if (offset != null && offset > 0) {
            iterable = Iterables.skip(iterable, (int)offset);
        }
        if (count != null && count >= 0) {
            iterable = Iterables.limit((Iterable)iterable, (int)count);
        }
        Iterator<T> iterator = iterable.iterator();
        return new CloseableIteratorAdapter<T>(iterator);
    }

    public <T extends CatalogInfo> Iterable<T> iterable(Class<? super T> of, final Filter filter, SortBy[] sortByList) {
        List<MapInfo> all;
        Object t = null;
        if (NamespaceInfo.class.isAssignableFrom(of)) {
            all = this.getNamespaces();
        } else if (WorkspaceInfo.class.isAssignableFrom(of)) {
            all = this.getWorkspaces();
        } else if (StoreInfo.class.isAssignableFrom(of)) {
            all = this.getStores((Class)of);
        } else if (ResourceInfo.class.isAssignableFrom(of)) {
            all = this.getResources((Class)of);
        } else if (LayerInfo.class.isAssignableFrom(of)) {
            all = this.getLayers();
        } else if (LayerGroupInfo.class.isAssignableFrom(of)) {
            all = this.getLayerGroups();
        } else if (PublishedInfo.class.isAssignableFrom(of)) {
            all = new ArrayList<LayerInfo>();
            all.addAll(this.getLayers());
            all.addAll(this.getLayerGroups());
        } else if (StyleInfo.class.isAssignableFrom(of)) {
            all = this.getStyles();
        } else if (MapInfo.class.isAssignableFrom(of)) {
            all = this.getMaps();
        } else {
            throw new IllegalArgumentException("Unknown type: " + of);
        }
        if (null != sortByList) {
            for (int i = sortByList.length - 1; i >= 0; --i) {
                SortBy sortBy = sortByList[i];
                Ordering ordering = Ordering.from(this.comparator(sortBy));
                if (SortOrder.DESCENDING.equals((Object)sortBy.getSortOrder())) {
                    ordering = ordering.reverse();
                }
                all = ordering.sortedCopy(all);
            }
        }
        if (Filter.INCLUDE.equals(filter)) {
            return all;
        }
        Predicate filterAdapter = new Predicate<T>(){

            public boolean apply(T input) {
                return filter.evaluate(input);
            }
        };
        return Iterables.filter(all, (Predicate)filterAdapter);
    }

    private Comparator<Object> comparator(final SortBy sortOrder) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object v1 = OwsUtils.get((Object)o1, (String)sortOrder.getPropertyName().getPropertyName());
                Object v2 = OwsUtils.get((Object)o2, (String)sortOrder.getPropertyName().getPropertyName());
                if (v1 == null) {
                    if (v2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                Comparable c1 = (Comparable)v1;
                Comparable c2 = (Comparable)v2;
                return c1.compareTo(c2);
            }
        };
    }
}

