/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.MapInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;

public enum ClassMappings {
    WORKSPACE{

        public Class getInterface() {
            return WorkspaceInfo.class;
        }

        public Class getImpl() {
            return WorkspaceInfoImpl.class;
        }
    }
    ,
    NAMESPACE{

        public Class getInterface() {
            return NamespaceInfo.class;
        }

        public Class getImpl() {
            return NamespaceInfoImpl.class;
        }
    }
    ,
    DATASTORE{

        public Class getInterface() {
            return DataStoreInfo.class;
        }

        public Class getImpl() {
            return DataStoreInfoImpl.class;
        }
    }
    ,
    COVERAGESTORE{

        public Class getInterface() {
            return CoverageStoreInfo.class;
        }

        public Class getImpl() {
            return CoverageStoreInfoImpl.class;
        }
    }
    ,
    WMSSTORE{

        public Class getInterface() {
            return WMSStoreInfo.class;
        }

        public Class getImpl() {
            return WMSStoreInfoImpl.class;
        }
    }
    ,
    STORE{

        public Class getInterface() {
            return StoreInfo.class;
        }

        public Class getImpl() {
            return StoreInfoImpl.class;
        }

        public Class<? extends CatalogInfo>[] concreteInterfaces() {
            return new Class[]{CoverageStoreInfo.class, DataStoreInfo.class, WMSStoreInfo.class};
        }
    }
    ,
    FEATURETYPE{

        public Class getInterface() {
            return FeatureTypeInfo.class;
        }

        public Class getImpl() {
            return FeatureTypeInfoImpl.class;
        }
    }
    ,
    COVERAGE{

        public Class getInterface() {
            return CoverageInfo.class;
        }

        public Class getImpl() {
            return CoverageInfoImpl.class;
        }
    }
    ,
    WMSLAYER{

        public Class getInterface() {
            return WMSLayerInfo.class;
        }

        public Class getImpl() {
            return WMSLayerInfoImpl.class;
        }
    }
    ,
    RESOURCE{

        public Class getInterface() {
            return ResourceInfo.class;
        }

        public Class getImpl() {
            return ResourceInfoImpl.class;
        }

        public Class<? extends CatalogInfo>[] concreteInterfaces() {
            return new Class[]{CoverageInfo.class, FeatureTypeInfo.class, WMSLayerInfo.class};
        }
    }
    ,
    PUBLISHED{

        public Class getInterface() {
            return PublishedInfo.class;
        }

        public Class getImpl() {
            return null;
        }

        public Class<? extends CatalogInfo>[] concreteInterfaces() {
            return new Class[]{LayerInfo.class, LayerGroupInfo.class};
        }
    }
    ,
    LAYER{

        public Class getInterface() {
            return LayerInfo.class;
        }

        public Class getImpl() {
            return LayerInfoImpl.class;
        }
    }
    ,
    LAYERGROUP{

        public Class getInterface() {
            return LayerGroupInfo.class;
        }

        public Class getImpl() {
            return LayerGroupInfoImpl.class;
        }
    }
    ,
    MAP{

        public Class getInterface() {
            return MapInfo.class;
        }

        public Class getImpl() {
            return MapInfoImpl.class;
        }
    }
    ,
    STYLE{

        public Class getInterface() {
            return StyleInfo.class;
        }

        public Class getImpl() {
            return StyleInfoImpl.class;
        }
    }
    ,
    GLOBAL{

        public Class getInterface() {
            return GeoServerInfo.class;
        }

        public Class getImpl() {
            return GeoServerInfoImpl.class;
        }
    }
    ,
    LOGGING{

        public Class getInterface() {
            return LoggingInfo.class;
        }

        public Class getImpl() {
            return LoggingInfoImpl.class;
        }
    }
    ,
    SETTINGS{

        public Class getInterface() {
            return SettingsInfo.class;
        }

        public Class getImpl() {
            return SettingsInfoImpl.class;
        }
    }
    ,
    SERVICE{

        public Class getInterface() {
            return ServiceInfo.class;
        }

        public Class getImpl() {
            return ServiceInfoImpl.class;
        }
    };


    public abstract <T> Class<T> getInterface();

    public abstract Class<? extends Info> getImpl();

    public Class<? extends Info>[] concreteInterfaces() {
        Class interf = this.getInterface();
        return new Class[]{interf};
    }

    public static ClassMappings fromInterface(Class<? extends Info> interfce) {
        if (ServiceInfo.class.isAssignableFrom(interfce)) {
            return SERVICE;
        }
        for (ClassMappings cm : ClassMappings.values()) {
            if (!interfce.equals(cm.getInterface())) continue;
            return cm;
        }
        return null;
    }

    public static ClassMappings fromImpl(Class<?> clazz) {
        if (ServiceInfo.class.isAssignableFrom(clazz)) {
            return SERVICE;
        }
        for (ClassMappings cm : ClassMappings.values()) {
            if (clazz != cm.getImpl()) continue;
            return cm;
        }
        return null;
    }
}

