/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.LinkedHashSet;
import java.util.List;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.ows.util.OwsUtils;

public abstract class AbstractCatalogFacade
implements CatalogFacade {
    public static final WorkspaceInfo _ANY_WORKSPACE = AbstractCatalogFacade.any(WorkspaceInfo.class);
    public static final NamespaceInfo _ANY_NAMESPACE = AbstractCatalogFacade.any(NamespaceInfo.class);
    public static final WorkspaceInfo _NO_WORKSPACE = AbstractCatalogFacade.any(WorkspaceInfo.class);

    static <T extends CatalogInfo> T any(Class<T> clazz) {
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
        try {
            return (T)((CatalogInfo)proxyClass.getConstructor(InvocationHandler.class).newInstance(new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    @Deprecated
    protected void saved(CatalogInfo object) {
        this.beforeSaved(object);
        this.commitProxy(object);
        this.afterSaved(object);
    }

    protected void beforeSaved(CatalogInfo object) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(object);
        CatalogInfo real = (CatalogInfo)h.getProxyObject();
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.getCatalog().fireModified(real, propertyNames, oldValues, newValues);
    }

    protected <T extends CatalogInfo> T commitProxy(T object) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(object);
        CatalogInfo real = (CatalogInfo)h.getProxyObject();
        h.commit();
        return (T)real;
    }

    protected void afterSaved(CatalogInfo object) {
        CatalogInfo real = ModificationProxy.unwrap(object);
        this.getCatalog().firePostModified(real);
    }

    protected void resolve(LayerInfo layer) {
        StyleInfo style;
        this.setId(layer);
        ResourceInfo resource = ResolvingProxy.resolve(this.getCatalog(), layer.getResource());
        if (resource != null) {
            resource = AbstractCatalogFacade.unwrap(resource);
            layer.setResource(resource);
        }
        if ((style = ResolvingProxy.resolve(this.getCatalog(), layer.getDefaultStyle())) != null) {
            style = AbstractCatalogFacade.unwrap(style);
            layer.setDefaultStyle(style);
        }
        LinkedHashSet<StyleInfo> styles = new LinkedHashSet<StyleInfo>();
        for (StyleInfo s : layer.getStyles()) {
            s = ResolvingProxy.resolve(this.getCatalog(), s);
            s = AbstractCatalogFacade.unwrap(s);
            styles.add(s);
        }
        ((LayerInfoImpl)layer).setStyles(styles);
    }

    protected void resolve(LayerGroupInfo layerGroup) {
        CatalogInfo resolved;
        int i;
        this.setId(layerGroup);
        LayerGroupInfoImpl lg = (LayerGroupInfoImpl)layerGroup;
        for (i = 0; i < lg.getLayers().size(); ++i) {
            PublishedInfo l = lg.getLayers().get(i);
            resolved = l instanceof LayerGroupInfo ? (PublishedInfo)AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), (LayerGroupInfo)l)) : (PublishedInfo)AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), (LayerInfo)l));
            lg.getLayers().set(i, (PublishedInfo)(resolved != null ? resolved : l));
        }
        for (i = 0; i < lg.getStyles().size(); ++i) {
            StyleInfo s = lg.getStyles().get(i);
            if (s == null) continue;
            resolved = AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), s));
            lg.getStyles().set(i, (StyleInfo)resolved);
        }
    }

    protected void resolve(StyleInfo style) {
        this.setId(style);
    }

    protected void resolve(MapInfo map) {
        this.setId(map);
    }

    protected void resolve(WorkspaceInfo workspace) {
        this.setId(workspace);
    }

    protected void resolve(NamespaceInfo namespace) {
        this.setId(namespace);
    }

    protected void resolve(StoreInfo store) {
        this.setId(store);
        StoreInfoImpl s = (StoreInfoImpl)store;
        WorkspaceInfo resolved = ResolvingProxy.resolve(this.getCatalog(), s.getWorkspace());
        if (resolved != null) {
            resolved = AbstractCatalogFacade.unwrap(resolved);
            s.setWorkspace(resolved);
        } else {
            System.out.println("this means the workspace has not yet been added to the catalog, keep the proxy around");
        }
    }

    protected void resolve(ResourceInfo resource) {
        NamespaceInfo namespace;
        this.setId(resource);
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        StoreInfo store = ResolvingProxy.resolve(this.getCatalog(), r.getStore());
        if (store != null) {
            store = AbstractCatalogFacade.unwrap(store);
            r.setStore(store);
        }
        if ((namespace = ResolvingProxy.resolve(this.getCatalog(), r.getNamespace())) != null) {
            namespace = AbstractCatalogFacade.unwrap(namespace);
            r.setNamespace(namespace);
        }
    }

    protected void setId(Object o) {
        if (OwsUtils.get((Object)o, (String)"id") == null) {
            String uid = new UID().toString();
            OwsUtils.set((Object)o, (String)"id", (Object)(o.getClass().getSimpleName() + "-" + uid));
        }
    }
}

