/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.data.DataAccess;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class VirtualTableCallback
implements FeatureTypeCallback {
    @Override
    public boolean canHandle(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) {
        return dataAccess instanceof JDBCDataStore && info.getMetadata() != null && info.getMetadata().get("JDBC_VIRTUAL_TABLE") instanceof VirtualTable;
    }

    @Override
    public boolean initialize(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) throws IOException {
        JDBCDataStore jstore = (JDBCDataStore)dataAccess;
        VirtualTable vt = info.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class);
        SimpleFeatureType ft = null;
        if (jstore.getVirtualTables().containsValue(vt)) {
            ft = jstore.getSchema(vt.getName());
            if (!jstore.getVirtualTables().containsValue(vt)) {
                ft = null;
            }
        }
        if (ft == null) {
            if (temporaryName != null) {
                jstore.createVirtualTable(new VirtualTable(temporaryName.getLocalPart(), vt));
                return true;
            }
            jstore.createVirtualTable(vt);
        }
        return false;
    }

    @Override
    public void flush(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) throws IOException {
    }

    @Override
    public void dispose(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) throws IOException {
        JDBCDataStore ds = (JDBCDataStore)dataAccess;
        if (temporaryName != null) {
            ds.dropVirtualTable(temporaryName.getLocalPart());
        } else {
            ds.dropVirtualTable(info.getNativeName());
        }
    }
}

