/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.StyleType;
import org.geoserver.platform.resource.Resource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.xml.sax.EntityResolver;

public abstract class StyleHandler {
    protected static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    String name;
    String format;

    protected StyleHandler(String name, String format) {
        this.name = name;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public List<Version> getVersions() {
        return Arrays.asList(new Version("1.0.0"));
    }

    public String getFileExtension() {
        return this.getFormat();
    }

    public String getCodeMirrorEditMode() {
        return this.getFormat();
    }

    public String getStyle(StyleType type, Color color, String colorName, String layerName) {
        throw new UnsupportedOperationException();
    }

    public abstract StyledLayerDescriptor parse(Object var1, Version var2, ResourceLocator var3, EntityResolver var4) throws IOException;

    public abstract void encode(StyledLayerDescriptor var1, Version var2, boolean var3, OutputStream var4) throws IOException;

    public abstract List<Exception> validate(Object var1, Version var2, EntityResolver var3) throws IOException;

    public abstract String mimeType(Version var1);

    public Version versionForMimeType(String mimeType) {
        return new Version("1.0.0");
    }

    public Version version(Object input) throws IOException {
        return new Version("1.0.0");
    }

    protected Reader toReader(Object input) throws IOException {
        if (input instanceof Reader) {
            return (Reader)input;
        }
        if (input instanceof InputStream) {
            return new InputStreamReader((InputStream)input);
        }
        if (input instanceof String) {
            return new StringReader((String)input);
        }
        if (input instanceof File) {
            return new FileReader((File)input);
        }
        if (input instanceof Resource) {
            return this.toReader(((Resource)input).in());
        }
        throw new IllegalArgumentException("Unable to turn " + input + " into reader");
    }
}

