/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.StyleType;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.styling.StyledLayerDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class StyleGenerator {
    private ColorRamp ramp;
    private Catalog catalog;
    private WorkspaceInfo workspace;

    public StyleGenerator(Catalog catalog) {
        this.catalog = catalog;
        this.ramp = new ColorRamp();
        this.ramp.add("red", Color.decode("0xFF3300"));
        this.ramp.add("orange", Color.decode("0xFF6600"));
        this.ramp.add("dark orange", Color.decode("0xFF9900"));
        this.ramp.add("gold", Color.decode("0xFFCC00"));
        this.ramp.add("yellow", Color.decode("0xFFFF00"));
        this.ramp.add("dark yellow", Color.decode("0x99CC00"));
        this.ramp.add("teal", Color.decode("0x00CC33"));
        this.ramp.add("cyan", Color.decode("0x0099CC"));
        this.ramp.add("azure", Color.decode("0x0033CC"));
        this.ramp.add("violet", Color.decode("0x3300FF"));
        this.randomizeRamp();
    }

    protected void randomizeRamp() {
        this.ramp.initRandom();
    }

    public StyleGenerator(Catalog catalog, ColorRamp ramp) {
        if (ramp == null) {
            throw new NullPointerException("The color ramp cannot be null");
        }
        this.ramp = ramp;
        this.catalog = catalog;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public StyleInfo createStyle(StyleHandler handler, FeatureTypeInfo featureType) throws IOException {
        return this.createStyle(handler, featureType, featureType.getFeatureType());
    }

    public StyleInfo createStyle(StyleHandler handler, FeatureTypeInfo featureType, FeatureType nativeFeatureType) throws IOException {
        GeometryDescriptor gd = nativeFeatureType.getGeometryDescriptor();
        if (gd == null) {
            return this.catalog.getStyleByName("point");
        }
        Class gtype = gd.getType().getBinding();
        StyleType st = LineString.class.isAssignableFrom(gtype) || MultiLineString.class.isAssignableFrom(gtype) ? StyleType.LINE : (Polygon.class.isAssignableFrom(gtype) || MultiPolygon.class.isAssignableFrom(gtype) ? StyleType.POLYGON : (Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? StyleType.POINT : StyleType.GENERIC));
        return this.doCreateStyle(handler, st, featureType);
    }

    public StyleInfo createStyle(StyleHandler handler, CoverageInfo coverage) throws IOException {
        return this.doCreateStyle(handler, StyleType.RASTER, coverage);
    }

    public String generateStyle(StyleHandler handler, StyleType styleType, String layerName) throws IOException {
        ColorRamp.Entry color = this.ramp.next();
        try {
            return handler.getStyle(styleType, color.color, color.name, layerName);
        }
        catch (UnsupportedOperationException e) {
            SLDHandler sldHandler = new SLDHandler();
            String sldTemplate = handler.getStyle(styleType, color.color, color.name, layerName);
            StyledLayerDescriptor sld = sldHandler.parse(sldTemplate, null, null, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            handler.encode(sld, null, true, out);
            return out.toString();
        }
    }

    StyleInfo doCreateStyle(StyleHandler handler, StyleType styleType, ResourceInfo resource) throws IOException {
        String styleName = this.workspace != null ? this.findUniqueStyleName(resource, this.workspace) : this.findUniqueStyleName(resource);
        String styleData = this.generateStyle(handler, styleType, styleName);
        StyleInfo style = this.catalog.getFactory().createStyle();
        style.setName(styleName);
        style.setFilename(styleName + "." + handler.getFileExtension());
        if (this.workspace != null) {
            style.setWorkspace(this.workspace);
        }
        this.catalog.getResourcePool().writeStyle(style, new ByteArrayInputStream(styleData.getBytes()));
        return style;
    }

    String findUniqueStyleName(ResourceInfo resource) {
        String styleName = resource.getStore().getWorkspace().getName() + "_" + resource.getName();
        StyleInfo style = this.catalog.getStyleByName(styleName);
        int i = 1;
        while (style != null) {
            styleName = resource.getStore().getWorkspace().getName() + "_" + resource.getName() + i;
            style = this.catalog.getStyleByName(styleName);
            ++i;
        }
        return styleName;
    }

    String findUniqueStyleName(ResourceInfo resource, WorkspaceInfo workspace) {
        String styleName = resource.getName();
        StyleInfo style = this.catalog.getStyleByName(workspace, styleName);
        int i = 1;
        while (style != null) {
            styleName = resource.getName() + i;
            style = this.catalog.getStyleByName(workspace, styleName);
            ++i;
        }
        return styleName;
    }

    public static class ColorRamp {
        List<Entry> entries = new ArrayList<Entry>();
        int position;

        public void add(String name, Color color) {
            this.entries.add(new Entry(name, color));
        }

        public Entry next() {
            this.position = (this.position + 1) % this.entries.size();
            return this.entries.get(this.position);
        }

        public void initRandom() {
            this.position = (int)((double)this.entries.size() * Math.random());
        }

        static class Entry {
            String name;
            Color color;

            Entry(String name, Color color) {
                this.name = name;
                this.color = color;
            }
        }
    }
}

