/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewReader;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class StructuredCoverageViewReader
extends CoverageViewReader
implements StructuredGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(StructuredCoverageViewReader.class);
    private StructuredGridCoverage2DReader structuredDelegate;

    public StructuredCoverageViewReader(StructuredGridCoverage2DReader delegate, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        super((GridCoverage2DReader)delegate, coverageView, coverageInfo, hints);
        this.structuredDelegate = delegate;
    }

    public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
        return new GranuleStoreView(this.structuredDelegate, this.referenceName, this.coverageView, readOnly);
    }

    public boolean isReadOnly() {
        return this.structuredDelegate.isReadOnly();
    }

    public void createCoverage(String coverageName, SimpleFeatureType schema) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation unavailable for Coverage Views");
    }

    public boolean removeCoverage(String coverageName) throws IOException, UnsupportedOperationException {
        return this.removeCoverage(this.referenceName, false);
    }

    public boolean removeCoverage(String coverageName, boolean delete) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation unavailable for Coverage Views");
    }

    public void delete(boolean deleteData) throws IOException {
        this.structuredDelegate.delete(deleteData);
    }

    public List<HarvestedSource> harvest(String defaultTargetCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
        return this.structuredDelegate.harvest(defaultTargetCoverage, source, hints);
    }

    public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
        return this.structuredDelegate.getDimensionDescriptors(this.referenceName);
    }

    static class GranuleStoreView
    implements GranuleStore {
        private StructuredGridCoverage2DReader reader;
        private CoverageView coverageView;
        private String name;
        private boolean readOnly;
        private SimpleFeatureType schema;

        public GranuleStoreView(StructuredGridCoverage2DReader structuredDelegate, String referenceName, CoverageView coverageView, boolean readOnly) throws UnsupportedOperationException, IOException {
            this.reader = structuredDelegate;
            this.coverageView = coverageView;
            this.name = referenceName;
            this.readOnly = readOnly;
            this.schema = this.buildSchema();
        }

        private SimpleFeatureType buildSchema() throws IOException {
            GranuleSource source = this.reader.getGranules(this.name, this.readOnly);
            SimpleFeatureType inputSchema = source.getSchema();
            List descriptors = inputSchema.getAttributeDescriptors();
            StringBuilder builder = new StringBuilder();
            for (AttributeDescriptor descriptor : descriptors) {
                if (descriptor.getLocalName().equalsIgnoreCase("imageIndex")) continue;
                Class binding = descriptor.getType().getBinding();
                String bindingClass = binding.toString();
                if (bindingClass.startsWith("class ")) {
                    bindingClass = bindingClass.substring(6, bindingClass.length());
                }
                builder.append(descriptor.getName()).append(":").append(bindingClass).append(",");
            }
            String schema = builder.toString();
            schema = schema.substring(0, schema.length() - 1);
            try {
                return DataUtilities.createType((String)this.coverageView.getName(), (String)schema);
            }
            catch (SchemaException e) {
                throw new IOException("Exception occurred while creating the schemaType", e);
            }
        }

        public SimpleFeatureCollection getGranules(Query q) throws IOException {
            List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
            SimpleFeatureCollection collection = null;
            for (CoverageView.CoverageBand band : bands) {
                String coverageName = band.getInputCoverageBands().get(0).getCoverageName();
                if (collection == null) {
                    collection = this.reader.getGranules(coverageName, this.readOnly).getGranules(q);
                    continue;
                }
                collection = this.join(collection, band, coverageName);
            }
            return collection;
        }

        private SimpleFeatureCollection join(SimpleFeatureCollection inputCollection, CoverageView.CoverageBand band, final String coverageName) throws IOException {
            final DefaultProgressListener listener = new DefaultProgressListener();
            final ListFeatureCollection collection = new ListFeatureCollection(this.schema);
            inputCollection.accepts((FeatureVisitor)new AbstractFeatureVisitor(){

                public void visit(Feature feature) {
                    if (feature instanceof SimpleFeature) {
                        SimpleFeature sourceFeature = (SimpleFeature)feature;
                        Collection props = sourceFeature.getProperties();
                        Name propName = null;
                        Object propValue = null;
                        PropertyIsEqualTo filter = null;
                        for (Property prop : props) {
                            propName = prop.getName();
                            if (propName.getLocalPart().equalsIgnoreCase("imageIndex") || propName.getLocalPart().equalsIgnoreCase("the_geom") || propName.getLocalPart().equalsIgnoreCase("location")) continue;
                            propValue = prop.getValue();
                            PropertyIsEqualTo updatedFilter = Utils.FF.equal((Expression)Utils.FF.property(propName), (Expression)Utils.FF.literal(propValue), true);
                            if (filter == null) {
                                filter = updatedFilter;
                                continue;
                            }
                            filter = CoverageViewReader.FF.and((Filter)filter, (Filter)updatedFilter);
                        }
                        Query query = new Query();
                        query.setFilter(filter);
                        try {
                            SimpleFeatureCollection coverageCollection = GranuleStoreView.this.reader.getGranules(coverageName, GranuleStoreView.this.readOnly).getGranules(query);
                            coverageCollection.accepts((FeatureVisitor)new AbstractFeatureVisitor(){

                                public void visit(Feature feature) {
                                    if (feature instanceof SimpleFeature) {
                                        SimpleFeature destFeature = DataUtilities.template((SimpleFeatureType)GranuleStoreView.this.schema);
                                        Collection props = destFeature.getProperties();
                                        Name propName = null;
                                        Object propValue = null;
                                        for (Property prop : props) {
                                            propName = prop.getName();
                                            propValue = ((SimpleFeature)feature).getAttribute(propName);
                                            destFeature.setAttribute(propName, propValue);
                                        }
                                        collection.add(destFeature);
                                        if (listener.isCanceled() || listener.hasExceptions()) {
                                            if (listener.hasExceptions()) {
                                                throw new RuntimeException((Throwable)listener.getExceptions().peek());
                                            }
                                            throw new IllegalStateException("Feature visitor has been canceled");
                                        }
                                    }
                                }
                            }, (ProgressListener)listener);
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINER, e.getMessage(), e);
                        }
                        catch (UnsupportedOperationException e) {
                            LOGGER.log(Level.FINER, e.getMessage(), e);
                        }
                        if (listener.isCanceled() || listener.hasExceptions()) {
                            if (listener.hasExceptions()) {
                                throw new RuntimeException((Throwable)listener.getExceptions().peek());
                            }
                            throw new IllegalStateException("Feature visitor has been canceled");
                        }
                    }
                }
            }, (ProgressListener)listener);
            return collection;
        }

        public int getCount(Query q) throws IOException {
            return this.getGranules(q).size();
        }

        public ReferencedEnvelope getBounds(Query q) throws IOException {
            return this.getGranules(q).getBounds();
        }

        public SimpleFeatureType getSchema() throws IOException {
            return this.schema;
        }

        public void dispose() throws IOException {
        }

        public void addGranules(SimpleFeatureCollection granules) {
            throw new UnsupportedOperationException();
        }

        public int removeGranules(Filter filter) {
            List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
            int removed = 0;
            for (CoverageView.CoverageBand band : bands) {
                String coverageName = band.getInputCoverageBands().get(0).getCoverageName();
                try {
                    GranuleStore granuleStore = (GranuleStore)this.reader.getGranules(coverageName, false);
                    removed = granuleStore.removeGranules(filter);
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
            }
            return removed;
        }

        public void updateGranules(String[] attributeNames, Object[] attributeValues, Filter filter) {
            throw new UnsupportedOperationException();
        }

        public Transaction getTransaction() {
            return null;
        }

        public void setTransaction(Transaction transaction) {
        }
    }
}

