/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.data.util.IOUtils;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.xml.sax.EntityResolver;

public class SLDPackageHandler
extends StyleHandler {
    static Logger LOGGER = Logging.getLogger(SLDPackageHandler.class);
    public static final String FORMAT = "zip";
    public static final String MIMETYPE = "application/zip";
    private SLDHandler sldHandler;

    protected SLDPackageHandler(SLDHandler sldHandler) {
        super("ZIP", FORMAT);
        this.sldHandler = sldHandler;
    }

    @Override
    public String mimeType(Version version) {
        return MIMETYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        File sldFile = null;
        try {
            sldFile = this.unzipSldPackage(input);
            StyledLayerDescriptor styledLayerDescriptor = this.sldHandler.parse(sldFile, version, resourceLocator, entityResolver);
            return styledLayerDescriptor;
        }
        finally {
            if (sldFile != null) {
                FileUtils.deleteQuietly((File)sldFile.getParentFile());
            }
        }
    }

    @Override
    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        this.sldHandler.encode(sld, version, pretty, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        File sldFile = null;
        try {
            sldFile = this.unzipSldPackage(input);
            List<Exception> list2 = this.sldHandler.validate(input, version, entityResolver);
            return list2;
        }
        finally {
            if (sldFile != null) {
                FileUtils.deleteQuietly((File)sldFile.getParentFile());
            }
        }
    }

    private File unzipSldPackage(Object input) throws IOException {
        File myTempDir = Files.createTempDir();
        IOUtils.decompress((InputStream)input, myTempDir);
        File[] files = myTempDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".sld");
            }
        });
        if (files.length != 1) {
            throw new IOException("No SLD file");
        }
        return files[0];
    }
}

