/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleType;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.data.DataUtilities;
import org.geotools.sld.v1_1.SLD;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.picocontainer.MutablePicoContainer;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SLDHandler
extends StyleHandler {
    static Logger LOGGER = Logging.getLogger(SLDHandler.class);
    static int XML_LOOKAHEAD = 8192;
    public static final String FORMAT = "sld";
    public static final Version VERSION_10 = new Version("1.0.0");
    public static final Version VERSION_11 = new Version("1.1.0");
    public static final String MIMETYPE_10 = "application/vnd.ogc.sld+xml";
    public static final String MIMETYPE_11 = "application/vnd.ogc.se+xml";
    static final Map<StyleType, String> TEMPLATES = new HashMap<StyleType, String>();

    public SLDHandler() {
        super("SLD", FORMAT);
    }

    @Override
    public List<Version> getVersions() {
        return Arrays.asList(VERSION_10, VERSION_11);
    }

    @Override
    public String getCodeMirrorEditMode() {
        return "xml";
    }

    @Override
    public String getStyle(StyleType type, Color color, String colorName, String layerName) {
        String template = TEMPLATES.get((Object)type);
        String colorCode = Integer.toHexString(color.getRGB());
        colorCode = colorCode.substring(2, colorCode.length());
        return template.replace("${colorName}", colorName).replace("${colorCode}", "#" + colorCode).replace("${layerName}", layerName);
    }

    @Override
    public String mimeType(Version version) {
        if (version != null && VERSION_11.equals((Object)version)) {
            return MIMETYPE_11;
        }
        return MIMETYPE_10;
    }

    @Override
    public Version versionForMimeType(String mimeType) {
        if (mimeType.equals(MIMETYPE_11)) {
            return VERSION_11;
        }
        return VERSION_10;
    }

    @Override
    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        if (version == null) {
            Object[] versionAndReader = this.getVersionAndReader(input);
            version = (Version)versionAndReader[0];
            input = versionAndReader[1];
        }
        if (VERSION_11.compareTo(version) == 0) {
            return this.parse11(input, resourceLocator, entityResolver);
        }
        return this.parse10(input, resourceLocator, entityResolver);
    }

    StyledLayerDescriptor parse10(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        Style[] style;
        SLDParser p = this.createSld10Parser(input, resourceLocator, entityResolver);
        StyledLayerDescriptor sld = p.parseSLD();
        if (sld.getStyledLayers().length == 0 && (style = p.readDOM()).length > 0) {
            NamedLayer l = styleFactory.createNamedLayer();
            l.addStyle(style[0]);
            sld.addStyledLayer((StyledLayer)l);
        }
        return sld;
    }

    StyledLayerDescriptor parse11(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        Parser parser = this.createSld11Parser(input, resourceLocator, entityResolver);
        try {
            parser.setEntityResolver(entityResolver);
            return (StyledLayerDescriptor)parser.parse(this.toReader(input));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    SLDParser createSld10Parser(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        SLDParser parser = input instanceof File ? new SLDParser(styleFactory, (File)input) : new SLDParser(styleFactory, this.toReader(input));
        if (resourceLocator != null) {
            parser.setOnLineResourceLocator(resourceLocator);
        }
        if (entityResolver != null) {
            parser.setEntityResolver(entityResolver);
        }
        return parser;
    }

    Parser createSld11Parser(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) {
        ResourceLocator locator;
        if (resourceLocator == null && input instanceof File) {
            URL surl = DataUtilities.fileToURL((File)((File)input));
            DefaultResourceLocator defResourceLocator = new DefaultResourceLocator();
            defResourceLocator.setSourceUrl(surl);
            resourceLocator = defResourceLocator;
        }
        SLDConfiguration sld = (locator = resourceLocator) != null ? new SLDConfiguration(){

            protected void configureContext(MutablePicoContainer container) {
                container.registerComponentInstance(ResourceLocator.class, (Object)locator);
            }
        } : new SLDConfiguration();
        Parser parser = new Parser((Configuration)sld);
        if (entityResolver != null) {
            parser.setEntityResolver(entityResolver);
        }
        return parser;
    }

    @Override
    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        if (version != null && VERSION_11.compareTo(version) == 0) {
            this.encode11(sld, pretty, output);
        } else {
            this.encode10(sld, pretty, output);
        }
    }

    void encode10(StyledLayerDescriptor sld, boolean pretty, OutputStream output) throws IOException {
        SLDTransformer tx = new SLDTransformer();
        if (pretty) {
            tx.setIndentation(2);
        }
        try {
            tx.transform((Object)sld, output);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException("Error writing style").initCause(e);
        }
    }

    void encode11(StyledLayerDescriptor sld, boolean pretty, OutputStream output) throws IOException {
        Encoder e = new Encoder((Configuration)new SLDConfiguration());
        e.setIndenting(pretty);
        e.encode((Object)sld, SLD.StyledLayerDescriptor, output);
    }

    @Override
    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        if (version == null) {
            Object[] versionAndReader = this.getVersionAndReader(input);
            version = (Version)versionAndReader[0];
            input = versionAndReader[1];
        }
        if (version != null && VERSION_11.compareTo(version) == 0) {
            return this.validate11(input, entityResolver);
        }
        return this.validate10(input, entityResolver);
    }

    List<Exception> validate10(Object input, EntityResolver entityResolver) throws IOException {
        return new SLDValidator().validateSLD(new InputSource(this.toReader(input)));
    }

    List<Exception> validate11(Object input, EntityResolver entityResolver) throws IOException {
        Parser p = this.createSld11Parser(input, null, entityResolver);
        try {
            p.validate(this.toReader(input));
            return p.getValidationErrors();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Version version(Object input) throws IOException {
        Object[] versionAndReader = this.getVersionAndReader(input);
        return (Version)versionAndReader[0];
    }

    Object[] getVersionAndReader(Object input) throws IOException {
        String version;
        BufferedReader reader = null;
        reader = input instanceof InputStream ? RequestUtils.getBufferedXMLReader((InputStream)((InputStream)input), (int)XML_LOOKAHEAD) : RequestUtils.getBufferedXMLReader((Reader)this.toReader(input), (int)XML_LOOKAHEAD);
        if (!reader.ready()) {
            return null;
        }
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)reader);
            parser.nextTag();
            version = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"version".equals(parser.getAttributeName(i))) continue;
                version = parser.getAttributeValue(i);
            }
            parser.setInput(null);
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException("Error parsing content").initCause(e);
        }
        reader.reset();
        if (version == null) {
            LOGGER.warning("Could not determine SLD version from content. Assuming 1.0.0");
            version = "1.0.0";
        }
        return new Object[]{new Version(version), reader};
    }

    static {
        try {
            TEMPLATES.put(StyleType.POINT, IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_point.sld")));
            TEMPLATES.put(StyleType.POLYGON, IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_polygon.sld")));
            TEMPLATES.put(StyleType.LINE, IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_line.sld")));
            TEMPLATES.put(StyleType.RASTER, IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_raster.sld")));
            TEMPLATES.put(StyleType.GENERIC, IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_generic.sld")));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading up the style templates", e);
        }
    }
}

