/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogRepository;
import org.geoserver.catalog.CatalogVisitorAdapter;
import org.geoserver.catalog.CoverageDimensionCustomizerReader;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewReader;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.data.util.IOUtils;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Join;
import org.geotools.data.Repository;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.MultithreadedHttpClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.measure.Measure;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.Schemas;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.util.DataStoreUtils;

public class ResourcePool {
    static final double OGC_DEGREE_TO_METERS = 111319.49079327358;
    static final double OGC_METERS_TO_DEGREES = 8.983152841195214E-6;
    private static final String PROJECTION_POLICY_SEPARATOR = "_pp_";
    public static Hints.Key REPROJECT = new Hints.Key(Boolean.class);
    public static Hints.Key JOINS = new Hints.Key(List.class);
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    static Class<?> VERSIONING_FS = null;
    static Class<?> GS_VERSIONING_FS = null;
    static int FEATURETYPE_CACHE_SIZE_DEFAULT;
    private static final String IMAGE_PYRAMID = "ImagePyramid";
    private static final String IMAGE_MOSAIC = "ImageMosaic";
    Catalog catalog;
    Map<String, CoordinateReferenceSystem> crsCache = this.createCrsCache();
    DataStoreCache dataStoreCache = this.createDataStoreCache();
    Map<String, FeatureType> featureTypeCache = this.createFeatureTypeCache(FEATURETYPE_CACHE_SIZE_DEFAULT);
    Map<String, List<AttributeTypeInfo>> featureTypeAttributeCache = this.createFeatureTypeAttributeCache(FEATURETYPE_CACHE_SIZE_DEFAULT);
    Map<String, WebMapServer> wmsCache;
    Map<String, GridCoverageReader> coverageReaderCache = this.createCoverageReaderCache();
    Map<CoverageHintReaderKey, GridCoverageReader> hintCoverageReaderCache = this.createHintCoverageReaderCache();
    Map<StyleInfo, Style> styleCache;
    List<Listener> listeners;
    ThreadPoolExecutor coverageExecutor;
    CatalogRepository repository;

    public static ResourcePool create(Catalog catalog) {
        return ResourcePool.create(catalog, null);
    }

    public static ResourcePool create(Catalog catalog, ApplicationContext appContext) {
        ResourcePool pool;
        ResourcePool resourcePool = pool = appContext == null ? (ResourcePool)GeoServerExtensions.bean(ResourcePool.class) : (ResourcePool)GeoServerExtensions.bean(ResourcePool.class, (ApplicationContext)appContext);
        if (pool == null) {
            pool = new ResourcePool();
        }
        pool.setCatalog(catalog);
        return pool;
    }

    protected ResourcePool() {
        this.wmsCache = this.createWmsCache();
        this.styleCache = this.createStyleCache();
        this.listeners = new CopyOnWriteArrayList<Listener>();
    }

    protected ResourcePool(Catalog catalog) {
        this();
        this.setCatalog(catalog);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.repository = new CatalogRepository(catalog);
        catalog.removeListeners(CacheClearingListener.class);
        catalog.addListener(new CacheClearingListener());
    }

    public Map<String, CoordinateReferenceSystem> getCrsCache() {
        return this.crsCache;
    }

    protected Map<String, CoordinateReferenceSystem> createCrsCache() {
        return new HashMap<String, CoordinateReferenceSystem>();
    }

    public Map<String, DataAccess> getDataStoreCache() {
        return this.dataStoreCache;
    }

    protected DataStoreCache createDataStoreCache() {
        return new DataStoreCache();
    }

    public Map<String, FeatureType> getFeatureTypeCache() {
        return this.featureTypeCache;
    }

    protected Map<String, FeatureType> createFeatureTypeCache(int size) {
        return new FeatureTypeCache(size * 2);
    }

    public Map<String, List<AttributeTypeInfo>> getFeatureTypeAttributeCache() {
        return this.featureTypeAttributeCache;
    }

    protected Map<String, List<AttributeTypeInfo>> createFeatureTypeAttributeCache(int size) {
        return new FeatureTypeAttributeCache(size * 2);
    }

    public Map<String, GridCoverageReader> getCoverageReaderCache() {
        return this.coverageReaderCache;
    }

    protected Map<String, GridCoverageReader> createCoverageReaderCache() {
        return new CoverageReaderCache();
    }

    public Map<CoverageHintReaderKey, GridCoverageReader> getHintCoverageReaderCache() {
        return this.hintCoverageReaderCache;
    }

    protected Map<CoverageHintReaderKey, GridCoverageReader> createHintCoverageReaderCache() {
        return new CoverageHintReaderCache();
    }

    public Map<StyleInfo, Style> getStyleCache() {
        return this.styleCache;
    }

    protected Map<StyleInfo, Style> createStyleCache() {
        return new HashMap<StyleInfo, Style>();
    }

    public Map<String, WebMapServer> getWmsCache() {
        return this.wmsCache;
    }

    protected Map<String, WebMapServer> createWmsCache() {
        return new WMSCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatureTypeCacheSize(int featureTypeCacheSize) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            this.featureTypeCache.clear();
            this.featureTypeCache = this.createFeatureTypeCache(featureTypeCacheSize);
            this.featureTypeAttributeCache.clear();
            this.featureTypeAttributeCache = this.createFeatureTypeAttributeCache(featureTypeCacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoverageExecutor(ThreadPoolExecutor coverageExecutor) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            this.coverageExecutor = coverageExecutor;
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem getCRS(String srsName) throws IOException {
        if (srsName == null) {
            return null;
        }
        CoordinateReferenceSystem crs = this.crsCache.get(srsName);
        if (crs == null) {
            Map<String, CoordinateReferenceSystem> map = this.crsCache;
            synchronized (map) {
                crs = this.crsCache.get(srsName);
                if (crs == null) {
                    try {
                        crs = CRS.decode((String)srsName);
                        this.crsCache.put(srsName, crs);
                    }
                    catch (Exception e) {
                        throw (IOException)new IOException().initCause(e);
                    }
                }
            }
        }
        return crs;
    }

    public DataAccessFactory getDataStoreFactory(DataStoreInfo info) throws IOException {
        DataAccessFactory factory = null;
        if (info.getType() != null) {
            factory = DataStoreUtils.aquireFactory(info.getType());
        }
        if (factory == null && info.getConnectionParameters() != null) {
            Map<String, Serializable> params = ResourcePool.getParams(info.getConnectionParameters(), this.catalog.getResourceLoader());
            factory = DataStoreUtils.aquireFactory(params);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataAccess<? extends FeatureType, ? extends Feature> getDataStore(DataStoreInfo info) throws IOException {
        DataAccess dataStore = null;
        try {
            String id = info.getId();
            dataStore = (DataAccess)this.dataStoreCache.get(id);
            if (dataStore == null) {
                DataStoreCache dataStoreCache = this.dataStoreCache;
                synchronized (dataStoreCache) {
                    dataStore = (DataAccess)this.dataStoreCache.get(id);
                    if (dataStore == null) {
                        Map<String, Serializable> connectionParameters = info.getConnectionParameters();
                        connectionParameters = ResourcePool.getParams(connectionParameters, this.catalog.getResourceLoader());
                        DataAccessFactory factory = null;
                        try {
                            factory = this.getDataStoreFactory(info);
                        }
                        catch (IOException e) {
                            throw new IOException("Failed to find the datastore factory for " + info.getName() + ", did you forget to install the store extension jar?");
                        }
                        if (factory == null) {
                            throw new IOException("Failed to find the datastore factory for " + info.getName() + ", did you forget to install the store extension jar?");
                        }
                        DataAccessFactory.Param[] params = factory.getParametersInfo();
                        if (!connectionParameters.containsKey("namespace") && params != null) {
                            boolean supportsNamespace = true;
                            supportsNamespace = false;
                            for (DataAccessFactory.Param p : params) {
                                if (!"namespace".equalsIgnoreCase(p.key)) continue;
                                supportsNamespace = true;
                                break;
                            }
                            if (supportsNamespace) {
                                WorkspaceInfo ws = info.getWorkspace();
                                NamespaceInfo ns = info.getCatalog().getNamespaceByPrefix(ws.getName());
                                if (ns == null) {
                                    ns = info.getCatalog().getDefaultNamespace();
                                }
                                if (ns != null) {
                                    connectionParameters.put("namespace", (Serializable)((Object)ns.getURI()));
                                }
                            }
                        }
                        if (params != null) {
                            for (DataAccessFactory.Param p : params) {
                                if (!Repository.class.equals((Object)p.getType())) continue;
                                connectionParameters.put(p.getName(), this.repository);
                            }
                        }
                        if ((dataStore = DataStoreUtils.getDataAccess(connectionParameters)) == null) {
                            dataStore = DataAccessFinder.getDataStore(connectionParameters);
                        }
                        if (dataStore == null) {
                            throw new NullPointerException("Could not acquire data access '" + info.getName() + "'");
                        }
                        if (id != null) {
                            this.dataStoreCache.put(id, dataStore);
                        }
                    }
                }
            }
            return dataStore;
        }
        catch (Exception e) {
            if (dataStore != null) {
                try {
                    dataStore.dispose();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static <K, V> Map<K, V> getParams(Map<K, V> m, GeoServerResourceLoader loader) {
        Map<K, V> params = Collections.synchronizedMap(new HashMap<K, V>(m));
        for (Map.Entry<K, Object> entry : params.entrySet()) {
            File fixedPath;
            String path;
            String key = (String)entry.getKey();
            V value = entry.getValue();
            if (key != null && key.matches(".* *url") && value instanceof String) {
                path = (String)value;
                if (!path.startsWith("file:")) continue;
                fixedPath = loader.url(path);
                URL url = DataUtilities.fileToURL((File)fixedPath);
                entry.setValue(url.toExternalForm());
                continue;
            }
            if (value instanceof URL && ((URL)value).getProtocol().equals("file")) {
                URL url = (URL)value;
                fixedPath = loader.url(url.toString());
                entry.setValue(DataUtilities.fileToURL((File)fixedPath));
                continue;
            }
            if (key == null || !key.equals("directory") || !(value instanceof String) || !(path = (String)value).startsWith("file:")) continue;
            fixedPath = loader.url(path);
            entry.setValue(fixedPath.toString());
        }
        return params;
    }

    public void clear(DataStoreInfo info) {
        this.dataStoreCache.remove(info.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeTypeInfo> getAttributes(FeatureTypeInfo info) throws IOException {
        if (info.getAttributes() != null && !info.getAttributes().isEmpty() && info.getAttributes().get(0).getBinding() != null) {
            return info.getAttributes();
        }
        List<AttributeTypeInfo> atts = this.featureTypeAttributeCache.get(info.getId());
        if (atts == null) {
            Map<String, List<AttributeTypeInfo>> map = this.featureTypeAttributeCache;
            synchronized (map) {
                atts = this.featureTypeAttributeCache.get(info.getId());
                if (atts == null) {
                    atts = this.loadAttributes(info);
                    try {
                        this.handleSchemaOverride(atts, info);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error occured applying schema override for " + info.getName(), e);
                    }
                    if (info.getId() != null) {
                        this.featureTypeAttributeCache.put(info.getId(), atts);
                    }
                }
            }
        }
        return atts;
    }

    public List<AttributeTypeInfo> loadAttributes(FeatureTypeInfo info) throws IOException {
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>();
        FeatureType ft = this.getFeatureType(info);
        for (PropertyDescriptor pd : ft.getDescriptors()) {
            AttributeTypeInfo att = this.catalog.getFactory().createAttribute();
            att.setFeatureType(info);
            att.setName(pd.getName().getLocalPart());
            att.setMinOccurs(pd.getMinOccurs());
            att.setMaxOccurs(pd.getMaxOccurs());
            att.setNillable(pd.isNillable());
            att.setBinding(pd.getType().getBinding());
            int length = FeatureTypes.getFieldLength((PropertyDescriptor)pd);
            if (length > 0) {
                att.setLength(length);
            }
            attributes.add(att);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSchemaOverride(List<AttributeTypeInfo> atts, FeatureTypeInfo ft) throws IOException {
        File schemaFile;
        block13: {
            GeoServerDataDirectory dd = new GeoServerDataDirectory(this.catalog.getResourceLoader());
            schemaFile = dd.findSuppResourceFile(ft, "schema.xsd");
            if (schemaFile != null || (schemaFile = dd.findSuppLegacyResourceFile(ft, "schema.xsd")) != null) break block13;
            File oldSchemaFile = dd.findSuppResourceFile(ft, "schema.xml");
            if (oldSchemaFile == null) {
                oldSchemaFile = dd.findSuppLegacyResourceFile(ft, "schema.xml");
            }
            if (oldSchemaFile == null) break block13;
            schemaFile = new File(oldSchemaFile.getParentFile(), "schema.xsd");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(schemaFile)));
            out.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'");
            out.write(" xmlns:gml='http://www.opengis.net/gml'");
            out.write(">");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(oldSchemaFile);
                org.apache.commons.io.IOUtils.copy((InputStream)fis, (Writer)out);
            }
            catch (Throwable throwable) {
                org.apache.commons.io.IOUtils.closeQuietly(fis);
                throw throwable;
            }
            org.apache.commons.io.IOUtils.closeQuietly((InputStream)fis);
            out.write("</xs:schema>");
            out.flush();
            out.close();
        }
        if (schemaFile != null) {
            List<SchemaLocator> locators = Arrays.asList(GML.getInstance().createSchemaLocator());
            XSDSchema schema = null;
            try {
                schema = Schemas.parse((String)schemaFile.getAbsolutePath(), locators, null);
            }
            catch (Exception e) {
                LOGGER.warning("Unable to parse " + schemaFile.getAbsolutePath() + "." + " Falling back on native feature type");
            }
            if (schema != null) {
                XSDTypeDefinition type = null;
                for (XSDElementDeclaration element : schema.getElementDeclarations()) {
                    if (!ft.getName().equals(element.getName())) continue;
                    type = element.getTypeDefinition();
                    break;
                }
                if (type == null) {
                    for (XSDTypeDefinition typedef : schema.getTypeDefinitions()) {
                        if (!(ft.getName() + "_Type").equals(typedef.getName())) continue;
                        type = typedef;
                        break;
                    }
                }
                if (type != null) {
                    List children = Schemas.getChildElementDeclarations(type, (boolean)true);
                    Iterator<AttributeTypeInfo> i = atts.iterator();
                    while (i.hasNext()) {
                        AttributeTypeInfo at = i.next();
                        boolean found = false;
                        for (XSDElementDeclaration ce : children) {
                            if (!at.getName().equals(ce.getName())) continue;
                            found = true;
                            if (!(ce.getContainer() instanceof XSDParticle)) break;
                            XSDParticle part = (XSDParticle)ce.getContainer();
                            at.setMinOccurs(part.getMinOccurs());
                            at.setMaxOccurs(part.getMaxOccurs());
                            break;
                        }
                        if (found) continue;
                        i.remove();
                    }
                }
            }
        }
    }

    public FeatureType getFeatureType(FeatureTypeInfo info) throws IOException {
        return this.getFeatureType(info, true);
    }

    FeatureType getFeatureType(FeatureTypeInfo info, boolean handleProjectionPolicy) throws IOException {
        try {
            return this.tryGetFeatureType(info, handleProjectionPolicy);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error while getting feature type, flushing cache and retrying: {0}", ex.getMessage());
            LOGGER.log(Level.FINE, "", ex);
            this.clear(info);
            this.flushDataStore(info);
            return this.tryGetFeatureType(info, handleProjectionPolicy);
        }
    }

    FeatureType tryGetFeatureType(FeatureTypeInfo info, boolean handleProjectionPolicy) throws IOException {
        boolean cacheable = this.isCacheable(info) && handleProjectionPolicy;
        return cacheable ? this.getCacheableFeatureType(info, handleProjectionPolicy) : this.getNonCacheableFeatureType(info, handleProjectionPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureType getCacheableFeatureType(FeatureTypeInfo info, boolean handleProjectionPolicy) throws IOException {
        String key = this.getFeatureTypeInfoKey(info, handleProjectionPolicy);
        FeatureType ft = this.featureTypeCache.get(key);
        if (ft == null) {
            Map<String, FeatureType> map = this.featureTypeCache;
            synchronized (map) {
                ft = this.featureTypeCache.get(key);
                if (ft == null) {
                    DataAccess<? extends FeatureType, ? extends Feature> dataAccess = this.getDataStore(info.getStore());
                    FeatureTypeCallback initializer = this.getFeatureTypeInitializer(info, dataAccess);
                    if (initializer != null) {
                        initializer.initialize(info, dataAccess, null);
                    }
                    ft = dataAccess.getSchema(info.getQualifiedNativeName());
                    ft = this.buildFeatureType(info, handleProjectionPolicy, ft);
                    this.featureTypeCache.put(key, ft);
                }
            }
        }
        return ft;
    }

    private FeatureType getNonCacheableFeatureType(FeatureTypeInfo info, boolean handleProjectionPolicy) throws IOException {
        FeatureType ft = null;
        DataAccess<? extends FeatureType, ? extends Feature> dataAccess = this.getDataStore(info.getStore());
        FeatureTypeCallback initializer = this.getFeatureTypeInitializer(info, dataAccess);
        Name temporaryName = null;
        if (initializer != null) {
            List typeNames = dataAccess.getNames();
            String nsURI = null;
            if (typeNames.size() > 0) {
                nsURI = ((Name)typeNames.get(0)).getNamespaceURI();
            }
            do {
                String name = UUID.randomUUID().toString();
                temporaryName = new NameImpl(nsURI, name);
            } while (Arrays.asList(typeNames).contains(temporaryName));
            if (!initializer.initialize(info, dataAccess, temporaryName)) {
                temporaryName = null;
            }
        }
        ft = dataAccess.getSchema(temporaryName != null ? temporaryName : info.getQualifiedNativeName());
        ft = this.buildFeatureType(info, handleProjectionPolicy, ft);
        if (initializer != null && temporaryName != null) {
            initializer.dispose(info, dataAccess, temporaryName);
        }
        return ft;
    }

    FeatureTypeCallback getFeatureTypeInitializer(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) {
        List featureTypeInitializers = GeoServerExtensions.extensions(FeatureTypeCallback.class);
        FeatureTypeCallback initializer = null;
        for (FeatureTypeCallback fti : featureTypeInitializers) {
            if (!fti.canHandle(info, dataAccess)) continue;
            initializer = fti;
        }
        return initializer;
    }

    private FeatureType buildFeatureType(FeatureTypeInfo info, boolean handleProjectionPolicy, FeatureType ft) throws IOException {
        if (ft instanceof SimpleFeatureType) {
            SimpleFeatureType sft = (SimpleFeatureType)ft;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName(info.getName());
            tb.setNamespaceURI(info.getNamespace().getURI());
            if (info.getAttributes() == null || info.getAttributes().isEmpty()) {
                for (PropertyDescriptor pd : ft.getDescriptors()) {
                    if (!(pd instanceof AttributeDescriptor)) continue;
                    AttributeDescriptor ad = (AttributeDescriptor)pd;
                    if (handleProjectionPolicy) {
                        ad = this.handleDescriptor(ad, info);
                    }
                    tb.add(ad);
                }
            } else {
                for (AttributeTypeInfo att : info.getAttributes()) {
                    String attName = att.getName();
                    PropertyDescriptor pd = ft.getDescriptor(attName);
                    if (pd == null || !(pd instanceof AttributeDescriptor)) {
                        throw new IOException("the SimpleFeatureType " + info.getPrefixedName() + " does not contains the configured attribute " + attName + ". Check your schema configuration");
                    }
                    AttributeDescriptor ad = (AttributeDescriptor)pd;
                    ad = this.handleDescriptor(ad, info);
                    tb.add(ad);
                }
            }
            ft = tb.buildFeatureType();
        }
        return ft;
    }

    private String getFeatureTypeInfoKey(FeatureTypeInfo info, boolean handleProjectionPolicy) {
        return info.getId() + PROJECTION_POLICY_SEPARATOR + handleProjectionPolicy;
    }

    boolean isCacheable(CatalogInfo info) {
        InvocationHandler invocationHandler;
        if (info.getId() == null) {
            return false;
        }
        return !Proxy.isProxyClass(info.getClass()) || !((invocationHandler = Proxy.getInvocationHandler(info)) instanceof ModificationProxy) || !((ModificationProxy)invocationHandler).isDirty();
    }

    AttributeDescriptor handleDescriptor(AttributeDescriptor ad, FeatureTypeInfo info) {
        if (ad instanceof GeometryDescriptor) {
            GeometryDescriptor old = (GeometryDescriptor)ad;
            try {
                boolean rebuild = false;
                if (old.getCoordinateReferenceSystem() == null) {
                    if (info.getProjectionPolicy() != ProjectionPolicy.FORCE_DECLARED) {
                        if (Proxy.isProxyClass(info.getClass())) {
                            FeatureTypeInfo inner = ModificationProxy.unwrap(info);
                            inner.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
                        } else {
                            info.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
                        }
                    }
                    rebuild = true;
                } else {
                    ProjectionPolicy projPolicy = info.getProjectionPolicy();
                    if (projPolicy == ProjectionPolicy.REPROJECT_TO_DECLARED || projPolicy == ProjectionPolicy.FORCE_DECLARED) {
                        rebuild = true;
                    }
                }
                if (rebuild) {
                    AttributeTypeBuilder b = new AttributeTypeBuilder();
                    b.init((AttributeDescriptor)old);
                    b.setCRS(this.getCRS(info.getSRS()));
                    ad = b.buildDescriptor(old.getLocalName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ad;
    }

    public AttributeDescriptor getAttributeDescriptor(FeatureTypeInfo ftInfo, AttributeTypeInfo atInfo) throws Exception {
        FeatureType featureType = this.getFeatureType(ftInfo);
        if (featureType != null) {
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                if (!(pd instanceof AttributeDescriptor)) continue;
                AttributeDescriptor ad = (AttributeDescriptor)pd;
                if (!atInfo.getName().equals(ad.getLocalName())) continue;
                return ad;
            }
        }
        return null;
    }

    public void clear(FeatureTypeInfo info) {
        this.featureTypeCache.remove(this.getFeatureTypeInfoKey(info, true));
        this.featureTypeCache.remove(this.getFeatureTypeInfoKey(info, false));
        this.featureTypeAttributeCache.remove(info.getId());
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(FeatureTypeInfo info, Hints hints) throws IOException {
        List<AttributeTypeInfo> attributes;
        ProjectionPolicy ppolicy;
        DataAccess<? extends FeatureType, ? extends Feature> dataAccess = this.getDataStore(info.getStore());
        if (!(dataAccess instanceof DataStore)) {
            return dataAccess.getFeatureSource(info.getQualifiedName());
        }
        DataStore dataStore = (DataStore)dataAccess;
        FeatureTypeCallback initializer = this.getFeatureTypeInitializer(info, dataAccess);
        if (initializer != null) {
            initializer.initialize(info, dataAccess, null);
        }
        String typeName = info.getNativeName();
        String alias = info.getName();
        SimpleFeatureType nativeFeatureType = dataStore.getSchema(typeName);
        SimpleFeatureType renamedFeatureType = (SimpleFeatureType)this.getFeatureType(info, false);
        SimpleFeatureSource fs = !typeName.equals(alias) || DataUtilities.compare((SimpleFeatureType)nativeFeatureType, (SimpleFeatureType)renamedFeatureType) != 0 ? RetypingFeatureSource.getRetypingSource(dataStore.getFeatureSource(typeName), renamedFeatureType) : dataStore.getFeatureSource(info.getQualifiedName());
        Boolean reproject = Boolean.TRUE;
        if (hints != null && hints.get((Object)REPROJECT) != null) {
            reproject = (Boolean)hints.get((Object)REPROJECT);
        }
        if ((ppolicy = info.getProjectionPolicy()) == ProjectionPolicy.REPROJECT_TO_DECLARED && !reproject.booleanValue()) {
            ppolicy = ProjectionPolicy.NONE;
        }
        if ((attributes = info.attributes()) == null || attributes.isEmpty()) {
            return fs;
        }
        CoordinateReferenceSystem resultCRS = null;
        GeometryDescriptor gd = ((SimpleFeatureType)fs.getSchema()).getGeometryDescriptor();
        CoordinateReferenceSystem nativeCRS = gd != null ? gd.getCoordinateReferenceSystem() : null;
        resultCRS = ppolicy == ProjectionPolicy.NONE && nativeCRS != null ? nativeCRS : this.getCRS(info.getSRS());
        SimpleFeatureType schema = (SimpleFeatureType)this.getFeatureType(info);
        try {
            if (!CRS.equalsIgnoreMetadata((Object)resultCRS, (Object)schema.getCoordinateReferenceSystem())) {
                schema = FeatureTypes.transform((SimpleFeatureType)schema, (CoordinateReferenceSystem)resultCRS);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Problem forcing CRS onto feature type", (Throwable)e);
        }
        try {
            if (VERSIONING_FS != null && GS_VERSIONING_FS != null && VERSIONING_FS.isAssignableFrom(fs.getClass())) {
                try {
                    Method m = GS_VERSIONING_FS.getMethod("create", VERSIONING_FS, SimpleFeatureType.class, Filter.class, CoordinateReferenceSystem.class, Integer.TYPE);
                    return (FeatureSource)m.invoke(null, fs, schema, info.filter(), resultCRS, info.getProjectionPolicy().getCode());
                }
                catch (Exception e) {
                    throw new DataSourceException("Creation of a versioning wrapper failed", (Throwable)e);
                }
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (hints != null && hints.containsKey((Object)JOINS)) {
            List joins = (List)hints.get((Object)JOINS);
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.init(schema);
            for (Join j : joins) {
                String attName = j.getAlias() != null ? j.getAlias() : j.getTypeName();
                typeBuilder.add(attName, SimpleFeature.class);
            }
            schema = typeBuilder.buildFeatureType();
        }
        return GeoServerFeatureLocking.create((FeatureSource<SimpleFeatureType, SimpleFeature>)fs, schema, info.filter(), resultCRS, info.getProjectionPolicy().getCode(), this.getTolerance(info), info.getMetadata());
    }

    private Double getTolerance(FeatureTypeInfo info) {
        if (!info.isCircularArcPresent()) {
            return null;
        }
        Measure mt = info.getLinearizationTolerance();
        if (mt == null) {
            return null;
        }
        if (mt.getUnit() == null) {
            return mt.doubleValue();
        }
        CoordinateReferenceSystem crs = info.getCRS();
        if (crs == null) {
            return mt.doubleValue();
        }
        SingleCRS horizontalCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        Unit<?> targetUnit = horizontalCRS != null ? this.getFirstAxisUnit(horizontalCRS.getCoordinateSystem()) : this.getFirstAxisUnit(crs.getCoordinateSystem());
        if (targetUnit != null && targetUnit == NonSI.DEGREE_ANGLE || horizontalCRS instanceof GeographicCRS || crs instanceof GeographicCRS) {
            UnitConverter converter = mt.getUnit().getConverterTo(SI.METER);
            double tolMeters = converter.convert(mt.doubleValue());
            return tolMeters * 8.983152841195214E-6;
        }
        if (targetUnit != null && targetUnit.isCompatible(SI.METER)) {
            UnitConverter converter = mt.getUnit().getConverterTo(targetUnit);
            return converter.convert(mt.doubleValue());
        }
        return mt.doubleValue();
    }

    private Unit<?> getFirstAxisUnit(CoordinateSystem coordinateSystem) {
        if (coordinateSystem == null || coordinateSystem.getDimension() > 0) {
            return null;
        }
        return coordinateSystem.getAxis(0).getUnit();
    }

    public GridCoverageReader getGridCoverageReader(CoverageInfo info, Hints hints) throws IOException {
        return this.getGridCoverageReader(info, (String)null, hints);
    }

    public GridCoverageReader getGridCoverageReader(CoverageInfo info, String coverageName, Hints hints) throws IOException {
        return this.getGridCoverageReader(info.getStore(), info, coverageName, hints);
    }

    public GridCoverageReader getGridCoverageReader(CoverageStoreInfo info, Hints hints) throws IOException {
        return this.getGridCoverageReader(info, (String)null, hints);
    }

    public GridCoverageReader getGridCoverageReader(CoverageStoreInfo storeInfo, String coverageName, Hints hints) throws IOException {
        return this.getGridCoverageReader(storeInfo, null, coverageName, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverageReader getGridCoverageReader(CoverageStoreInfo info, CoverageInfo coverageInfo, String coverageName, Hints hints) throws IOException {
        MetadataMap metadata;
        Object key;
        Object formatName;
        AbstractGridFormat gridFormat = info.getFormat();
        if (gridFormat == null) {
            throw new IOException("Could not find the raster plugin for format " + info.getType());
        }
        GridCoverageReader reader = null;
        if (hints != null && info.getId() != null) {
            formatName = gridFormat.getName();
            if ((((String)formatName).equalsIgnoreCase(IMAGE_MOSAIC) || ((String)formatName).equalsIgnoreCase(IMAGE_PYRAMID)) && this.coverageExecutor != null) {
                if (hints != null) {
                    hints = new Hints((RenderingHints)hints);
                    hints.add(new RenderingHints((RenderingHints.Key)Hints.EXECUTOR_SERVICE, this.coverageExecutor));
                } else {
                    hints = new Hints(new RenderingHints((RenderingHints.Key)Hints.EXECUTOR_SERVICE, this.coverageExecutor));
                }
            }
            key = new CoverageHintReaderKey(info.getId(), hints);
            reader = this.hintCoverageReaderCache.get(key);
        } else {
            key = info.getId();
            if (key != null) {
                reader = this.coverageReaderCache.get(key);
            }
        }
        if (reader == null) {
            formatName = hints != null ? this.hintCoverageReaderCache : this.coverageReaderCache;
            synchronized (formatName) {
                if (key != null) {
                    reader = hints != null ? this.hintCoverageReaderCache.get(key) : this.coverageReaderCache.get(key);
                }
                if (reader == null) {
                    String url = info.getURL();
                    GeoServerResourceLoader loader = this.catalog.getResourceLoader();
                    File obj = loader.url(url);
                    Object input = obj != null ? obj : url;
                    reader = gridFormat.getReader(input, new Hints((RenderingHints)hints));
                    if (reader == null) {
                        throw new IOException("Failed to create reader from " + url + " and hints " + hints);
                    }
                    if (key != null) {
                        if (hints != null) {
                            this.hintCoverageReaderCache.put((CoverageHintReaderKey)key, reader);
                        } else {
                            this.coverageReaderCache.put((String)key, reader);
                        }
                    }
                }
            }
        }
        if (coverageInfo != null && (metadata = coverageInfo.getMetadata()) != null && metadata.containsKey(CoverageView.COVERAGE_VIEW)) {
            CoverageView coverageView = (CoverageView)metadata.get(CoverageView.COVERAGE_VIEW);
            return CoverageViewReader.wrap((GridCoverage2DReader)reader, coverageView, coverageInfo, hints);
        }
        if (coverageName != null) {
            return CoverageDimensionCustomizerReader.wrap((GridCoverage2DReader)reader, coverageName, info);
        }
        int numCoverages = ((GridCoverage2DReader)reader).getGridCoverageCount();
        if (numCoverages == 1) {
            return CoverageDimensionCustomizerReader.wrap((GridCoverage2DReader)reader, null, info);
        }
        return reader;
    }

    public void clear(CoverageStoreInfo info) {
        String storeId = info.getId();
        this.coverageReaderCache.remove(storeId);
        HashSet<CoverageHintReaderKey> keys = new HashSet<CoverageHintReaderKey>(this.hintCoverageReaderCache.keySet());
        for (CoverageHintReaderKey key : keys) {
            if (key.id == null || !key.id.equals(storeId)) continue;
            this.hintCoverageReaderCache.remove(key);
        }
    }

    public GridCoverage getGridCoverage(CoverageInfo info, ReferencedEnvelope env, Hints hints) throws IOException {
        return this.getGridCoverage(info, (String)null, env, hints);
    }

    public GridCoverage getGridCoverage(CoverageInfo info, String coverageName, ReferencedEnvelope env, Hints hints) throws IOException {
        GridCoverageReader reader = this.getGridCoverageReader(info, coverageName, hints);
        if (reader == null) {
            return null;
        }
        return this.getGridCoverage(info, reader, env, hints);
    }

    public GridCoverage getGridCoverage(CoverageInfo info, GridCoverageReader reader, ReferencedEnvelope env, Hints hints) throws IOException {
        CoordinateReferenceSystem destCRS;
        ReferencedEnvelope coverageBounds;
        try {
            coverageBounds = info.boundingBox();
        }
        catch (Exception e) {
            throw (IOException)new IOException("unable to calculate coverage bounds").initCause(e);
        }
        GeneralEnvelope envelope = null;
        envelope = env == null ? new GeneralEnvelope((Envelope)coverageBounds) : new GeneralEnvelope((Envelope)env);
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        try {
            destCRS = info.getCRS();
        }
        catch (Exception e) {
            IOException ioe = new IOException("unable to determine coverage crs");
            ioe.initCause(e);
            throw ioe;
        }
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS)) {
            try {
                envelope = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)destCRS);
            }
            catch (TransformException e) {
                throw (IOException)new IOException("error occured transforming envelope").initCause(e);
            }
        }
        envelope.intersect((Envelope)coverageBounds);
        if (envelope.isEmpty()) {
            return null;
        }
        envelope.setCoordinateReferenceSystem(destCRS);
        GridCoverage gc = reader.read(CoverageUtils.getParameters(reader.getFormat().getReadParameters(), info.getParameters()));
        if (gc == null || !(gc instanceof GridCoverage2D)) {
            throw new IOException("The requested coverage could not be found.");
        }
        return gc;
    }

    public AbstractGridFormat getGridCoverageFormat(CoverageStoreInfo info) {
        int length = CoverageStoreUtils.formats.length;
        for (int i = 0; i < length; ++i) {
            if (!CoverageStoreUtils.formats[i].getName().equals(info.getType())) continue;
            return (AbstractGridFormat)CoverageStoreUtils.formats[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebMapServer getWebMapServer(WMSStoreInfo info) throws IOException {
        try {
            String id = info.getId();
            WebMapServer wms = this.wmsCache.get(id);
            if (wms == null) {
                Map<String, WebMapServer> map = this.wmsCache;
                synchronized (map) {
                    wms = this.wmsCache.get(id);
                    if (wms == null) {
                        HTTPClient client = this.getHTTPClient(info);
                        String capabilitiesURL = info.getCapabilitiesURL();
                        URL serverURL = new URL(capabilitiesURL);
                        wms = new WebMapServer(serverURL, client);
                        this.wmsCache.put(id, wms);
                    }
                }
            }
            return wms;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    private HTTPClient getHTTPClient(WMSStoreInfo info) {
        MultithreadedHttpClient client;
        String capabilitiesURL = info.getCapabilitiesURL();
        if (TestHttpClientProvider.testModeEnabled() && capabilitiesURL.startsWith("http://mock.test.geoserver.org")) {
            HTTPClient client2 = TestHttpClientProvider.get(capabilitiesURL);
            return client2;
        }
        if (info.isUseConnectionPooling()) {
            client = new MultithreadedHttpClient();
            if (info.getMaxConnections() > 0) {
                int maxConnections = info.getMaxConnections();
                MultithreadedHttpClient mtClient = client;
                mtClient.setMaxConnections(maxConnections);
            }
        } else {
            client = new SimpleHttpClient();
        }
        String username = info.getUsername();
        String password = info.getPassword();
        int connectTimeout = info.getConnectTimeout();
        int readTimeout = info.getReadTimeout();
        client.setUser(username);
        client.setPassword(password);
        client.setConnectTimeout(connectTimeout);
        client.setReadTimeout(readTimeout);
        return client;
    }

    public Layer getWMSLayer(WMSLayerInfo info) throws IOException {
        String name = info.getName();
        if (info.getNativeName() != null) {
            name = info.getNativeName();
        }
        WMSCapabilities caps = info.getStore().getWebMapServer(null).getCapabilities();
        for (Layer layer : caps.getLayerList()) {
            if (!name.equals(layer.getName())) continue;
            return layer;
        }
        throw new IOException("Could not find layer " + info.getName() + " in the server capabilitiles document");
    }

    public void clear(WMSStoreInfo info) {
        this.wmsCache.remove(info.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getStyle(final StyleInfo info) throws IOException {
        Style style = this.styleCache.get(info);
        if (style == null) {
            Map<StyleInfo, Style> map = this.styleCache;
            synchronized (map) {
                style = this.styleCache.get(info);
                if (style == null) {
                    style = this.dataDir().parsedStyle(info);
                    if (style == null) {
                        throw new ServiceException("Could not extract a UserStyle definition from " + info.getName());
                    }
                    style.setName(info.getName());
                    this.styleCache.put(info, style);
                    final Resource styleResource = this.dataDir().style(info);
                    styleResource.addListener(new ResourceListener(){

                        public void changed(ResourceNotification notify) {
                            ResourcePool.this.styleCache.remove(info);
                            styleResource.removeListener((ResourceListener)this);
                        }
                    });
                }
            }
        }
        return style;
    }

    public void clear(StyleInfo info) {
        this.styleCache.remove(info);
    }

    public BufferedReader readStyle(StyleInfo style) throws IOException {
        File styleFile = this.dataDir().findStyleSldFile(style);
        if (styleFile == null) {
            throw new IOException("No such file: " + style.getFilename());
        }
        return new BufferedReader(new InputStreamReader(new FileInputStream(styleFile)));
    }

    public void writeStyle(StyleInfo info, Style style) throws IOException {
        this.writeStyle(info, style, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStyle(StyleInfo info, Style style, boolean format) throws IOException {
        Map<StyleInfo, Style> map = this.styleCache;
        synchronized (map) {
            File styleFile = this.dataDir().findOrCreateStyleSldFile(info);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(styleFile));){
                Styles.handler(info.getFormat()).encode(Styles.sld(style), info.getFormatVersion(), format, out);
                this.clear(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStyle(StyleInfo style, InputStream in) throws IOException {
        Map<StyleInfo, Style> map = this.styleCache;
        synchronized (map) {
            File styleFile = this.dataDir().findOrCreateStyleSldFile(style);
            ResourcePool.writeStyle(in, styleFile);
            this.clear(style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStyle(InputStream in, File styleFile) throws IOException {
        File temporaryFile = File.createTempFile(styleFile.getName(), null, styleFile.getParentFile());
        try (FilterOutputStream out = null;){
            out = new BufferedOutputStream(new FileOutputStream(temporaryFile));
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)out);
            ((BufferedOutputStream)out).flush();
        }
        try {
            IOUtils.rename(temporaryFile, styleFile);
        }
        finally {
            if (temporaryFile.exists()) {
                temporaryFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStyle(StyleInfo style, boolean purgeFile) throws IOException {
        Map<StyleInfo, Style> map = this.styleCache;
        synchronized (map) {
            File styleFile;
            if (purgeFile && (styleFile = this.dataDir().findStyleSldFile(style)) != null && styleFile.exists()) {
                styleFile.delete();
            }
        }
    }

    GeoServerDataDirectory dataDir() {
        return new GeoServerDataDirectory(this.catalog.getResourceLoader());
    }

    public void dispose() {
        this.crsCache.clear();
        this.dataStoreCache.clear();
        this.featureTypeCache.clear();
        this.featureTypeAttributeCache.clear();
        this.coverageReaderCache.clear();
        this.hintCoverageReaderCache.clear();
        this.wmsCache.clear();
        this.styleCache.clear();
        this.listeners.clear();
    }

    void fireDisposed(DataStoreInfo dataStore, DataAccess da) {
        for (Listener l : this.listeners) {
            try {
                l.disposed(dataStore, da);
            }
            catch (Throwable t) {
                LOGGER.warning("Resource pool listener threw error");
                LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
            }
        }
    }

    void fireDisposed(FeatureTypeInfo featureType, FeatureType ft) {
        for (Listener l : this.listeners) {
            try {
                l.disposed(featureType, ft);
            }
            catch (Throwable t) {
                LOGGER.warning("Resource pool listener threw error");
                LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
            }
        }
    }

    void fireDisposed(CoverageStoreInfo coverageStore, GridCoverageReader gcr) {
        for (Listener l : this.listeners) {
            try {
                l.disposed(coverageStore, gcr);
            }
            catch (Throwable t) {
                LOGGER.warning("Resource pool listener threw error");
                LOGGER.log(Level.INFO, t.getLocalizedMessage(), t);
            }
        }
    }

    protected void flushDataStore(FeatureTypeInfo ft) {
        DataAccess<? extends FeatureType, ? extends Feature> dataStore;
        DataStoreInfo ds = ft.getStore();
        if (ds == null) {
            return;
        }
        if (!this.dataStoreCache.containsKey(ds.getId())) {
            return;
        }
        try {
            dataStore = this.getDataStore(ds);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to obtain data store '" + ft.getQualifiedNativeName() + "' to flush", e);
            return;
        }
        int dsFtCount = this.countFeatureTypesOf(ds);
        if (dsFtCount == 0) {
            LOGGER.log(Level.FINE, "Feature Type {0} cleared: Disposing DataStore {1} - {2}", new String[]{ft.getName(), ds.getName(), "Last Feature Type Disposed"});
            this.clear(ds);
        } else if (dataStore instanceof ContentDataStore) {
            ContentDataStore contentDataStore = (ContentDataStore)dataStore;
            try {
                String nativeName = ft.getNativeName();
                if (nativeName != null) {
                    this.flushState(contentDataStore, nativeName);
                    LOGGER.log(Level.FINE, "Feature Type {0} cleared from ContentDataStore {1}", new String[]{ft.getName(), ds.getName()});
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to flush '" + ft.getQualifiedNativeName(), e);
            }
        } else {
            LOGGER.log(Level.FINE, "Unable to clean up cached feature type {0} in data store {1} - not a ContentDataStore", new String[]{ft.getName(), ds.getName()});
        }
    }

    private int countFeatureTypesOf(DataStoreInfo ds) {
        Filter filter = Predicates.equal("store.id", ds.getId());
        int dsTypeCount = this.catalog.count(FeatureTypeInfo.class, filter);
        return dsTypeCount;
    }

    private void flushState(ContentDataStore contentDataStore, String nativeName) throws IOException {
        ContentFeatureSource featureSource = contentDataStore.getFeatureSource(nativeName);
        featureSource.getState().flush();
    }

    static {
        try {
            VERSIONING_FS = Class.forName("org.geotools.data.VersioningFeatureSource");
            GS_VERSIONING_FS = Class.forName("org.vfny.geoserver.global.GeoServerVersioningFeatureSource");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FEATURETYPE_CACHE_SIZE_DEFAULT = 100;
    }

    public static interface Listener {
        public void disposed(DataStoreInfo var1, DataAccess var2);

        public void disposed(CoverageStoreInfo var1, GridCoverageReader var2);

        public void disposed(FeatureTypeInfo var1, FeatureType var2);
    }

    public class CacheClearingListener
    extends CatalogVisitorAdapter
    implements CatalogListener {
        @Override
        public void handleAddEvent(CatalogAddEvent event) {
        }

        @Override
        public void handleModifyEvent(CatalogModifyEvent event) {
        }

        @Override
        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            event.getSource().accept(this);
        }

        @Override
        public void handleRemoveEvent(CatalogRemoveEvent event) {
            CatalogInfo source = event.getSource();
            source.accept(this);
            if (source instanceof FeatureTypeInfo) {
                ResourcePool.this.flushDataStore((FeatureTypeInfo)source);
            }
        }

        @Override
        public void reloaded() {
        }

        @Override
        public void visit(DataStoreInfo dataStore) {
            ResourcePool.this.clear(dataStore);
        }

        @Override
        public void visit(CoverageStoreInfo coverageStore) {
            ResourcePool.this.clear(coverageStore);
        }

        @Override
        public void visit(FeatureTypeInfo featureType) {
            ResourcePool.this.clear(featureType);
        }

        @Override
        public void visit(WMSStoreInfo wmsStore) {
            ResourcePool.this.clear(wmsStore);
        }

        @Override
        public void visit(StyleInfo style) {
            ResourcePool.this.clear(style);
        }
    }

    class WMSCache
    extends CatalogResourceCache<String, WebMapServer> {
        WMSCache() {
        }

        @Override
        protected void dispose(String key, WebMapServer server) {
            HTTPClient client = server.getHTTPClient();
            if (client instanceof Closeable) {
                Closeable closeable = (Closeable)client;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failure while disposing the http client for a WMS store", e);
                }
            }
        }
    }

    class FeatureTypeAttributeCache
    extends CatalogResourceCache<String, List<AttributeTypeInfo>> {
        FeatureTypeAttributeCache(int size) {
            super(size);
        }

        @Override
        protected void dispose(String key, List<AttributeTypeInfo> object) {
        }
    }

    public static class CoverageHintReaderKey {
        String id;
        Hints hints;

        public CoverageHintReaderKey(String id, Hints hints) {
            this.id = id;
            this.hints = hints;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hints == null ? 0 : this.hints.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoverageHintReaderKey other = (CoverageHintReaderKey)obj;
            if (this.hints == null ? other.hints != null : !this.hints.equals((Object)other.hints)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    class CoverageHintReaderCache
    extends CatalogResourceCache<CoverageHintReaderKey, GridCoverageReader> {
        CoverageHintReaderCache() {
        }

        @Override
        protected void dispose(CoverageHintReaderKey key, GridCoverageReader reader) {
            CoverageStoreInfo info = ResourcePool.this.catalog.getCoverageStore(key.id);
            if (info != null) {
                String name = info.getName();
                LOGGER.fine("Disposing coverage store '" + name + "'");
                ResourcePool.this.fireDisposed(info, reader);
            }
            try {
                reader.dispose();
            }
            catch (Exception e) {
                LOGGER.warning("Error occured disposing coverage reader '" + info.getName() + "'");
                LOGGER.log(Level.FINE, "", e);
            }
        }
    }

    class CoverageReaderCache
    extends CatalogResourceCache<String, GridCoverageReader> {
        CoverageReaderCache() {
        }

        @Override
        protected void dispose(String id, GridCoverageReader reader) {
            CoverageStoreInfo info = ResourcePool.this.catalog.getCoverageStore(id);
            if (info != null) {
                String name = info.getName();
                LOGGER.fine("Disposing coverage store '" + name + "'");
                ResourcePool.this.fireDisposed(info, reader);
            }
            try {
                reader.dispose();
            }
            catch (Exception e) {
                LOGGER.warning("Error occured disposing coverage reader '" + info.getName() + "'");
                LOGGER.log(Level.FINE, "", e);
            }
        }
    }

    class DataStoreCache
    extends CatalogResourceCache<String, DataAccess> {
        DataStoreCache() {
        }

        @Override
        protected void dispose(String id, DataAccess dataAccess) {
            String name;
            DataStoreInfo info = ResourcePool.this.catalog.getDataStore(id);
            if (info != null) {
                name = info.getName();
                LOGGER.fine("Disposing datastore '" + name + "'");
                ResourcePool.this.fireDisposed(info, dataAccess);
            } else {
                name = "Untracked";
            }
            String implementation = dataAccess.getClass().getSimpleName();
            try {
                LOGGER.fine("Dispose data access '" + name + "' " + implementation);
                dataAccess.dispose();
            }
            catch (Exception e) {
                LOGGER.warning("Error occured disposing data access '" + name + "' " + implementation);
                LOGGER.log(Level.FINE, "", e);
            }
        }
    }

    class FeatureTypeCache
    extends CatalogResourceCache<String, FeatureType> {
        public FeatureTypeCache(int maxSize) {
            super(maxSize);
        }

        @Override
        protected void dispose(String key, FeatureType featureType) {
            String id = key.substring(0, key.indexOf(ResourcePool.PROJECTION_POLICY_SEPARATOR));
            FeatureTypeInfo info = ResourcePool.this.catalog.getFeatureType(id);
            if (info != null) {
                LOGGER.fine("Disposing feature type '" + info.getName() + "'/" + id);
                ResourcePool.this.fireDisposed(info, featureType);
                if (null != ResourcePool.this.featureTypeAttributeCache.remove(id)) {
                    LOGGER.fine("AttributeType cache cleared for feature type '" + info.getName() + "'/" + id + " as a side effect of its cache disposal");
                }
            }
        }
    }

    abstract class CatalogResourceCache<K, V>
    extends SoftValueHashMap<K, V> {
        public CatalogResourceCache() {
            this(100);
        }

        public CatalogResourceCache(int hardReferences) {
            super(hardReferences);
            this.cleaner = new SoftValueHashMap.ValueCleaner(){

                public void clean(Object key, Object object) {
                    CatalogResourceCache.this.dispose(key, object);
                }
            };
        }

        public V remove(Object key) {
            Object object = super.remove(key);
            if (object != null) {
                this.dispose(key, object);
            }
            return (V)object;
        }

        public void clear() {
            for (Map.Entry entry : this.entrySet()) {
                try {
                    this.dispose(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error dispoing entry: " + entry, e);
                }
            }
            super.clear();
        }

        protected abstract void dispose(K var1, V var2);
    }
}

